/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.testdo.date_time.DateTestEntity;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-date-time.xml")
public class DataContextEJBQLDateTimeFunctionalExpressionsIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private UnitDbAdapter unitDbAdapter;

    @Test
    public void testCURRENT_DATE() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        DateTestEntity o1 = this.context.newObject(DateTestEntity.class);
        cal.set(year - 3, 1, 1);
        o1.setDateColumn(cal.getTime());
        DateTestEntity o2 = this.context.newObject(DateTestEntity.class);
        cal.set(year + 3, 1, 1);
        o2.setDateColumn(cal.getTime());
        this.context.commitChanges();
        EJBQLQuery query = new EJBQLQuery("SELECT d FROM DateTestEntity d WHERE d.dateColumn > CURRENT_DATE");
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(o2));
    }

    @Test
    public void testCURRENT_TIME() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        DateTestEntity o1 = this.context.newObject(DateTestEntity.class);
        cal.set(year, month, day, 0, 0, 0);
        o1.setTimeColumn(cal.getTime());
        DateTestEntity o2 = this.context.newObject(DateTestEntity.class);
        cal.set(year, month, day, 23, 59, 59);
        o2.setTimeColumn(cal.getTime());
        this.context.commitChanges();
        EJBQLQuery query = new EJBQLQuery("SELECT d FROM DateTestEntity d WHERE d.timeColumn < CURRENT_TIME");
        List objects = this.context.performQuery(query);
        if (!this.unitDbAdapter.supportsTimeSqlType()) {
            return;
        }
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(o1));
    }

    @Test
    public void testCURRENT_TIMESTAMP() {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2);
        int date = cal.get(5);
        DateTestEntity o1 = this.context.newObject(DateTestEntity.class);
        cal.set(year, month, date, 0, 0, 0);
        o1.setTimestampColumn(cal.getTime());
        DateTestEntity o2 = this.context.newObject(DateTestEntity.class);
        cal.set(year, month, date, 23, 59, 59);
        o2.setTimestampColumn(cal.getTime());
        this.context.commitChanges();
        EJBQLQuery query = new EJBQLQuery("SELECT d FROM DateTestEntity d WHERE d.timestampColumn < CURRENT_TIMESTAMP");
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        Assert.assertTrue((boolean)objects.contains(o1));
    }
}

