/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.sql.Timestamp;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.testdo.testmap.ArtGroup;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.ArtistExhibit;
import org.apache.cayenne.testdo.testmap.Exhibit;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.testdo.testmap.PaintingInfo;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextDeleteRulesIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;

    @Override
    public void cleanUpDB() throws Exception {
        this.dbHelper.update("ARTGROUP").set("PARENT_GROUP_ID", null, 4).execute();
        super.cleanUpDB();
    }

    @Test
    public void testNullifyToOne() {
        ArtGroup parentGroup = (ArtGroup)this.context.newObject("ArtGroup");
        parentGroup.setName("Parent");
        ArtGroup childGroup = (ArtGroup)this.context.newObject("ArtGroup");
        childGroup.setName("Child");
        parentGroup.addToChildGroupsArray(childGroup);
        Assert.assertEquals((Object)parentGroup, (Object)childGroup.getToParentGroup());
        Assert.assertTrue((boolean)parentGroup.getChildGroupsArray().contains(childGroup));
        this.context.commitChanges();
        this.context.deleteObjects(childGroup);
        Assert.assertFalse((boolean)parentGroup.getChildGroupsArray().contains(childGroup));
        this.context.commitChanges();
    }

    @Test
    public void testCascadeToManyFlattened() {
        ArtGroup aGroup = this.context.newObject(ArtGroup.class);
        aGroup.setName("Group Name");
        Artist anArtist = this.context.newObject(Artist.class);
        anArtist.setArtistName("A Name");
        anArtist.addToGroupArray(aGroup);
        Assert.assertTrue((boolean)anArtist.getGroupArray().contains(aGroup));
        this.context.commitChanges();
        SQLTemplate checkQuery = new SQLTemplate(Artist.class, "SELECT * FROM ARTIST_GROUP");
        checkQuery.setFetchingDataRows(true);
        List joins1 = this.context.performQuery(checkQuery);
        Assert.assertEquals((long)1L, (long)joins1.size());
        this.context.deleteObjects(anArtist);
        Assert.assertEquals((long)6L, (long)aGroup.getPersistenceState());
        Assert.assertFalse((boolean)anArtist.getGroupArray().contains(aGroup));
        this.context.commitChanges();
        List joins2 = this.context.performQuery(checkQuery);
        Assert.assertEquals((long)0L, (long)joins2.size());
    }

    @Test
    public void testNullifyToManyFlattened() {
        ArtGroup aGroup = this.context.newObject(ArtGroup.class);
        aGroup.setName("Group Name");
        Artist anArtist = this.context.newObject(Artist.class);
        anArtist.setArtistName("A Name");
        aGroup.addToArtistArray(anArtist);
        this.context.commitChanges();
        Assert.assertTrue((boolean)aGroup.getArtistArray().contains(anArtist));
        Assert.assertTrue((boolean)anArtist.getGroupArray().contains(aGroup));
        SQLTemplate checkQuery = new SQLTemplate(Artist.class, "SELECT * FROM ARTIST_GROUP");
        checkQuery.setFetchingDataRows(true);
        List joins1 = this.context.performQuery(checkQuery);
        Assert.assertEquals((long)1L, (long)joins1.size());
        this.context.deleteObjects(aGroup);
        Assert.assertFalse((boolean)anArtist.getGroupArray().contains(aGroup));
        this.context.commitChanges();
        List joins2 = this.context.performQuery(checkQuery);
        Assert.assertEquals((long)0L, (long)joins2.size());
    }

    @Test
    public void testNullifyToMany() {
        ArtGroup parentGroup = (ArtGroup)this.context.newObject("ArtGroup");
        parentGroup.setName("Parent");
        ArtGroup childGroup = (ArtGroup)this.context.newObject("ArtGroup");
        childGroup.setName("Child");
        parentGroup.addToChildGroupsArray(childGroup);
        Assert.assertEquals((Object)parentGroup, (Object)childGroup.getToParentGroup());
        Assert.assertTrue((boolean)parentGroup.getChildGroupsArray().contains(childGroup));
        this.context.commitChanges();
        this.context.deleteObjects(parentGroup);
        Assert.assertNull((Object)childGroup.getToParentGroup());
        this.context.commitChanges();
    }

    @Test
    public void testCascadeToOne() {
        Painting painting = (Painting)this.context.newObject("Painting");
        painting.setPaintingTitle("A Title");
        PaintingInfo info = (PaintingInfo)this.context.newObject("PaintingInfo");
        painting.setToPaintingInfo(info);
        this.context.commitChanges();
        this.context.deleteObjects(painting);
        Assert.assertEquals((long)6L, (long)info.getPersistenceState());
        Assert.assertNull((Object)info.getPainting());
        Assert.assertNull((Object)painting.getToPaintingInfo());
        this.context.commitChanges();
    }

    @Test
    public void testCascadeToMany() {
        Artist anArtist = (Artist)this.context.newObject("Artist");
        anArtist.setArtistName("A Name");
        Exhibit anExhibit = (Exhibit)this.context.newObject("Exhibit");
        anExhibit.setClosingDate(new Timestamp(System.currentTimeMillis()));
        anExhibit.setOpeningDate(new Timestamp(System.currentTimeMillis()));
        Gallery gallery = (Gallery)this.context.newObject("Gallery");
        gallery.setGalleryName("A Name");
        anExhibit.setToGallery(gallery);
        ArtistExhibit artistExhibit = (ArtistExhibit)this.context.newObject("ArtistExhibit");
        artistExhibit.setToArtist(anArtist);
        artistExhibit.setToExhibit(anExhibit);
        this.context.commitChanges();
        this.context.deleteObjects(anArtist);
        Assert.assertEquals((long)6L, (long)artistExhibit.getPersistenceState());
        Assert.assertFalse((boolean)anArtist.getArtistExhibitArray().contains(artistExhibit));
        this.context.commitChanges();
    }

    @Test
    public void testDenyToMany() {
        Gallery gallery = (Gallery)this.context.newObject("Gallery");
        gallery.setGalleryName("A Name");
        Painting painting = (Painting)this.context.newObject("Painting");
        painting.setPaintingTitle("A Title");
        gallery.addToPaintingArray(painting);
        this.context.commitChanges();
        try {
            this.context.deleteObjects(gallery);
            Assert.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context.commitChanges();
    }
}

