/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.return_types.ReturnTypesMap1;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-return-types.xml")
public class DataContextCharTypeIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    private UnitDbAdapter unitDbAdapter;

    @Test
    public void testCharTrimming() {
        if (this.unitDbAdapter.supportsLobs()) {
            ReturnTypesMap1 map1 = this.context.newObject(ReturnTypesMap1.class);
            map1.setCharColumn("  text   ");
            ReturnTypesMap1 map2 = this.context.newObject(ReturnTypesMap1.class);
            map2.setCharColumn("  text");
            ReturnTypesMap1 map3 = this.context.newObject(ReturnTypesMap1.class);
            map3.setCharColumn("text     ");
            this.context.commitChanges();
            Expression qual = ReturnTypesMap1.CHAR_COLUMN.eq("  text");
            SelectQuery<ReturnTypesMap1> query = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class, qual);
            List result = this.context.performQuery(query);
            Assert.assertTrue((String)"CHAR type trimming is not valid.", (boolean)((ReturnTypesMap1)result.get(0)).getCharColumn().startsWith("  text"));
            Assert.assertTrue((String)"CHAR type trimming is not valid.", (boolean)((ReturnTypesMap1)result.get(1)).getCharColumn().startsWith("  text"));
            qual = ReturnTypesMap1.CHAR_COLUMN.eq("text");
            query = new SelectQuery<ReturnTypesMap1>(ReturnTypesMap1.class, qual);
            result = this.context.performQuery(query);
            Assert.assertTrue((String)"CHAR type trimming is not valid.", (boolean)((ReturnTypesMap1)result.get(0)).getCharColumn().startsWith("text"));
        }
    }
}

