/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.MockCallingBackListener;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextCallbacksIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private ServerRuntime runtime;

    @After
    public void tearDown() throws Exception {
        EntityResolver resolver = this.runtime.getDataDomain().getEntityResolver();
        resolver.getCallbackRegistry().clear();
    }

    @Test
    public void testPostAddCallbacks() {
        LifecycleCallbackRegistry registry = this.runtime.getDataDomain().getEntityResolver().getCallbackRegistry();
        Artist a1 = this.context.newObject(Artist.class);
        Assert.assertNotNull((Object)a1);
        Assert.assertFalse((boolean)a1.isPostAdded());
        registry.addCallback(LifecycleEvent.POST_ADD, Artist.class, "postAddCallback");
        Artist a2 = this.context.newObject(Artist.class);
        Assert.assertNotNull((Object)a2);
        Assert.assertTrue((boolean)a2.isPostAdded());
        MockCallingBackListener listener2 = new MockCallingBackListener();
        registry.addListener(LifecycleEvent.POST_ADD, Artist.class, listener2, "publicCallback");
        Artist a3 = this.context.newObject(Artist.class);
        Assert.assertNotNull((Object)a3);
        Assert.assertTrue((boolean)a3.isPostAdded());
        Assert.assertSame((Object)a3, (Object)listener2.getPublicCalledbackEntity());
        Painting p3 = this.context.newObject(Painting.class);
        Assert.assertNotNull((Object)p3);
        Assert.assertFalse((boolean)p3.isPostAdded());
        Assert.assertSame((Object)a3, (Object)listener2.getPublicCalledbackEntity());
    }

    @Test
    public void testPrePersistCallbacks() {
        LifecycleCallbackRegistry registry = this.runtime.getDataDomain().getEntityResolver().getCallbackRegistry();
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("1");
        Assert.assertFalse((boolean)a1.isPrePersisted());
        this.context.commitChanges();
        Assert.assertFalse((boolean)a1.isPrePersisted());
        registry.addCallback(LifecycleEvent.PRE_PERSIST, Artist.class, "prePersistCallback");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("2");
        Assert.assertFalse((boolean)a2.isPrePersisted());
        this.context.commitChanges();
        Assert.assertTrue((boolean)a2.isPrePersisted());
        MockCallingBackListener listener2 = new MockCallingBackListener();
        registry.addListener(LifecycleEvent.PRE_PERSIST, Artist.class, listener2, "publicCallback");
        Artist a3 = this.context.newObject(Artist.class);
        a3.setArtistName("3");
        Assert.assertNull((Object)listener2.getPublicCalledbackEntity());
        this.context.commitChanges();
        Assert.assertSame((Object)a3, (Object)listener2.getPublicCalledbackEntity());
    }

    @Test
    public void testPreRemoveCallbacks() {
        LifecycleCallbackRegistry registry = this.runtime.getDataDomain().getEntityResolver().getCallbackRegistry();
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("XX");
        this.context.commitChanges();
        this.context.deleteObjects(a1);
        Assert.assertFalse((boolean)a1.isPostAdded());
        Assert.assertFalse((boolean)a1.isPreRemoved());
        registry.addCallback(LifecycleEvent.PRE_REMOVE, Artist.class, "preRemoveCallback");
        Artist a2 = this.context.newObject(Artist.class);
        a2.setArtistName("XX");
        this.context.commitChanges();
        this.context.deleteObjects(a2);
        Assert.assertFalse((boolean)a2.isPostAdded());
        Assert.assertTrue((boolean)a2.isPreRemoved());
        MockCallingBackListener listener2 = new MockCallingBackListener();
        registry.addListener(LifecycleEvent.PRE_REMOVE, Artist.class, listener2, "publicCallback");
        Artist a3 = this.context.newObject(Artist.class);
        a3.setArtistName("XX");
        this.context.commitChanges();
        this.context.deleteObjects(a3);
        Assert.assertFalse((boolean)a3.isPostAdded());
        Assert.assertTrue((boolean)a3.isPreRemoved());
        Assert.assertSame((Object)a3, (Object)listener2.getPublicCalledbackEntity());
        Painting p3 = this.context.newObject(Painting.class);
        p3.setPaintingTitle("XX");
        this.context.commitChanges();
        this.context.deleteObjects(p3);
        Assert.assertFalse((boolean)p3.isPostAdded());
        Assert.assertFalse((boolean)p3.isPreRemoved());
        Assert.assertSame((Object)a3, (Object)listener2.getPublicCalledbackEntity());
    }
}

