/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.array_type.ArrayTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-array-type.xml")
public class DataContextArrayTypeIT
extends ServerCase {
    @Inject
    private DataContext context;

    @Test
    public void testDoubleArray() {
        ArrayTestEntity arrayTest = this.context.newObject(ArrayTestEntity.class);
        Object[] doubleArray = new Double[]{1.0, 2.0, 3.0};
        arrayTest.setDoubleArray((Double[])doubleArray);
        this.context.commitChanges();
        List res = this.context.performQuery(new SelectQuery<ArrayTestEntity>(ArrayTestEntity.class));
        ArrayTestEntity arrayRes = (ArrayTestEntity)res.get(0);
        Assert.assertNotNull((Object)arrayRes);
        Assert.assertNotNull((Object)arrayRes.getDoubleArray());
        Assert.assertArrayEquals((Object[])doubleArray, (Object[])arrayRes.getDoubleArray());
    }
}

