/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SelectById;
import org.apache.cayenne.testdo.relationships.MeaningfulFK;
import org.apache.cayenne.testdo.relationships.RelationshipHelper;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.validation.ValidationResult;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-relationships.xml")
public class MeaningfulFKIT
extends ServerCase {
    @Inject
    private ObjectContext context;

    @Test
    public void testValidateForSave1() throws Exception {
        MeaningfulFK testObject = this.context.newObject(MeaningfulFK.class);
        ValidationResult validation = new ValidationResult();
        testObject.validateForSave(validation);
        Assert.assertTrue((String)"Must fail validation due to missing required relationship", (boolean)validation.hasFailures());
        Assert.assertEquals((String)"Must fail validation due to missing required relationship", (long)1L, (long)validation.getFailures().size());
    }

    @Test
    public void testValidateForSave2() throws Exception {
        MeaningfulFK testObject = this.context.newObject(MeaningfulFK.class);
        RelationshipHelper related = this.context.newObject(RelationshipHelper.class);
        testObject.setToRelationshipHelper(related);
        ValidationResult validation = new ValidationResult();
        testObject.validateForSave(validation);
        Assert.assertFalse((boolean)validation.hasFailures());
    }

    @Test
    public void testMeaningfulFKSet() {
        MeaningfulFK testObject = this.context.newObject(MeaningfulFK.class);
        RelationshipHelper related = this.context.newObject(RelationshipHelper.class);
        testObject.setToRelationshipHelper(related);
        this.context.commitChanges();
        MeaningfulFK testObject2 = SelectById.query(MeaningfulFK.class, testObject.getObjectId()).selectOne(this.context);
        Assert.assertNotEquals((long)0L, (long)testObject2.getRelationshipHelperID());
    }
}

