/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.Cayenne;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.testdo.compound.CompoundPkTestEntity;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-compound.xml")
public class CompoundPkChangeIT
extends ServerCase {
    private static final String key1v1 = "-key1-v1-";
    private static final String key2v1 = "-key2-v1-";
    private static final String key1v2 = "-key1-v2-";
    private static final String key2v2 = "-key2-v2-";
    private static final String key1v3 = "-key1-v3-";
    private static final String key2v3 = "-key2-v3-";
    @Inject
    private DataContext context;

    @Test
    public void testCompoundPkChangeSingleElement() throws Exception {
        CompoundPkTestEntity object = this.context.newObject(CompoundPkTestEntity.class);
        CompoundPkTestEntity refreshedObject = null;
        object.setKey1(key1v1);
        object.setKey2(key2v1);
        object.setName("testing testing");
        this.context.commitChanges();
        Assert.assertEquals((Object)key1v1, (Object)object.getObjectId().getIdSnapshot().get("KEY1"));
        Assert.assertEquals((Object)key2v1, (Object)object.getObjectId().getIdSnapshot().get("KEY2"));
        ObjectIdQuery refetch = new ObjectIdQuery(object.getObjectId(), false, 2);
        refreshedObject = (CompoundPkTestEntity)Cayenne.objectForQuery(this.context, refetch);
        Assert.assertEquals((Object)object.getObjectId(), (Object)refreshedObject.getObjectId());
        object.setKey2(key2v2);
        this.context.commitChanges();
        Assert.assertEquals((Object)key1v1, (Object)object.getObjectId().getIdSnapshot().get("KEY1"));
        Assert.assertEquals((Object)key2v2, (Object)object.getObjectId().getIdSnapshot().get("KEY2"));
        ObjectIdQuery refetch1 = new ObjectIdQuery(object.getObjectId(), false, 2);
        refreshedObject = (CompoundPkTestEntity)Cayenne.objectForQuery(this.context, refetch1);
        Assert.assertEquals((Object)object.getObjectId(), (Object)refreshedObject.getObjectId());
        object.setKey2(key2v3);
        this.context.commitChanges();
        Assert.assertEquals((Object)key1v1, (Object)object.getObjectId().getIdSnapshot().get("KEY1"));
        Assert.assertEquals((Object)key2v3, (Object)object.getObjectId().getIdSnapshot().get("KEY2"));
        ObjectIdQuery refetch2 = new ObjectIdQuery(object.getObjectId(), false, 2);
        refreshedObject = (CompoundPkTestEntity)Cayenne.objectForQuery(this.context, refetch2);
        Assert.assertEquals((Object)object.getObjectId(), (Object)refreshedObject.getObjectId());
    }

    @Test
    public void testCompoundPkChangeAllElements() throws Exception {
        CompoundPkTestEntity object = this.context.newObject(CompoundPkTestEntity.class);
        CompoundPkTestEntity refreshedObject = null;
        object.setKey1(key1v1);
        object.setKey2(key2v1);
        object.setName("testing testing");
        this.context.commitChanges();
        Assert.assertEquals((Object)key1v1, (Object)object.getObjectId().getIdSnapshot().get("KEY1"));
        Assert.assertEquals((Object)key2v1, (Object)object.getObjectId().getIdSnapshot().get("KEY2"));
        ObjectIdQuery refetch = new ObjectIdQuery(object.getObjectId(), false, 2);
        refreshedObject = (CompoundPkTestEntity)Cayenne.objectForQuery(this.context, refetch);
        Assert.assertEquals((Object)object.getObjectId(), (Object)refreshedObject.getObjectId());
        object.setKey1(key1v2);
        object.setKey2(key2v2);
        this.context.commitChanges();
        Assert.assertEquals((Object)key1v2, (Object)object.getObjectId().getIdSnapshot().get("KEY1"));
        Assert.assertEquals((Object)key2v2, (Object)object.getObjectId().getIdSnapshot().get("KEY2"));
        ObjectIdQuery refetch1 = new ObjectIdQuery(object.getObjectId(), false, 2);
        refreshedObject = (CompoundPkTestEntity)Cayenne.objectForQuery(this.context, refetch1);
        Assert.assertEquals((Object)object.getObjectId(), (Object)refreshedObject.getObjectId());
        object.setKey1(key1v3);
        object.setKey2(key2v3);
        this.context.commitChanges();
        Assert.assertEquals((Object)key1v3, (Object)object.getObjectId().getIdSnapshot().get("KEY1"));
        Assert.assertEquals((Object)key2v3, (Object)object.getObjectId().getIdSnapshot().get("KEY2"));
        ObjectIdQuery refetch2 = new ObjectIdQuery(object.getObjectId(), false, 2);
        refreshedObject = (CompoundPkTestEntity)Cayenne.objectForQuery(this.context, refetch2);
        Assert.assertEquals((Object)object.getObjectId(), (Object)refreshedObject.getObjectId());
    }
}

