/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.sql.Timestamp;
import org.apache.cayenne.CayenneDOTestBase;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.types.ByteArrayTypeTest;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.ArtistExhibit;
import org.apache.cayenne.testdo.testmap.Exhibit;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.testdo.testmap.PaintingInfo;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class CDOOneDep2OneIT
extends CayenneDOTestBase {
    @Inject
    private ObjectContext context1;

    @Test
    public void testNewAdd1() throws Exception {
        Artist a1 = this.newArtist();
        PaintingInfo pi1 = this.newPaintingInfo();
        Painting p1 = this.newPainting();
        p1.setToArtist(a1);
        pi1.setPainting(p1);
        Assert.assertSame((Object)pi1, (Object)p1.getToPaintingInfo());
        Assert.assertSame((Object)p1, (Object)pi1.getPainting());
        this.context.commitChanges();
        this.context = this.context1;
        PaintingInfo pi2 = this.fetchPaintingInfo();
        Painting p2 = pi2.getPainting();
        Assert.assertNotNull((Object)p2);
        Assert.assertEquals((Object)"painting about nothing", (Object)p2.getPaintingTitle());
    }

    @Test
    public void testNewAdd2() throws Exception {
        Artist a1 = this.newArtist();
        Gallery g1 = this.context.newObject(Gallery.class);
        g1.setGalleryName("my gallery");
        Exhibit e1 = this.context.newObject(Exhibit.class);
        e1.setOpeningDate(new Timestamp(System.currentTimeMillis()));
        e1.setClosingDate(new Timestamp(System.currentTimeMillis()));
        e1.setToGallery(g1);
        ArtistExhibit ae1 = this.context.newObject(ArtistExhibit.class);
        ae1.setToArtist(a1);
        ae1.setToExhibit(e1);
        this.context.commitChanges();
    }

    @Test
    public void testReplace() throws Exception {
        String altPaintingName = "alt painting";
        PaintingInfo pi1 = this.newPaintingInfo();
        Painting p1 = this.newPainting();
        p1.setPaintingTitle(altPaintingName);
        pi1.setPainting(p1);
        Assert.assertTrue((boolean)this.context.hasChanges());
        this.context.commitChanges();
        this.context = this.context1;
        PaintingInfo pi2 = this.fetchPaintingInfo();
        Painting p21 = pi2.getPainting();
        Assert.assertNotNull((Object)p21);
        Assert.assertEquals((Object)altPaintingName, (Object)p21.getPaintingTitle());
        Assert.assertSame((Object)pi2, (Object)p21.getToPaintingInfo());
        ByteArrayTypeTest.assertByteArraysEqual(paintingImage, p21.getToPaintingInfo().getImageBlob());
        Painting p22 = this.newPainting();
        pi2.setPainting(p22);
        Assert.assertNull((Object)p21.getToPaintingInfo());
        Assert.assertSame((Object)pi2, (Object)p22.getToPaintingInfo());
        Assert.assertSame((Object)p22, (Object)pi2.getPainting());
        Assert.assertEquals((long)4L, (long)pi2.getPersistenceState());
        this.context.commitChanges();
        ObjectId pi2oid = pi2.getObjectId();
        this.context = this.context1;
        PaintingInfo pi3 = this.fetchPaintingInfo();
        Painting p3 = pi3.getPainting();
        Assert.assertNotNull((Object)p3);
        Assert.assertEquals((Object)"painting about nothing", (Object)p3.getPaintingTitle());
        Assert.assertSame((Object)pi3, (Object)p3.getToPaintingInfo());
        Assert.assertEquals((Object)pi2oid, (Object)pi3.getObjectId());
    }
}

