/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting1;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class CDOMany2OneNoRevIT
extends ServerCase {
    @Inject
    private ObjectContext context;

    @Test
    public void testNewAdd() throws Exception {
        Artist a1 = this.context.newObject(Artist.class);
        a1.setArtistName("a");
        Painting1 p1 = this.context.newObject(Painting1.class);
        p1.setPaintingTitle("p");
        p1.setToArtist(a1);
        Assert.assertSame((Object)a1, (Object)p1.getToArtist());
        this.context.commitChanges();
        ObjectId aid = a1.getObjectId();
        ObjectId pid = p1.getObjectId();
        this.context.invalidateObjects(a1, p1);
        Painting1 p2 = (Painting1)Cayenne.objectForPK(this.context, pid);
        Artist a2 = p2.getToArtist();
        Assert.assertNotNull((Object)a2);
        Assert.assertEquals((Object)aid, (Object)a2.getObjectId());
    }
}

