/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import com.mockrunner.mock.jdbc.MockDataSource;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.JNDIDataSourceFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.di.Injector;
import org.apache.cayenne.unit.JNDISetup;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class JNDIDataSourceFactoryIT
extends ServerCase {
    @Inject
    private Injector injector;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetDataSource_NameBound() throws Exception {
        DataNodeDescriptor descriptor = new DataNodeDescriptor();
        descriptor.setParameters("jdbc/TestDS");
        JNDISetup.doSetup();
        MockDataSource dataSource = new MockDataSource();
        InitialContext context = new InitialContext();
        context.bind(descriptor.getParameters(), (Object)dataSource);
        try {
            JNDIDataSourceFactory factory = new JNDIDataSourceFactory();
            this.injector.injectMembers((Object)factory);
            Assert.assertSame((Object)dataSource, (Object)factory.getDataSource(descriptor));
        }
        finally {
            context.unbind(descriptor.getParameters());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetDataSource_NameBoundWithPrefix() throws Exception {
        DataNodeDescriptor descriptor = new DataNodeDescriptor();
        descriptor.setParameters("jdbc/TestDS");
        JNDISetup.doSetup();
        MockDataSource dataSource = new MockDataSource();
        InitialContext context = new InitialContext();
        context.bind("java:comp/env/" + descriptor.getParameters(), (Object)dataSource);
        try {
            JNDIDataSourceFactory factory = new JNDIDataSourceFactory();
            this.injector.injectMembers((Object)factory);
            Assert.assertSame((Object)dataSource, (Object)factory.getDataSource(descriptor));
        }
        finally {
            context.unbind("java:comp/env/" + descriptor.getParameters());
        }
    }

    @Test
    public void testGetDataSource_NameNotBound() throws Exception {
        DataNodeDescriptor descriptor = new DataNodeDescriptor();
        descriptor.setParameters("jdbc/TestDS");
        JNDISetup.doSetup();
        JNDIDataSourceFactory factory = new JNDIDataSourceFactory();
        this.injector.injectMembers((Object)factory);
        try {
            factory.getDataSource(descriptor);
            Assert.fail((String)"Didn't throw on unbound name");
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }
}

