/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ashwood;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ashwood.AshwoodEntitySorter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class AshwoodEntitySorterIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    private EntityResolver resolver;
    private AshwoodEntitySorter sorter;
    private DbEntity artist;
    private DbEntity artistExhibit;
    private DbEntity exhibit;
    private DbEntity gallery;
    private DbEntity painting;
    private DbEntity paintingInfo;

    @Before
    public void before() {
        this.resolver = this.context.getEntityResolver();
        this.sorter = new AshwoodEntitySorter();
        this.sorter.setEntityResolver(this.resolver);
        this.artist = this.resolver.getDbEntity("ARTIST");
        this.artistExhibit = this.resolver.getDbEntity("ARTIST_EXHIBIT");
        this.exhibit = this.resolver.getDbEntity("EXHIBIT");
        this.gallery = this.resolver.getDbEntity("GALLERY");
        this.painting = this.resolver.getDbEntity("PAINTING");
        this.paintingInfo = this.resolver.getDbEntity("PAINTING_INFO");
    }

    @Test
    public void testSortDbEntities() {
        List<DbEntity> entities = Arrays.asList(this.artist, this.artistExhibit, this.exhibit, this.gallery, this.painting, this.paintingInfo);
        Collections.shuffle(entities);
        this.sorter.sortDbEntities(entities, false);
        Assert.assertTrue((entities.indexOf(this.artist) < entities.indexOf(this.artistExhibit) ? 1 : 0) != 0);
        Assert.assertTrue((entities.indexOf(this.artist) < entities.indexOf(this.painting) ? 1 : 0) != 0);
        Assert.assertTrue((entities.indexOf(this.gallery) < entities.indexOf(this.exhibit) ? 1 : 0) != 0);
        Assert.assertTrue((entities.indexOf(this.exhibit) < entities.indexOf(this.artistExhibit) ? 1 : 0) != 0);
        Assert.assertTrue((entities.indexOf(this.painting) < entities.indexOf(this.paintingInfo) ? 1 : 0) != 0);
    }
}

