/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.HashMap;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.ObjectStore;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ObjectStoreTest {
    private ObjectStore objectStore;

    @Before
    public void before() {
        DataRowStore sharedCache = (DataRowStore)Mockito.mock(DataRowStore.class);
        this.objectStore = new ObjectStore(sharedCache, new HashMap<Object, Persistent>());
    }

    @Test
    public void testRegisterNode() {
        ObjectId id = new ObjectId("E1", "ID", 500);
        Persistent object = (Persistent)Mockito.mock(Persistent.class);
        this.objectStore.registerNode(id, object);
        Assert.assertSame((Object)object, (Object)this.objectStore.getNode(id));
    }

    @Test
    public void testUnregisterNode() {
        ObjectId id = new ObjectId("E1", "ID", 500);
        Persistent object = (Persistent)Mockito.mock(Persistent.class);
        this.objectStore.registerNode(id, object);
        Object unregistered = this.objectStore.unregisterNode(id);
        Assert.assertSame((Object)object, (Object)unregistered);
        ((Persistent)Mockito.verify((Object)object, (VerificationMode)Mockito.times((int)0))).setObjectId(null);
        ((Persistent)Mockito.verify((Object)object)).setObjectContext(null);
        ((Persistent)Mockito.verify((Object)object)).setPersistenceState(1);
    }
}

