/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collections;
import java.util.HashMap;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.configuration.DefaultRuntimeProperties;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataRowStoreIT
extends ServerCase {
    private DataRowStore cache;

    @After
    public void cleanDataStore() {
        if (this.cache != null) {
            this.cache.shutdown();
            this.cache = null;
        }
    }

    @Test
    public void testDefaultConstructor() {
        this.cache = new DataRowStore("cacheXYZ", new DefaultRuntimeProperties(Collections.emptyMap()), null);
        Assert.assertEquals((Object)"cacheXYZ", (Object)this.cache.getName());
        Assert.assertNotNull((Object)this.cache.getSnapshotEventSubject());
        Assert.assertTrue((boolean)this.cache.getSnapshotEventSubject().getSubjectName().contains("cacheXYZ"));
    }

    @Test
    public void testMaxSize() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("cayenne.DataRowStore.snapshot.size", String.valueOf(2));
        this.cache = new DataRowStore("cacheXYZ", new DefaultRuntimeProperties(props), null);
        Assert.assertEquals((long)2L, (long)this.cache.maximumSize());
        Assert.assertEquals((long)0L, (long)this.cache.size());
        ObjectId key1 = new ObjectId("Artist", "ARTIST_ID", 1);
        HashMap<ObjectId, DataRow> diff1 = new HashMap<ObjectId, DataRow>();
        diff1.put(key1, new DataRow(1));
        ObjectId key2 = new ObjectId("Artist", "ARTIST_ID", 2);
        HashMap<ObjectId, DataRow> diff2 = new HashMap<ObjectId, DataRow>();
        diff2.put(key2, new DataRow(1));
        ObjectId key3 = new ObjectId("Artist", "ARTIST_ID", 3);
        HashMap<ObjectId, DataRow> diff3 = new HashMap<ObjectId, DataRow>();
        diff3.put(key3, new DataRow(1));
        this.cache.processSnapshotChanges(this, diff1, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        Assert.assertEquals((long)1L, (long)this.cache.size());
        this.cache.processSnapshotChanges(this, diff2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        Assert.assertEquals((long)2L, (long)this.cache.size());
        this.cache.processSnapshotChanges(this, diff3, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        Assert.assertEquals((long)2L, (long)this.cache.size());
        Assert.assertNotNull((Object)this.cache.getCachedSnapshot(key2));
        Assert.assertNotNull((Object)this.cache.getCachedSnapshot(key3));
        Assert.assertNull((Object)this.cache.getCachedSnapshot(key1));
    }
}

