/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextConcurrencyIT
extends ServerCase {
    private static final Logger logger = LoggerFactory.getLogger(DataContextConcurrencyIT.class);
    @Inject
    private ObjectContext context;

    @Test
    public void testCMEInContextSerialization() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            Artist artist = this.context.newObject(Artist.class);
            artist.setArtistName("name " + i);
        }
        final CountDownLatch startSignal = new CountDownLatch(1);
        final CountDownLatch serializationStartSignal = new CountDownLatch(1);
        ExecutorService service = Executors.newFixedThreadPool(2);
        Future<Boolean> resultObjectCreation = service.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    serializationStartSignal.await();
                }
                catch (InterruptedException e) {
                    return false;
                }
                for (int i = 0; i < 1000; ++i) {
                    Artist artist = DataContextConcurrencyIT.this.context.newObject(Artist.class);
                    DataContextConcurrencyIT.this.context.deleteObject(artist);
                }
                return true;
            }
        });
        Future<Boolean> resultSerialization = service.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    startSignal.await();
                }
                catch (InterruptedException e) {
                    return false;
                }
                for (int i = 0; i < 100; ++i) {
                    try {
                        Util.cloneViaSerialization(DataContextConcurrencyIT.this.context);
                        if (i != 0) continue;
                        serializationStartSignal.countDown();
                        continue;
                    }
                    catch (Exception e) {
                        logger.error("Serialization failed", (Throwable)e);
                        return false;
                    }
                }
                return true;
            }
        });
        Thread.sleep(10L);
        startSignal.countDown();
        Assert.assertTrue((boolean)resultObjectCreation.get(20L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)resultSerialization.get(20L, TimeUnit.SECONDS));
    }
}

