/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.CayenneContext;
import org.apache.cayenne.CayenneContextGraphManager;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CayenneContextGraphManagerTest {
    private CayenneContextGraphManager graphManager;

    @Before
    public void before() {
        CayenneContext mockContext = (CayenneContext)Mockito.mock(CayenneContext.class);
        this.graphManager = new CayenneContextGraphManager(mockContext, false, false);
    }

    @Test
    public void testRegisterNode() {
        ObjectId id = new ObjectId("E1", "ID", 500);
        Persistent object = (Persistent)Mockito.mock(Persistent.class);
        this.graphManager.registerNode(id, object);
        Assert.assertSame((Object)object, (Object)this.graphManager.getNode(id));
    }

    @Test
    public void testUnregisterNode() {
        ObjectId id = new ObjectId("E1", "ID", 500);
        Persistent object = (Persistent)Mockito.mock(Persistent.class);
        this.graphManager.registerNode(id, object);
        Object unregistered = this.graphManager.unregisterNode(id);
        Assert.assertSame((Object)object, (Object)unregistered);
        ((Persistent)Mockito.verify((Object)object, (VerificationMode)Mockito.times((int)0))).setObjectId(null);
        ((Persistent)Mockito.verify((Object)object)).setObjectContext(null);
        ((Persistent)Mockito.verify((Object)object)).setPersistenceState(1);
    }
}

