/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.testdo.testmap.ArtGroup;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class CDOReflexiveRelDeleteIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    private ArtGroup parentGroup;
    private ArtGroup childGroup1;
    private ArtGroup childGroup2;
    private ArtGroup childGroup3;

    @Before
    public void setUp() throws Exception {
        this.parentGroup = this.context.newObject(ArtGroup.class);
        this.parentGroup.setName("parent");
        this.childGroup1 = this.context.newObject(ArtGroup.class);
        this.childGroup1.setName("child1");
        this.childGroup1.setToParentGroup(this.parentGroup);
        this.childGroup2 = this.context.newObject(ArtGroup.class);
        this.childGroup2.setName("child2");
        this.childGroup2.setToParentGroup(this.parentGroup);
        this.childGroup3 = this.context.newObject(ArtGroup.class);
        this.childGroup3.setName("subchild");
        this.childGroup3.setToParentGroup(this.childGroup1);
        this.context.commitChanges();
    }

    @Test
    public void testReflexiveRelationshipDelete1() {
        this.context.deleteObjects(this.parentGroup);
        this.context.deleteObjects(this.childGroup1);
        this.context.deleteObjects(this.childGroup2);
        this.context.deleteObjects(this.childGroup3);
        this.context.commitChanges();
    }

    @Test
    public void testReflexiveRelationshipDelete2() {
        this.context.deleteObjects(this.childGroup1);
        this.context.deleteObjects(this.parentGroup);
        this.context.deleteObjects(this.childGroup2);
        this.context.deleteObjects(this.childGroup3);
        this.context.commitChanges();
    }

    @Test
    public void testReflexiveRelationshipDelete3() {
        this.context.deleteObjects(this.childGroup1);
        this.context.deleteObjects(this.childGroup3);
        this.context.deleteObjects(this.parentGroup);
        this.context.deleteObjects(this.childGroup2);
        this.context.commitChanges();
    }

    @Test
    public void testReflexiveRelationshipDelete4() {
        this.context.deleteObjects(this.childGroup3);
        this.context.deleteObjects(this.parentGroup);
        this.context.deleteObjects(this.childGroup1);
        this.context.deleteObjects(this.childGroup2);
        this.context.commitChanges();
    }
}

