/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import org.apache.cayenne.Cayenne;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.testdo.relationships_to_many_fk.ToManyFkDep;
import org.apache.cayenne.testdo.relationships_to_many_fk.ToManyFkRoot;
import org.apache.cayenne.testdo.relationships_to_many_fk.ToManyRoot2;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-relationships-to-many-fk.xml")
public class CDOOneToManyFKIT
extends ServerCase {
    @Inject
    protected DataContext context;

    @Test
    public void testReadRelationship() throws Exception {
        ToManyRoot2 src2 = this.context.newObject(ToManyRoot2.class);
        ToManyFkRoot src = this.context.newObject(ToManyFkRoot.class);
        src.setDepId(new Integer(1));
        ToManyFkDep target = this.context.newObject(ToManyFkDep.class);
        target.setDepId(new Integer(1));
        target.setRoot2(src2);
        src.addToDeps(target);
        this.context.commitChanges();
        this.context.invalidateObjects(src, target, src2);
        ToManyFkRoot src1 = (ToManyFkRoot)Cayenne.objectForPK(this.context, src.getObjectId());
        Assert.assertNotNull(src1.getDeps());
        Assert.assertEquals((long)1L, (long)src1.getDeps().size());
        Assert.assertSame((Object)src1, (Object)src1.getDeps().get(0).getRoot());
        this.context.invalidateObjects(src1, src1.getDeps().get(0));
        ToManyFkDep target2 = (ToManyFkDep)Cayenne.objectForPK(this.context, target.getObjectId());
        Assert.assertNotNull((Object)target2.getRoot());
        Assert.assertSame((Object)target2, (Object)target2.getRoot().getDeps().get(0));
    }
}

