/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.apache.cayenne.ExtendedEnumeration;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.TypesMapping;

public class EnumType<T extends Enum<T>>
implements ExtendedType<T> {
    protected Class<T> enumClass;
    protected T[] values;
    protected String canonicalName;

    public EnumType(Class<T> enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException("Null enum class");
        }
        this.enumClass = enumClass;
        this.canonicalName = enumClass.getCanonicalName();
        try {
            Method m = enumClass.getMethod("values", new Class[0]);
            this.values = (Enum[])m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Class " + enumClass.getName() + " is not an Enum", e);
        }
    }

    @Override
    public String getClassName() {
        return this.canonicalName;
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, T value, int pos, int type, int precision) throws Exception {
        if (value != null) {
            if (TypesMapping.isNumeric(type)) {
                statement.setInt(pos, ((Enum)value).ordinal());
            } else {
                statement.setString(pos, ((Enum)value).name());
            }
        } else {
            statement.setNull(pos, type);
        }
    }

    @Override
    public T materializeObject(ResultSet rs, int index, int type) throws Exception {
        if (TypesMapping.isNumeric(type)) {
            int i = rs.getInt(index);
            return rs.wasNull() || index < 0 ? null : (T)this.values[i];
        }
        String string = rs.getString(index);
        return string != null ? (T)Enum.valueOf(this.enumClass, string) : null;
    }

    @Override
    public T materializeObject(CallableStatement rs, int index, int type) throws Exception {
        if (TypesMapping.isNumeric(type)) {
            int i = rs.getInt(index);
            return rs.wasNull() || index < 0 ? null : (T)this.values[i];
        }
        String string = rs.getString(index);
        return string != null ? (T)Enum.valueOf(this.enumClass, string) : null;
    }

    @Override
    public String toString(T value) {
        if (value == null) {
            return "NULL";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(((Enum)value).name());
        if (value instanceof ExtendedEnumeration) {
            buffer.append("=");
            Object dbValue = ((ExtendedEnumeration)value).getDatabaseValue();
            if (dbValue instanceof String) {
                buffer.append("'");
            }
            buffer.append(value);
            if (dbValue instanceof String) {
                buffer.append("'");
            }
        }
        return buffer.toString();
    }
}

