/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util.concurrentlinkedhashmap;

import org.apache.cayenne.util.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import org.junit.Assert;
import org.junit.Test;

public class ConcurrentLinkedHashMapTest {
    @Test
    public void testPutGet() {
        ConcurrentLinkedHashMap<String, Integer> m = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(10).build();
        Assert.assertEquals((long)0L, (long)m.size());
        m.put("k1", 100);
        Assert.assertEquals((long)1L, (long)m.size());
        Assert.assertNull(m.get("nosuchkey"));
        Assert.assertEquals((Object)100, m.get("k1"));
        m.put("k2", 200);
        Assert.assertEquals((long)2L, (long)m.size());
        Assert.assertEquals((Object)200, m.get("k2"));
    }

    @Test
    public void testLRU() {
        ConcurrentLinkedHashMap<String, Integer> m = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(5).build();
        Assert.assertEquals((long)0L, (long)m.size());
        m.put("k1", 100);
        Assert.assertEquals((long)1L, (long)m.size());
        m.put("k2", 101);
        Assert.assertEquals((long)2L, (long)m.size());
        m.put("k3", 102);
        Assert.assertEquals((long)3L, (long)m.size());
        m.put("k4", 103);
        Assert.assertEquals((long)4L, (long)m.size());
        m.put("k5", 104);
        Assert.assertEquals((long)5L, (long)m.size());
        m.put("k6", 105);
        Assert.assertEquals((long)5L, (long)m.size());
        m.put("k7", 106);
        Assert.assertEquals((long)5L, (long)m.size());
        m.put("k8", 107);
        Assert.assertEquals((long)5L, (long)m.size());
        m.remove("k6");
        Assert.assertEquals((long)4L, (long)m.size());
    }
}

