/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class SelectQueryFetchLimitOrderingIT
extends ServerCase {
    @Inject
    protected ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
    }

    protected void creatArtistsDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "c"});
        this.tArtist.insert(new Object[]{33002, "b"});
        this.tArtist.insert(new Object[]{33003, "f"});
        this.tArtist.insert(new Object[]{33004, "d"});
        this.tArtist.insert(new Object[]{33005, "a"});
        this.tArtist.insert(new Object[]{33006, "e"});
    }

    @Test
    public void testOrdering() throws Exception {
        this.creatArtistsDataSet();
        SelectQuery query = new SelectQuery("Artist");
        query.addOrdering(Artist.ARTIST_NAME.asc());
        query.setFetchLimit(4);
        List results = this.context.performQuery(query);
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertEquals((Object)"a", (Object)((Artist)results.get(0)).getArtistName());
        Assert.assertEquals((Object)"b", (Object)((Artist)results.get(1)).getArtistName());
        Assert.assertEquals((Object)"c", (Object)((Artist)results.get(2)).getArtistName());
        Assert.assertEquals((Object)"d", (Object)((Artist)results.get(3)).getArtistName());
    }
}

