/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.datasource;

import java.sql.Driver;
import java.sql.SQLException;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.datasource.DriverDataSource;
import org.apache.cayenne.datasource.PoolingDataSourceParameters;
import org.apache.cayenne.datasource.UnmanagedPoolingDataSource;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.After;
import org.junit.Before;

@UseServerRuntime(value="cayenne-testmap.xml")
public class BasePoolingDataSourceIT
extends ServerCase {
    protected static final long QUEUE_WAIT_TIME = 1000L;
    @Inject
    private DataSourceInfo dataSourceInfo;
    @Inject
    private AdhocObjectFactory objectFactory;
    protected UnmanagedPoolingDataSource dataSource;

    @Before
    public void before() throws SQLException {
        Driver driver = (Driver)this.objectFactory.newInstance(Driver.class, this.dataSourceInfo.getJdbcDriver());
        DriverDataSource nonPooling = new DriverDataSource(driver, this.dataSourceInfo.getDataSourceUrl(), this.dataSourceInfo.getUserName(), this.dataSourceInfo.getPassword());
        PoolingDataSourceParameters poolParameters = this.createParameters();
        this.dataSource = new UnmanagedPoolingDataSource(nonPooling, poolParameters);
    }

    @After
    public void after() throws SQLException {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    protected PoolingDataSourceParameters createParameters() {
        PoolingDataSourceParameters poolParameters = new PoolingDataSourceParameters();
        poolParameters.setMinConnections(2);
        poolParameters.setMaxConnections(3);
        poolParameters.setMaxQueueWaitTime(1000L);
        return poolParameters;
    }
}

