/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.ashwood;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ashwood.AshwoodEntitySorter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.unit.di.server.PeopleProjectCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-people.xml")
public class AshwoodEntitySorter_InheritanceIT
extends PeopleProjectCase {
    @Inject
    protected ObjectContext context;
    private EntityResolver resolver;
    private AshwoodEntitySorter sorter;
    private DbEntity address;
    private DbEntity clientCompany;
    private DbEntity department;
    private DbEntity person;
    private DbEntity personNotes;

    @Before
    public void before() {
        this.resolver = this.context.getEntityResolver();
        this.sorter = new AshwoodEntitySorter();
        this.sorter.setEntityResolver(this.resolver);
        this.address = this.resolver.getDbEntity("ADDRESS");
        this.clientCompany = this.resolver.getDbEntity("CLIENT_COMPANY");
        this.department = this.resolver.getDbEntity("DEPARTMENT");
        this.person = this.resolver.getDbEntity("PERSON");
        this.personNotes = this.resolver.getDbEntity("PERSON_NOTES");
    }

    @Test
    public void testSortDbEntities() {
        List<DbEntity> entities = Arrays.asList(this.address, this.clientCompany, this.department, this.person, this.personNotes);
        Collections.shuffle(entities);
        this.sorter.sortDbEntities(entities, false);
        Assert.assertTrue((entities.indexOf(this.person) < entities.indexOf(this.personNotes) ? 1 : 0) != 0);
        Assert.assertTrue((entities.indexOf(this.clientCompany) < entities.indexOf(this.person) ? 1 : 0) != 0);
        Assert.assertTrue((entities.indexOf(this.person) < entities.indexOf(this.address) ? 1 : 0) != 0);
    }
}

