/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import com.mockrunner.mock.jdbc.MockResultSet;
import java.sql.ResultSet;
import org.apache.cayenne.access.types.EnumType;
import org.apache.cayenne.access.types.InnerEnumHolder;
import org.apache.cayenne.access.types.MockEnum;
import org.junit.Assert;
import org.junit.Test;

public class EnumTypeTest {
    @Test
    public void testConstructor() throws Exception {
        EnumType<MockEnum> type = new EnumType<MockEnum>(MockEnum.class);
        Assert.assertEquals((Object)MockEnum.class.getName(), (Object)type.getClassName());
        Assert.assertEquals((long)MockEnum.values().length, (long)type.values.length);
        for (int i = 0; i < MockEnum.values().length; ++i) {
            Assert.assertSame((Object)((Object)MockEnum.values()[i]), type.values[i]);
        }
    }

    @Test
    public void testInvalidConstructor1() throws Exception {
        try {
            new EnumType<Object>(Object.class);
            Assert.fail((String)"Non-enum class went through");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidConstructor2() throws Exception {
        try {
            new EnumType(null);
            Assert.fail((String)"Null class went through");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMaterializeStringObject() throws Exception {
        EnumType<MockEnum> type = new EnumType<MockEnum>(MockEnum.class);
        MockResultSet rs = new MockResultSet("Test");
        rs.addColumn("Enum");
        rs.addRow(new Object[]{"b"});
        rs.next();
        Object o = type.materializeObject((ResultSet)rs, 1, 12);
        Assert.assertSame((Object)((Object)MockEnum.b), (Object)o);
    }

    @Test
    public void testMaterializeNumericObject() throws Exception {
        EnumType<MockEnum> type = new EnumType<MockEnum>(MockEnum.class);
        MockResultSet rs = new MockResultSet("Test");
        rs.addColumn("Enum");
        rs.addRow(new Object[]{new Integer(2)});
        rs.next();
        Object o = type.materializeObject((ResultSet)rs, 1, 2);
        Assert.assertSame((Object)((Object)MockEnum.c), (Object)o);
    }

    @Test
    public void testMaterializeStringObjectInnerEnum() throws Exception {
        EnumType<InnerEnumHolder.InnerEnum> type = new EnumType<InnerEnumHolder.InnerEnum>(InnerEnumHolder.InnerEnum.class);
        MockResultSet rs = new MockResultSet("Test");
        rs.addColumn("Enum");
        rs.addRow(new Object[]{"b"});
        rs.next();
        Object o = type.materializeObject((ResultSet)rs, 1, 12);
        Assert.assertSame((Object)((Object)InnerEnumHolder.InnerEnum.b), (Object)o);
    }

    @Test
    public void testMaterializeNumericObjectInnerEnum() throws Exception {
        EnumType<InnerEnumHolder.InnerEnum> type = new EnumType<InnerEnumHolder.InnerEnum>(InnerEnumHolder.InnerEnum.class);
        MockResultSet rs = new MockResultSet("Test");
        rs.addColumn("Enum");
        rs.addRow(new Object[]{new Integer(2)});
        rs.next();
        Object o = type.materializeObject((ResultSet)rs, 1, 2);
        Assert.assertSame((Object)((Object)InnerEnumHolder.InnerEnum.c), (Object)o);
    }
}

