/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.select;

import java.util.Arrays;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.TstQueryAssembler;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.FunctionExpressionFactory;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.query.MockQuery;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Exhibit;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.ServerCaseDataSourceFactory;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class QualifierTranslatorIT
extends ServerCase {
    @Inject
    private DataNode node;
    @Inject
    private ServerCaseDataSourceFactory dataSourceFactory;

    @Test
    public void testNonQualifiedQuery() throws Exception {
        TstQueryAssembler qa = new TstQueryAssembler(new MockQuery(), this.node.getAdapter(), this.node.getEntityResolver());
        try {
            new QualifierTranslator(qa).appendPart(new StringBuilder());
            Assert.fail();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Test
    public void testNullQualifier() throws Exception {
        TstQueryAssembler qa = new TstQueryAssembler(new SelectQuery(), this.node.getAdapter(), this.node.getEntityResolver());
        StringBuilder out = new StringBuilder();
        new QualifierTranslator(qa).appendPart(out);
        Assert.assertEquals((long)0L, (long)out.length());
    }

    @Test
    public void testBinary_In1() throws Exception {
        this.doExpressionTest(Exhibit.class, "toGallery.galleryName in ('g1', 'g2', 'g3')", "ta.GALLERY_NAME IN (?, ?, ?)");
    }

    @Test
    public void testBinary_In2() throws Exception {
        Expression exp = ExpressionFactory.inExp("toGallery.galleryName", Arrays.asList("g1", "g2", "g3"));
        this.doExpressionTest(Exhibit.class, exp, "ta.GALLERY_NAME IN (?, ?, ?)");
    }

    @Test
    public void testBinary_In3() throws Exception {
        Expression exp = ExpressionFactory.inExp("toGallery.galleryName", "g1", "g2", "g3");
        this.doExpressionTest(Exhibit.class, exp, "ta.GALLERY_NAME IN (?, ?, ?)");
    }

    @Test
    public void testBinary_Like() throws Exception {
        this.doExpressionTest(Exhibit.class, "toGallery.galleryName like 'a%'", "ta.GALLERY_NAME LIKE ?");
    }

    @Test
    public void testBinary_LikeIgnoreCase() throws Exception {
        this.doExpressionTest(Exhibit.class, "toGallery.galleryName likeIgnoreCase 'a%'", "UPPER(ta.GALLERY_NAME) LIKE UPPER(?)");
    }

    @Test
    public void testBinary_IsNull() throws Exception {
        this.doExpressionTest(Exhibit.class, "toGallery.galleryName = null", "ta.GALLERY_NAME IS NULL");
    }

    @Test
    public void testBinary_IsNotNull() throws Exception {
        this.doExpressionTest(Exhibit.class, "toGallery.galleryName != null", "ta.GALLERY_NAME IS NOT NULL");
    }

    @Test
    public void testTernary_Between() throws Exception {
        this.doExpressionTest(Painting.class, "estimatedPrice between 3000 and 15000", "ta.ESTIMATED_PRICE BETWEEN ? AND ?");
    }

    @Test
    public void testExtras() throws Exception {
        ObjectId oid1 = new ObjectId("Gallery", "GALLERY_ID", 1);
        ObjectId oid2 = new ObjectId("Gallery", "GALLERY_ID", 2);
        Gallery g1 = new Gallery();
        Gallery g2 = new Gallery();
        g1.setObjectId(oid1);
        g2.setObjectId(oid2);
        Expression e1 = ExpressionFactory.matchExp("toGallery", (Object)g1);
        Expression e2 = e1.orExp(ExpressionFactory.matchExp("toGallery", (Object)g2));
        this.doExpressionTest(Exhibit.class, e2, "(ta.GALLERY_ID = ?) OR (ta.GALLERY_ID = ?)");
    }

    @Test
    public void testTrim() throws Exception {
        Expression exp = FunctionExpressionFactory.trimExp(Artist.ARTIST_NAME.path());
        Property<String> property = Property.create("trimmedName", exp, String.class);
        this.doExpressionTest(Artist.class, property.like("P%"), "TRIM(ta.ARTIST_NAME) LIKE ?");
    }

    @Test
    public void testConcat() throws Exception {
        Expression exp = FunctionExpressionFactory.concatExp("artistName", "dateOfBirth");
        Property<String> property = Property.create("concatNameAndDate", exp, String.class);
        this.doExpressionTest(Artist.class, property.like("P%"), "CONCAT(ta.ARTIST_NAME, ta.DATE_OF_BIRTH) LIKE ?");
    }

    private void doExpressionTest(Class<?> queryType, String qualifier, String expectedSQL) throws Exception {
        this.doExpressionTest(queryType, ExpressionFactory.exp(qualifier, new Object[0]), expectedSQL);
    }

    private void doExpressionTest(Class<?> queryType, Expression qualifier, String expectedSQL) throws Exception {
        SelectQuery q = new SelectQuery(queryType);
        q.setQualifier(qualifier);
        TstQueryAssembler qa = new TstQueryAssembler(q, this.node.getAdapter(), this.node.getEntityResolver());
        StringBuilder out = new StringBuilder();
        String translated = new QualifierTranslator(qa).appendPart(out).toString();
        Assert.assertEquals((Object)expectedSQL, (Object)translated);
    }
}

