/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.HashSet;
import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextEJBQLJoinsIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tPainting;
    protected TableHelper tGallery;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "GALLERY_ID", "PAINTING_TITLE", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, -5, 4, 12, 3});
        this.tGallery = new TableHelper(this.dbHelper, "GALLERY");
        this.tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
    }

    private void createFourArtistsFourPaintings() throws Exception {
        this.tArtist.insert(new Object[]{33001, "AA1"});
        this.tArtist.insert(new Object[]{33002, "AA2"});
        this.tArtist.insert(new Object[]{33003, "BB1"});
        this.tArtist.insert(new Object[]{33004, "BB2"});
        this.tPainting.insert(new Object[]{33001, 33001, null, "P1", 3000});
        this.tPainting.insert(new Object[]{33002, 33002, null, "P2", 5000});
        this.tPainting.insert(new Object[]{33003, 33001, null, "AA1", 3000});
        this.tPainting.insert(new Object[]{33004, 33002, null, "BB2", 3000});
    }

    private void createTwoArtistsOnePainting() throws Exception {
        this.tArtist.insert(new Object[]{33001, "AA1"});
        this.tArtist.insert(new Object[]{33005, "AA1"});
        this.tPainting.insert(new Object[]{33001, 33001, null, "P1", 3000});
    }

    private void createTwoArtistsTwoPaintingsTwoGalleries() throws Exception {
        this.tArtist.insert(new Object[]{33001, "AA1"});
        this.tArtist.insert(new Object[]{33002, "AA2"});
        this.tGallery.insert(new Object[]{33001, "gallery1"});
        this.tGallery.insert(new Object[]{33002, "gallery2"});
        this.tPainting.insert(new Object[]{33005, 33001, 33001, "CC1", 5000});
        this.tPainting.insert(new Object[]{33006, 33002, 33002, "CC2", 5000});
    }

    private void createTwoArtistsThreePaintings() throws Exception {
        this.tArtist.insert(new Object[]{33001, "AA1"});
        this.tArtist.insert(new Object[]{33002, "AA2"});
        this.tPainting.insert(new Object[]{33001, 33001, null, "P1", 3000});
        this.tPainting.insert(new Object[]{33002, 33002, null, "P2", 5000});
        this.tPainting.insert(new Object[]{33007, 33001, null, "P2", 5000});
    }

    @Test
    public void testThetaJoins() throws Exception {
        this.createFourArtistsFourPaintings();
        String ejbql = "SELECT DISTINCT a FROM Artist a, Painting b WHERE a.artistName = b.paintingTitle";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List artists = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)artists.size());
        HashSet<String> names = new HashSet<String>(2);
        for (Artist a : artists) {
            names.add(a.getArtistName());
        }
        Assert.assertTrue((boolean)names.contains("AA1"));
        Assert.assertTrue((boolean)names.contains("BB2"));
    }

    @Test
    public void testInnerJoins() throws Exception {
        this.createTwoArtistsOnePainting();
        String ejbql = "SELECT a FROM Artist a INNER JOIN a.paintingArray p WHERE a.artistName = 'AA1'";
        List artists = this.context.performQuery(new EJBQLQuery(ejbql));
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((long)33001L, (long)Cayenne.intPKForObject((Artist)artists.get(0)));
    }

    @Test
    public void testOuterJoins() throws Exception {
        this.createTwoArtistsOnePainting();
        String ejbql = "SELECT a FROM Artist a LEFT JOIN a.paintingArray p WHERE a.artistName = 'AA1'";
        List artists = this.context.performQuery(new EJBQLQuery(ejbql));
        Assert.assertEquals((long)2L, (long)artists.size());
        HashSet<Object> ids = new HashSet<Object>(2);
        for (Artist a : artists) {
            ids.add(Cayenne.pkForObject(a));
        }
        Assert.assertTrue((boolean)ids.contains(33001L));
        Assert.assertTrue((boolean)ids.contains(33005L));
    }

    @Test
    public void testChainedJoins() throws Exception {
        this.createTwoArtistsTwoPaintingsTwoGalleries();
        String ejbql = "SELECT a FROM Artist a JOIN a.paintingArray p JOIN p.toGallery g WHERE g.galleryName = 'gallery2'";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List artists = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject((Artist)artists.get(0)));
    }

    @Test
    public void testImplicitJoins() throws Exception {
        this.createTwoArtistsTwoPaintingsTwoGalleries();
        String ejbql = "SELECT a FROM Artist a WHERE a.paintingArray.toGallery.galleryName = 'gallery2'";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List artists = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject((Artist)artists.get(0)));
    }

    @Test
    public void testImplicitJoins_OUTER_LastComponent() throws Exception {
        this.tArtist.insert(new Object[]{33001, "AA1"});
        this.tArtist.insert(new Object[]{33002, "AA2"});
        this.tPainting.insert(new Object[]{33005, 33001, null, "CC1", 5000});
        this.tPainting.insert(new Object[]{33006, 33001, null, "CC2", 5000});
        String ejbql = "SELECT a FROM Artist a WHERE a.paintingArray+ is null";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List artists = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject((Artist)artists.get(0)));
    }

    @Test
    public void testImplicitJoins_OUTER_InTheMiddle() throws Exception {
        this.tGallery.insert(new Object[]{33001, "gallery1"});
        this.tGallery.insert(new Object[]{33002, "gallery2"});
        this.tArtist.insert(new Object[]{33001, "AA1"});
        this.tArtist.insert(new Object[]{33002, "AA2"});
        this.tPainting.insert(new Object[]{33005, 33001, 33001, "CC1", 5000});
        this.tPainting.insert(new Object[]{33006, 33001, 33002, "CC2", 5000});
        String ejbql = "SELECT a FROM Artist a WHERE a.paintingArray+.toGallery is null";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List artists = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject((Artist)artists.get(0)));
    }

    @Test
    public void testPartialImplicitJoins1() throws Exception {
        this.createTwoArtistsTwoPaintingsTwoGalleries();
        String ejbql = "SELECT a FROM Artist a JOIN a.paintingArray b WHERE a.paintingArray.toGallery.galleryName = 'gallery2'";
        List artists = this.context.performQuery(new EJBQLQuery(ejbql));
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject((Artist)artists.get(0)));
    }

    @Test
    public void testPartialImplicitJoins2() throws Exception {
        this.createTwoArtistsTwoPaintingsTwoGalleries();
        String ejbql = "SELECT a FROM Artist a JOIN a.paintingArray b WHERE a.paintingArray.paintingTitle = 'CC2'";
        List artists = this.context.performQuery(new EJBQLQuery(ejbql));
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject((Artist)artists.get(0)));
    }

    @Test
    public void testMultipleJoinsToTheSameTable() throws Exception {
        this.createTwoArtistsThreePaintings();
        String ejbql = "SELECT a FROM Artist a JOIN a.paintingArray b JOIN a.paintingArray c WHERE b.paintingTitle = 'P1' AND c.paintingTitle = 'P2'";
        List artists = this.context.performQuery(new EJBQLQuery(ejbql));
        Assert.assertEquals((long)1L, (long)artists.size());
        Assert.assertEquals((long)33001L, (long)Cayenne.intPKForObject((Artist)artists.get(0)));
    }
}

