/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextEJBQLIsNullIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private UnitDbAdapter accessStackAdapter;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "ARTIST_ID", "PAINTING_TITLE", "ESTIMATED_PRICE"}).setColumnTypes(new int[]{4, -5, 12, 3});
    }

    private void createTwoPaintings() throws Exception {
        this.tPainting.insert(new Object[]{33001, null, "A", null});
        this.tPainting.insert(new Object[]{33002, null, "B", 2000});
    }

    private void createTwoPaintingsAndOneArtist() throws Exception {
        this.tArtist.insert(new Object[]{33001, "A"});
        this.tPainting.insert(new Object[]{33001, null, "A", null});
        this.tPainting.insert(new Object[]{33003, 33001, "C", 500});
    }

    @Test
    public void testCompareToNull() throws Exception {
        if (!this.accessStackAdapter.supportsEqualNullSyntax()) {
            return;
        }
        this.createTwoPaintings();
        String ejbql1 = "SELECT p FROM Painting p WHERE p.estimatedPrice = :x";
        EJBQLQuery query1 = new EJBQLQuery(ejbql1);
        query1.setParameter("x", null);
        this.context.performQuery(query1);
    }

    @Test
    public void testCompareToNull2() throws Exception {
        if (!this.accessStackAdapter.supportsEqualNullSyntax()) {
            return;
        }
        this.createTwoPaintings();
        String ejbql1 = "SELECT p FROM Painting p WHERE p.toArtist.artistName = :x";
        EJBQLQuery query1 = new EJBQLQuery(ejbql1);
        query1.setParameter("x", null);
        this.context.performQuery(query1);
    }

    @Test
    public void testCompareToNull3() throws Exception {
        if (!this.accessStackAdapter.supportsEqualNullSyntax()) {
            return;
        }
        this.createTwoPaintings();
        String ejbql1 = "SELECT p FROM Painting p WHERE :x = p.toArtist.artistName";
        EJBQLQuery query1 = new EJBQLQuery(ejbql1);
        query1.setParameter("x", null);
        this.context.performQuery(query1);
    }

    @Test
    public void testIsNull() throws Exception {
        this.createTwoPaintings();
        String ejbql1 = "SELECT p FROM Painting p WHERE p.estimatedPrice IS NULL";
        EJBQLQuery query1 = new EJBQLQuery(ejbql1);
        List results = this.context.performQuery(query1);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)33001L, (long)Cayenne.intPKForObject((Persistent)results.get(0)));
    }

    @Test
    public void testIsNotNull() throws Exception {
        this.createTwoPaintings();
        String ejbql1 = "SELECT p FROM Painting p WHERE p.estimatedPrice IS NOT NULL";
        EJBQLQuery query1 = new EJBQLQuery(ejbql1);
        List results = this.context.performQuery(query1);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)33002L, (long)Cayenne.intPKForObject((Persistent)results.get(0)));
    }

    @Test
    public void testToOneIsNull() throws Exception {
        this.createTwoPaintingsAndOneArtist();
        String ejbql1 = "SELECT p FROM Painting p WHERE p.toArtist IS NULL";
        EJBQLQuery query1 = new EJBQLQuery(ejbql1);
        List results = this.context.performQuery(query1);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)33001L, (long)Cayenne.intPKForObject((Persistent)results.get(0)));
    }

    @Test
    public void testToOneIsNotNull() throws Exception {
        this.createTwoPaintingsAndOneArtist();
        String ejbql1 = "SELECT p FROM Painting p WHERE p.toArtist IS NOT NULL";
        EJBQLQuery query1 = new EJBQLQuery(ejbql1);
        List results = this.context.performQuery(query1);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((long)33003L, (long)Cayenne.intPKForObject((Persistent)results.get(0)));
    }
}

