/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.things.Bag;
import org.apache.cayenne.testdo.things.Ball;
import org.apache.cayenne.testdo.things.Box;
import org.apache.cayenne.testdo.things.Thing;
import org.apache.cayenne.unit.di.DataChannelInterceptor;
import org.apache.cayenne.unit.di.UnitTestClosure;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-things.xml")
public class DataContextDisjointByIdPrefetch_ExtrasIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    private ServerRuntime runtime;
    @Inject
    protected DBHelper dbHelper;
    @Inject
    protected DataChannelInterceptor queryInterceptor;
    protected TableHelper tBag;
    protected TableHelper tBall;
    protected TableHelper tBox;
    protected TableHelper tBoxInfo;
    protected TableHelper tBoxThing;
    protected TableHelper tThing;

    @Before
    public void setUp() throws Exception {
        this.tBag = new TableHelper(this.dbHelper, "BAG");
        this.tBag.setColumns(new String[]{"ID", "NAME"});
        this.tBall = new TableHelper(this.dbHelper, "BALL");
        this.tBall.setColumns(new String[]{"ID", "BOX_ID", "THING_VOLUME", "THING_WEIGHT"});
        this.tBox = new TableHelper(this.dbHelper, "BOX");
        this.tBox.setColumns(new String[]{"ID", "BAG_ID", "NAME"});
        this.tBoxInfo = new TableHelper(this.dbHelper, "BOX_INFO");
        this.tBoxInfo.setColumns(new String[]{"ID", "BOX_ID", "COLOR"});
        this.tBoxThing = new TableHelper(this.dbHelper, "BOX_THING");
        this.tBoxThing.setColumns(new String[]{"BOX_ID", "THING_VOLUME", "THING_WEIGHT"});
        this.tThing = new TableHelper(this.dbHelper, "THING");
        this.tThing.setColumns(new String[]{"ID", "VOLUME", "WEIGHT"});
    }

    private void createBagWithTwoBoxesAndPlentyOfBallsDataSet() throws Exception {
        this.tBag.insert(new Object[]{1, "b1"});
        this.tBox.insert(new Object[]{1, 1, "big"});
        this.tBoxInfo.insert(new Object[]{1, 1, "red"});
        this.tBox.insert(new Object[]{2, 1, "small"});
        this.tBoxInfo.insert(new Object[]{2, 2, "green"});
        this.tThing.insert(new Object[]{1, 10, 10});
        this.tBall.insert(new Object[]{1, 1, 10, 10});
        this.tThing.insert(new Object[]{2, 20, 20});
        this.tBall.insert(new Object[]{2, 1, 20, 20});
        this.tThing.insert(new Object[]{3, 30, 30});
        this.tBall.insert(new Object[]{3, 2, 30, 30});
        this.tThing.insert(new Object[]{4, 40, 40});
        this.tBall.insert(new Object[]{4, 2, 40, 40});
        this.tThing.insert(new Object[]{5, 20, 10});
        this.tBall.insert(new Object[]{5, 2, 20, 10});
        this.tThing.insert(new Object[]{6, 40, 30});
        this.tBall.insert(new Object[]{6, 2, 40, 30});
        this.tBoxThing.insert(new Object[]{1, 10, 10});
        this.tBoxThing.insert(new Object[]{1, 20, 20});
        this.tBoxThing.insert(new Object[]{2, 30, 30});
        this.tBoxThing.insert(new Object[]{1, 40, 40});
        this.tBoxThing.insert(new Object[]{1, 20, 10});
        this.tBoxThing.insert(new Object[]{1, 40, 30});
    }

    @Test
    public void testFlattenedRelationship() throws Exception {
        this.createBagWithTwoBoxesAndPlentyOfBallsDataSet();
        SelectQuery<Bag> query = new SelectQuery<Bag>(Bag.class);
        query.addPrefetch(Bag.BALLS.disjointById());
        final List result = this.context.performQuery(query);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertFalse((boolean)result.isEmpty());
                Bag b1 = (Bag)result.get(0);
                List balls = (List)b1.readPropertyDirectly(Bag.BALLS.getName());
                Assert.assertNotNull((Object)balls);
                Assert.assertFalse((boolean)((ValueHolder)((Object)balls)).isFault());
                Assert.assertEquals((long)6L, (long)balls.size());
                ArrayList<Integer> volumes = new ArrayList<Integer>();
                for (Ball b : balls) {
                    Assert.assertEquals((long)3L, (long)b.getPersistenceState());
                    volumes.add(b.getThingVolume());
                }
                Assert.assertTrue((boolean)volumes.containsAll(Arrays.asList(10, 20, 30, 40, 20, 40)));
            }
        });
    }

    @Test
    public void testFlattenedMultiColumnRelationship() throws Exception {
        this.createBagWithTwoBoxesAndPlentyOfBallsDataSet();
        SelectQuery<Box> query = new SelectQuery<Box>(Box.class);
        query.addPrefetch(Box.THINGS.disjointById());
        final List result = this.context.performQuery(query);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertFalse((boolean)result.isEmpty());
                ArrayList<Integer> volumes = new ArrayList<Integer>();
                for (Box box : result) {
                    List things = (List)box.readPropertyDirectly(Box.THINGS.getName());
                    Assert.assertNotNull((Object)things);
                    Assert.assertFalse((boolean)((ValueHolder)((Object)things)).isFault());
                    for (Thing t : things) {
                        Assert.assertEquals((long)3L, (long)t.getPersistenceState());
                        volumes.add(t.getVolume());
                    }
                }
                Assert.assertEquals((long)6L, (long)volumes.size());
                Assert.assertTrue((boolean)volumes.containsAll(Arrays.asList(10, 20, 30, 40)));
            }
        });
    }

    @Test
    public void testLongFlattenedRelationship() throws Exception {
        this.createBagWithTwoBoxesAndPlentyOfBallsDataSet();
        SelectQuery<Bag> query = new SelectQuery<Bag>(Bag.class);
        query.addPrefetch(Bag.THINGS.disjointById());
        final List result = this.context.performQuery(query);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertFalse((boolean)result.isEmpty());
                Bag b1 = (Bag)result.get(0);
                List things = (List)b1.readPropertyDirectly(Bag.THINGS.getName());
                Assert.assertNotNull((Object)things);
                Assert.assertFalse((boolean)((ValueHolder)((Object)things)).isFault());
                Assert.assertEquals((long)6L, (long)things.size());
                ArrayList<Integer> volumes = new ArrayList<Integer>();
                for (Thing t : things) {
                    Assert.assertEquals((long)3L, (long)t.getPersistenceState());
                    volumes.add(t.getVolume());
                }
                Assert.assertTrue((boolean)volumes.containsAll(Arrays.asList(10, 20, 20, 30, 40, 40)));
            }
        });
    }

    @Test
    public void testMultiColumnRelationship() throws Exception {
        this.createBagWithTwoBoxesAndPlentyOfBallsDataSet();
        SelectQuery<Ball> query = new SelectQuery<Ball>(Ball.class);
        query.orQualifier(Ball.THING_VOLUME.eq(40).andExp(Ball.THING_WEIGHT.eq(30)));
        query.orQualifier(Ball.THING_VOLUME.eq(20).andExp(Ball.THING_WEIGHT.eq(10)));
        query.addPrefetch(Ball.THING.disjointById());
        final List balls = this.context.performQuery(query);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertEquals((long)2L, (long)balls.size());
                ((Ball)balls.get(0)).getThing().getVolume();
                ((Ball)balls.get(1)).getThing().getVolume();
            }
        });
    }

    @Test
    public void testJointPrefetchInParent() throws Exception {
        this.createBagWithTwoBoxesAndPlentyOfBallsDataSet();
        SelectQuery<Box> query = new SelectQuery<Box>(Box.class);
        query.addPrefetch(Box.BALLS.disjointById());
        query.addPrefetch(Box.BALLS.dot(Ball.THING).disjointById());
        final List result = this.context.performQuery(query);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertFalse((boolean)result.isEmpty());
                ArrayList<Integer> volumes = new ArrayList<Integer>();
                for (Box box : result) {
                    List balls = (List)box.readPropertyDirectly(Box.BALLS.getName());
                    Assert.assertNotNull((Object)balls);
                    Assert.assertFalse((boolean)((ValueHolder)((Object)balls)).isFault());
                    for (Ball ball : balls) {
                        Thing thing = (Thing)ball.readPropertyDirectly(Ball.THING.getName());
                        Assert.assertNotNull((Object)thing);
                        Assert.assertEquals((long)3L, (long)thing.getPersistenceState());
                        volumes.add(thing.getVolume());
                    }
                }
                Assert.assertEquals((long)6L, (long)volumes.size());
                Assert.assertTrue((boolean)volumes.containsAll(Arrays.asList(10, 20, 30, 40)));
            }
        });
    }

    @Test
    public void testJointPrefetchInChild() throws Exception {
        this.createBagWithTwoBoxesAndPlentyOfBallsDataSet();
        SelectQuery<Bag> query = new SelectQuery<Bag>(Bag.class);
        query.addPrefetch(Bag.BOXES.disjointById());
        query.addPrefetch(Bag.BOXES.dot(Box.BALLS).joint());
        final List<Bag> result = this.context.select(query);
        this.queryInterceptor.runWithQueriesBlocked(new UnitTestClosure(){

            @Override
            public void execute() {
                Assert.assertFalse((boolean)result.isEmpty());
                Bag bag = (Bag)result.get(0);
                List boxes = (List)bag.readPropertyDirectly(Bag.BOXES.getName());
                Assert.assertNotNull((Object)boxes);
                Assert.assertFalse((boolean)((ValueHolder)((Object)boxes)).isFault());
                Assert.assertEquals((long)2L, (long)boxes.size());
                CayenneDataObject big = null;
                ArrayList<String> names = new ArrayList<String>();
                for (Box box : boxes) {
                    Assert.assertEquals((long)3L, (long)box.getPersistenceState());
                    names.add(box.getName());
                    if (!box.getName().equals("big")) continue;
                    big = box;
                }
                Assert.assertTrue((boolean)names.contains("big"));
                Assert.assertTrue((boolean)names.contains("small"));
                List balls = (List)big.readPropertyDirectly(Box.BALLS.getName());
                Assert.assertNotNull((Object)balls);
                Assert.assertFalse((boolean)((ValueHolder)((Object)balls)).isFault());
                Assert.assertEquals((long)2L, (long)balls.size());
                ArrayList<Integer> volumes = new ArrayList<Integer>();
                for (Ball ball : balls) {
                    Assert.assertEquals((long)3L, (long)ball.getPersistenceState());
                    volumes.add(ball.getThingVolume());
                }
                Assert.assertTrue((boolean)volumes.containsAll(Arrays.asList(10, 20)));
            }
        });
    }
}

