/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.lob.ClobTestEntity;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-lob.xml")
public class SelectQueryClobIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private UnitDbAdapter accessStackAdapter;

    protected void createClobDataSet() throws Exception {
        TableHelper tClobTest = new TableHelper(this.dbHelper, "CLOB_TEST");
        tClobTest.setColumns(new String[]{"CLOB_TEST_ID", "CLOB_COL"});
        tClobTest.deleteAll();
        tClobTest.insert(new Object[]{1, "clob1"});
        tClobTest.insert(new Object[]{2, "clob2"});
    }

    @Test
    public void testSelectLikeIgnoreCaseClob() throws Exception {
        if (this.accessStackAdapter.supportsLobs()) {
            this.createClobDataSet();
            SelectQuery<ClobTestEntity> query = new SelectQuery<ClobTestEntity>(ClobTestEntity.class);
            Expression qual = ExpressionFactory.likeIgnoreCaseExp("clobCol", (Object)"clob%");
            query.setQualifier(qual);
            List objects = this.context.performQuery(query);
            Assert.assertEquals((long)2L, (long)objects.size());
        }
    }

    @Test
    public void testSelectFetchLimit_Offset_DistinctClob() throws Exception {
        if (this.accessStackAdapter.supportsLobs()) {
            this.createClobDataSet();
            SelectQuery<ClobTestEntity> query = new SelectQuery<ClobTestEntity>(ClobTestEntity.class);
            query.addOrdering("db:CLOB_TEST_ID", SortOrder.ASCENDING);
            query.setFetchLimit(1);
            query.setFetchOffset(1);
            query.setDistinct(true);
            List objects = this.context.performQuery(query);
            Assert.assertEquals((long)1L, (long)objects.size());
            Assert.assertEquals((long)2L, (long)Cayenne.intPKForObject((Persistent)objects.get(0)));
        }
    }

    @Test
    public void testSelectEqualsClob() throws Exception {
        if (this.accessStackAdapter.supportsLobComparisons()) {
            this.createClobDataSet();
            SelectQuery<ClobTestEntity> query = new SelectQuery<ClobTestEntity>(ClobTestEntity.class);
            Expression qual = ExpressionFactory.matchExp("clobCol", (Object)"clob1");
            query.setQualifier(qual);
            List objects = this.context.performQuery(query);
            Assert.assertEquals((long)1L, (long)objects.size());
        }
    }

    @Test
    public void testSelectNotEqualsClob() throws Exception {
        if (this.accessStackAdapter.supportsLobComparisons()) {
            this.createClobDataSet();
            SelectQuery<ClobTestEntity> query = new SelectQuery<ClobTestEntity>(ClobTestEntity.class);
            Expression qual = ExpressionFactory.noMatchExp("clobCol", (Object)"clob1");
            query.setQualifier(qual);
            List objects = this.context.performQuery(query);
            Assert.assertEquals((long)1L, (long)objects.size());
        }
    }
}

