/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.DefaultQueryMetadata;
import org.apache.cayenne.query.IndirectQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.reflect.ArcProperty;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.util.Util;

public class RelationshipQuery
extends IndirectQuery {
    protected ObjectId objectId;
    protected String relationshipName;
    protected boolean refreshing;
    protected int statementFetchSize;
    protected transient EntityResolver metadataResolver;
    protected transient QueryMetadata metadata;
    protected transient ArcProperty arc;

    private RelationshipQuery() {
    }

    public RelationshipQuery(ObjectId objectID, String relationshipName) {
        this(objectID, relationshipName, true);
    }

    public RelationshipQuery(ObjectId objectID, String relationshipName, boolean refreshing) {
        if (objectID == null) {
            throw new CayenneRuntimeException("Null objectID", new Object[0]);
        }
        this.objectId = objectID;
        this.relationshipName = relationshipName;
        this.refreshing = refreshing;
    }

    @Override
    public QueryMetadata getMetaData(EntityResolver resolver) {
        this.updateMetadata(resolver);
        return this.metadata;
    }

    public ObjectId getObjectId() {
        return this.objectId;
    }

    public boolean isRefreshing() {
        return this.refreshing;
    }

    public String getRelationshipName() {
        return this.relationshipName;
    }

    @Override
    protected Query createReplacementQuery(EntityResolver resolver) {
        if (this.objectId.isTemporary() && !this.objectId.isReplacementIdAttached()) {
            throw new CayenneRuntimeException("Can't build a query for relationship '" + this.relationshipName + "' for temporary id: " + this.objectId, new Object[0]);
        }
        ObjRelationship relationship = this.getRelationship(resolver);
        Expression qualifier = ExpressionFactory.matchDbExp(relationship.getReverseDbRelationshipPath(), this.objectId);
        SelectQuery query = new SelectQuery(relationship.getTargetEntity(), qualifier);
        query.setStatementFetchSize(this.statementFetchSize);
        return query;
    }

    public ObjRelationship getRelationship(EntityResolver resolver) {
        this.updateMetadata(resolver);
        return this.arc.getRelationship();
    }

    void updateMetadata(EntityResolver resolver) {
        if (this.metadataResolver != resolver) {
            if (this.objectId == null) {
                throw new CayenneRuntimeException("Can't resolve query - objectID is null.", new Object[0]);
            }
            ClassDescriptor descriptor = resolver.getClassDescriptor(this.objectId.getEntityName());
            this.arc = (ArcProperty)descriptor.getProperty(this.relationshipName);
            if (this.arc == null) {
                throw new CayenneRuntimeException("No relationship named " + this.relationshipName + " found in entity " + this.objectId.getEntityName() + "; object id: " + this.objectId, new Object[0]);
            }
            this.metadata = new DefaultQueryMetadata(){

                @Override
                public boolean isRefreshingObjects() {
                    return RelationshipQuery.this.refreshing;
                }

                @Override
                public ObjEntity getObjEntity() {
                    return RelationshipQuery.this.arc.getTargetDescriptor().getEntity();
                }

                @Override
                public ClassDescriptor getClassDescriptor() {
                    return RelationshipQuery.this.arc.getTargetDescriptor();
                }

                @Override
                public int getStatementFetchSize() {
                    return RelationshipQuery.this.statementFetchSize;
                }
            };
            this.metadataResolver = resolver;
        }
    }

    public void setStatementFetchSize(int size) {
        this.statementFetchSize = size;
    }

    public int getStatementFetchSize() {
        return this.statementFetchSize;
    }

    public String toString() {
        return Util.stripPackageName(this.getClass().getName()) + ":" + this.getRelationshipName();
    }
}

