/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.sql.Date;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.ResultIteratorCallback;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.FunctionExpressionFactory;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.exp.parser.ASTScalar;
import org.apache.cayenne.query.ColumnSelect;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ObjectSelect_RunIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;

    @Before
    public void createArtistsDataSet() throws Exception {
        TableHelper tArtist = new TableHelper(this.dbHelper, "ARTIST");
        tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
        long dateBase = System.currentTimeMillis();
        for (int i = 1; i <= 20; ++i) {
            tArtist.insert(new Object[]{i, "artist" + i, new Date(dateBase + (long)(10000 * i))});
        }
        TableHelper tGallery = new TableHelper(this.dbHelper, "GALLERY");
        tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        tGallery.insert(new Object[]{1, "tate modern"});
        TableHelper tPaintings = new TableHelper(this.dbHelper, "PAINTING");
        tPaintings.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "GALLERY_ID"});
        for (int i = 1; i <= 20; ++i) {
            tPaintings.insert(new Object[]{i, "painting" + i, i % 5 + 1, 1});
        }
    }

    @Test
    public void test_SelectObjects() throws Exception {
        List result = ObjectSelect.query(Artist.class).select(this.context);
        Assert.assertEquals((long)20L, (long)result.size());
        Assert.assertThat(result.get(0), (Matcher)CoreMatchers.instanceOf(Artist.class));
        Artist a = (Artist)((ObjectSelect)ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("artist14"))).selectOne(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist14", (Object)a.getArtistName());
    }

    @Test
    public void test_Iterate() throws Exception {
        final int[] count = new int[1];
        ObjectSelect.query(Artist.class).iterate(this.context, new ResultIteratorCallback<Artist>(){

            @Override
            public void next(Artist object) {
                Assert.assertNotNull((Object)object.getArtistName());
                count[0] = count[0] + 1;
            }
        });
        Assert.assertEquals((long)20L, (long)count[0]);
    }

    @Test
    public void test_Iterator() throws Exception {
        try (ResultIterator it = ObjectSelect.query(Artist.class).iterator(this.context);){
            int count = 0;
            for (Artist a : it) {
                ++count;
            }
            Assert.assertEquals((long)20L, (long)count);
        }
    }

    @Test
    public void test_BatchIterator() throws Exception {
        try (ResultBatchIterator it = ObjectSelect.query(Artist.class).batchIterator(this.context, 5);){
            int count = 0;
            for (List artistList : it) {
                ++count;
                Assert.assertEquals((long)5L, (long)artistList.size());
            }
            Assert.assertEquals((long)4L, (long)count);
        }
    }

    @Test
    public void test_SelectDataRows() throws Exception {
        List result = ObjectSelect.dataRowQuery(Artist.class).select(this.context);
        Assert.assertEquals((long)20L, (long)result.size());
        Assert.assertThat(result.get(0), (Matcher)CoreMatchers.instanceOf(DataRow.class));
        DataRow a = (DataRow)((ObjectSelect)ObjectSelect.dataRowQuery(Artist.class).where(Artist.ARTIST_NAME.eq("artist14"))).selectOne(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist14", a.get("ARTIST_NAME"));
    }

    @Test
    public void test_SelectOne() throws Exception {
        Artist a = (Artist)((ObjectSelect)ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("artist13"))).selectOne(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist13", (Object)a.getArtistName());
    }

    @Test
    public void test_SelectOne_NoMatch() throws Exception {
        Artist a = (Artist)((ObjectSelect)ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("artist33"))).selectOne(this.context);
        Assert.assertNull((Object)a);
    }

    @Test(expected=CayenneRuntimeException.class)
    public void test_SelectOne_MoreThanOneMatch() throws Exception {
        ((ObjectSelect)ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.like("artist%"))).selectOne(this.context);
    }

    @Test
    public void test_SelectFirst() throws Exception {
        Artist a = (Artist)((ObjectSelect)ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("artist13"))).selectFirst(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist13", (Object)a.getArtistName());
    }

    @Test
    public void test_SelectFirstByContext() throws Exception {
        ObjectSelect q = (ObjectSelect)ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("artist13"));
        Artist a = (Artist)this.context.selectFirst(q);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist13", (Object)a.getArtistName());
    }

    @Test
    public void test_SelectFirst_NoMatch() throws Exception {
        Artist a = (Artist)((ObjectSelect)ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.eq("artist33"))).selectFirst(this.context);
        Assert.assertNull((Object)a);
    }

    @Test
    public void test_SelectFirst_MoreThanOneMatch() throws Exception {
        Artist a = (Artist)((ObjectSelect)((ObjectSelect)ObjectSelect.query(Artist.class).where(Artist.ARTIST_NAME.like("artist%"))).orderBy("db:ARTIST_ID")).selectFirst(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist1", (Object)a.getArtistName());
    }

    @Test
    public void test_SelectFirst_TrimInWhere() throws Exception {
        Expression exp = FunctionExpressionFactory.trimExp(Artist.ARTIST_NAME.path());
        Property<String> trimmedName = Property.create("trimmed", exp, String.class);
        Artist a = (Artist)((ObjectSelect)((ObjectSelect)ObjectSelect.query(Artist.class).where(trimmedName.likeIgnoreCase("artist%"))).orderBy("db:ARTIST_ID")).selectFirst(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist1", (Object)a.getArtistName());
    }

    @Test
    public void test_SelectFirst_SubstringInWhere() throws Exception {
        Expression exp = FunctionExpressionFactory.substringExp(Artist.ARTIST_NAME.path(), 2, 3);
        Property<String> substrName = Property.create("substr", exp, String.class);
        Artist a = (Artist)((ObjectSelect)((ObjectSelect)ObjectSelect.query(Artist.class).where(substrName.eq("rti"))).orderBy("db:ARTIST_ID")).selectFirst(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist1", (Object)a.getArtistName());
    }

    @Test
    public void test_SelectFirst_MultiColumns() throws Exception {
        Object[] a = (Object[])((ColumnSelect)((ColumnSelect)ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH).columns(Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH).columns(Artist.ARTIST_NAME.alias("newName"), new Property[0]).where(Artist.ARTIST_NAME.like("artist%"))).orderBy("db:ARTIST_ID")).selectFirst(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist1", (Object)a[0]);
        Assert.assertEquals((Object)"artist1", (Object)a[4]);
    }

    @Test
    public void test_SelectFirst_SingleValueInColumns() throws Exception {
        Object[] a = (Object[])((ColumnSelect)((ColumnSelect)ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, new Property[0]).where(Artist.ARTIST_NAME.like("artist%"))).orderBy("db:ARTIST_ID")).selectFirst(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist1", (Object)a[0]);
    }

    @Test
    public void test_SelectFirst_SubstringName() throws Exception {
        Expression exp = FunctionExpressionFactory.substringExp(Artist.ARTIST_NAME.path(), 5, 3);
        Property<String> substrName = Property.create("substrName", exp, String.class);
        Object[] a = (Object[])((ColumnSelect)ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, substrName).where(substrName.eq("st3"))).selectFirst(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"artist3", (Object)a[0]);
        Assert.assertEquals((Object)"st3", (Object)a[1]);
    }

    @Test
    public void test_SelectFirst_RelColumns() throws Exception {
        Property paintingTitle = Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE).alias("paintingTitle");
        Object[] a = (Object[])((ColumnSelect)ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, paintingTitle).orderBy(paintingTitle.asc())).selectFirst(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"painting1", (Object)a[1]);
    }

    @Test
    public void test_SelectFirst_RelColumn() throws Exception {
        Property paintingTitle = Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE).alias("paintingTitle");
        String a = (String)((ColumnSelect)ObjectSelect.query(Artist.class).column(paintingTitle).orderBy(paintingTitle.asc())).selectFirst(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"painting1", (Object)a);
    }

    @Test
    public void test_SelectFirst_RelColumnWithFunction() throws Exception {
        Property paintingTitle = Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE);
        Expression exp = FunctionExpressionFactory.substringExp(paintingTitle.path(), 7, 3);
        exp = FunctionExpressionFactory.concatExp(exp, new ASTScalar(" "), Artist.ARTIST_NAME.path());
        Property<String> altTitle = Property.create("altTitle", exp, String.class);
        String a = (String)((ColumnSelect)((ColumnSelect)ObjectSelect.query(Artist.class).column(altTitle).where(altTitle.like("ng1%"))).and(Artist.ARTIST_NAME.like("%ist1"))).selectFirst(this.context);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"ng1 artist1", (Object)a);
    }

    @Test
    public void test_ColumnSelect_IterationSingleColumn() throws Exception {
        ColumnSelect columnSelect = ObjectSelect.query(Artist.class).column(Artist.ARTIST_NAME);
        final int[] count = new int[1];
        columnSelect.iterate(this.context, new ResultIteratorCallback<String>(){

            @Override
            public void next(String object) {
                count[0] = count[0] + 1;
                Assert.assertTrue((boolean)object.startsWith("artist"));
            }
        });
        Assert.assertEquals((long)20L, (long)count[0]);
    }

    @Test
    public void test_ColumnSelect_BatchIterationSingleColumn() throws Exception {
        ColumnSelect columnSelect = ObjectSelect.query(Artist.class).column(Artist.ARTIST_NAME);
        try (ResultBatchIterator it = columnSelect.batchIterator(this.context, 10);){
            Object next = it.next();
            Assert.assertEquals((long)10L, (long)next.size());
            Assert.assertTrue((boolean)((String)next.get(0)).startsWith("artist"));
        }
    }

    @Test
    public void test_ColumnSelect_IterationMultiColumns() throws Exception {
        ColumnSelect<Object[]> columnSelect = ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH);
        final int[] count = new int[1];
        columnSelect.iterate(this.context, new ResultIteratorCallback<Object[]>(){

            @Override
            public void next(Object[] object) {
                count[0] = count[0] + 1;
                Assert.assertTrue((boolean)(object[0] instanceof String));
                Assert.assertTrue((boolean)(object[1] instanceof java.util.Date));
            }
        });
        Assert.assertEquals((long)20L, (long)count[0]);
    }

    @Test
    public void test_ColumnSelect_BatchIterationMultiColumns() throws Exception {
        ColumnSelect<Object[]> columnSelect = ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH);
        try (ResultBatchIterator it = columnSelect.batchIterator(this.context, 10);){
            Object next = it.next();
            Assert.assertEquals((long)10L, (long)next.size());
            Assert.assertTrue((boolean)(((Object[])next.get(0))[0] instanceof String));
            Assert.assertTrue((boolean)(((Object[])next.get(0))[1] instanceof java.util.Date));
        }
    }
}

