/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.testdo.testmap.Artist;
import org.junit.Assert;
import org.junit.Test;

public class ObjectSelectTest {
    @Test
    public void testDataRowQuery() {
        ObjectSelect<DataRow> q = ObjectSelect.dataRowQuery(Artist.class);
        Assert.assertNotNull(q);
        Assert.assertTrue((boolean)q.isFetchingDataRows());
        Assert.assertEquals(Artist.class, q.getEntityType());
        Assert.assertNull((Object)q.getEntityName());
        Assert.assertNull((Object)q.getDbEntityName());
    }

    @Test
    public void testQuery_RootType() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        Assert.assertNotNull(q);
        Assert.assertNull((Object)q.getWhere());
        Assert.assertFalse((boolean)q.isFetchingDataRows());
        Assert.assertEquals(Artist.class, q.getEntityType());
        Assert.assertNull((Object)q.getEntityName());
        Assert.assertNull((Object)q.getDbEntityName());
    }

    @Test
    public void testQuery_RootType_WithQualifier() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class, ExpressionFactory.matchExp("a", (Object)"A"));
        Assert.assertNotNull(q);
        Assert.assertEquals((Object)"a = \"A\"", (Object)q.getWhere().toString());
        Assert.assertFalse((boolean)q.isFetchingDataRows());
        Assert.assertEquals(Artist.class, q.getEntityType());
        Assert.assertNull((Object)q.getEntityName());
        Assert.assertNull((Object)q.getDbEntityName());
    }

    @Test
    public void testQuery_TypeAndEntity() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class, "Painting");
        Assert.assertNotNull(q);
        Assert.assertFalse((boolean)q.isFetchingDataRows());
        Assert.assertNull(q.getEntityType());
        Assert.assertEquals((Object)"Painting", (Object)q.getEntityName());
        Assert.assertNull((Object)q.getDbEntityName());
    }

    @Test
    public void testQuery_TypeAndDbEntity() {
        ObjectSelect<DataRow> q = ObjectSelect.dbQuery("PAINTING");
        Assert.assertNotNull(q);
        Assert.assertTrue((boolean)q.isFetchingDataRows());
        Assert.assertNull(q.getEntityType());
        Assert.assertNull((Object)q.getEntityName());
        Assert.assertEquals((Object)"PAINTING", (Object)q.getDbEntityName());
    }

    @Test
    public void testWhere() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        q.where(ExpressionFactory.matchExp("a", (Object)3));
        Assert.assertEquals((Object)"a = 3", (Object)q.getWhere().toString());
        q.where(ExpressionFactory.matchExp("b", (Object)4));
        Assert.assertEquals((Object)"(a = 3) and (b = 4)", (Object)q.getWhere().toString());
    }

    @Test
    public void testAnd_Array() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        q.where(ExpressionFactory.matchExp("a", (Object)3));
        Assert.assertEquals((Object)"a = 3", (Object)q.getWhere().toString());
        q.and(ExpressionFactory.matchExp("b", (Object)4), ExpressionFactory.greaterExp("c", (Object)5));
        Assert.assertEquals((Object)"(a = 3) and (b = 4) and (c > 5)", (Object)q.getWhere().toString());
    }

    @Test
    public void testAnd_Collection() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        q.where(ExpressionFactory.matchExp("a", (Object)3));
        Assert.assertEquals((Object)"a = 3", (Object)q.getWhere().toString());
        List<Expression> exps = Arrays.asList(ExpressionFactory.matchExp("b", (Object)4), ExpressionFactory.greaterExp("c", (Object)5));
        q.and(exps);
        Assert.assertEquals((Object)"(a = 3) and (b = 4) and (c > 5)", (Object)q.getWhere().toString());
    }

    @Test
    public void testAnd_ArrayNull() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        q.where(ExpressionFactory.matchExp("a", (Object)3));
        Assert.assertEquals((Object)"a = 3", (Object)q.getWhere().toString());
        q.and(new Expression[0]);
        Assert.assertEquals((Object)"a = 3", (Object)q.getWhere().toString());
    }

    @Test
    public void testAnd_ArrayEmpty() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        q.where(ExpressionFactory.matchExp("a", (Object)3));
        Assert.assertEquals((Object)"a = 3", (Object)q.getWhere().toString());
        q.and(new Expression[0]);
        Assert.assertEquals((Object)"a = 3", (Object)q.getWhere().toString());
    }

    @Test
    public void testAnd_CollectionEmpty() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        q.where(ExpressionFactory.matchExp("a", (Object)3));
        Assert.assertEquals((Object)"a = 3", (Object)q.getWhere().toString());
        q.and(Collections.emptyList());
        Assert.assertEquals((Object)"a = 3", (Object)q.getWhere().toString());
    }

    @Test
    public void testOr_Array() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        q.where(ExpressionFactory.matchExp("a", (Object)3));
        Assert.assertEquals((Object)"a = 3", (Object)q.getWhere().toString());
        q.or(ExpressionFactory.matchExp("b", (Object)4), ExpressionFactory.greaterExp("c", (Object)5));
        Assert.assertEquals((Object)"(a = 3) or (b = 4) or (c > 5)", (Object)q.getWhere().toString());
    }

    @Test
    public void testOr_Collection() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        q.where(ExpressionFactory.matchExp("a", (Object)3));
        Assert.assertEquals((Object)"a = 3", (Object)q.getWhere().toString());
        List<Expression> exps = Arrays.asList(ExpressionFactory.matchExp("b", (Object)4), ExpressionFactory.greaterExp("c", (Object)5));
        q.or(exps);
        Assert.assertEquals((Object)"(a = 3) or (b = 4) or (c > 5)", (Object)q.getWhere().toString());
    }

    @Test
    public void testOrderBy_Array() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        Ordering o1 = new Ordering("x");
        q.orderBy(o1);
        Object[] result1 = q.getOrderings().toArray();
        Assert.assertEquals((long)1L, (long)result1.length);
        Assert.assertSame((Object)o1, (Object)result1[0]);
        Ordering o2 = new Ordering("y");
        q.orderBy(o2);
        Object[] result2 = q.getOrderings().toArray();
        Assert.assertEquals((long)2L, (long)result2.length);
        Assert.assertSame((Object)o1, (Object)result2[0]);
        Assert.assertSame((Object)o2, (Object)result2[1]);
    }

    @Test
    public void testOrderBy_Collection() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        Ordering o1 = new Ordering("x");
        q.orderBy(Collections.singletonList(o1));
        Object[] result1 = q.getOrderings().toArray();
        Assert.assertEquals((long)1L, (long)result1.length);
        Assert.assertSame((Object)o1, (Object)result1[0]);
        Ordering o2 = new Ordering("y");
        q.orderBy(Collections.singletonList(o2));
        Object[] result2 = q.getOrderings().toArray();
        Assert.assertEquals((long)2L, (long)result2.length);
        Assert.assertSame((Object)o1, (Object)result2[0]);
        Assert.assertSame((Object)o2, (Object)result2[1]);
    }

    @Test
    public void testOrderBy_PropertyStrategy() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        q.orderBy("x", SortOrder.ASCENDING_INSENSITIVE);
        Object[] result1 = q.getOrderings().toArray();
        Assert.assertEquals((long)1L, (long)result1.length);
        Assert.assertEquals((Object)new Ordering("x", SortOrder.ASCENDING_INSENSITIVE), (Object)result1[0]);
        q.orderBy("y", SortOrder.DESCENDING);
        Object[] result2 = q.getOrderings().toArray();
        Assert.assertEquals((long)2L, (long)result2.length);
        Assert.assertEquals((Object)new Ordering("y", SortOrder.DESCENDING), (Object)result2[1]);
    }

    @Test
    public void testOrderBy_Property() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        q.orderBy("x");
        Object[] result1 = q.getOrderings().toArray();
        Assert.assertEquals((long)1L, (long)result1.length);
        Assert.assertEquals((Object)new Ordering("x", SortOrder.ASCENDING), (Object)result1[0]);
        q.orderBy("y");
        Object[] result2 = q.getOrderings().toArray();
        Assert.assertEquals((long)2L, (long)result2.length);
        Assert.assertEquals((Object)new Ordering("x", SortOrder.ASCENDING), (Object)result2[0]);
        Assert.assertEquals((Object)new Ordering("y", SortOrder.ASCENDING), (Object)result2[1]);
    }

    @Test
    public void testPrefetch() {
        PrefetchTreeNode root = PrefetchTreeNode.withPath("a.b", 1);
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        q.prefetch(root);
        PrefetchTreeNode root1 = q.getPrefetches();
        Assert.assertNotNull((Object)root1);
        Assert.assertNotNull((Object)root1.getNode("a.b"));
        Assert.assertEquals((long)1L, (long)root1.getNode("a.b").getSemantics());
    }

    @Test
    public void testPrefetch_Path() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        q.prefetch("a.b", 2);
        PrefetchTreeNode root1 = q.getPrefetches();
        Assert.assertNotNull((Object)root1);
        Assert.assertNotNull((Object)root1.getNode("a.b"));
        q.prefetch("a.c", 2);
        PrefetchTreeNode root2 = q.getPrefetches();
        Assert.assertNotNull((Object)root2);
        Assert.assertNotNull((Object)root2.getNode("a.c"));
        Assert.assertNotNull((Object)root2.getNode("a.b"));
    }

    @Test
    public void testPrefetch_Merge() {
        PrefetchTreeNode root = PrefetchTreeNode.withPath("a.b", 1);
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        q.prefetch(root);
        PrefetchTreeNode root1 = q.getPrefetches();
        Assert.assertNotNull((Object)root1);
        Assert.assertNotNull((Object)root1.getNode("a.b"));
        Assert.assertEquals((long)1L, (long)root1.getNode("a.b").getSemantics());
        PrefetchTreeNode subRoot = PrefetchTreeNode.withPath("a.b.c", 1);
        q.prefetch(subRoot);
        root1 = q.getPrefetches();
        Assert.assertNotNull((Object)root1);
        Assert.assertNotNull((Object)root1.getNode("a.b"));
        Assert.assertEquals((long)1L, (long)root1.getNode("a.b").getSemantics());
        Assert.assertNotNull((Object)root1.getNode("a.b.c"));
        Assert.assertEquals((long)1L, (long)root1.getNode("a.b.c").getSemantics());
    }

    @Test
    public void testLimit() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        Assert.assertEquals((long)0L, (long)q.getLimit());
        q.limit(2);
        Assert.assertEquals((long)2L, (long)q.getLimit());
        ((ObjectSelect)q.limit(3)).limit(5);
        Assert.assertEquals((long)5L, (long)q.getLimit());
    }

    @Test
    public void testOffset() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        Assert.assertEquals((long)0L, (long)q.getOffset());
        q.offset(2);
        Assert.assertEquals((long)2L, (long)q.getOffset());
        ((ObjectSelect)q.offset(3)).offset(5);
        Assert.assertEquals((long)5L, (long)q.getOffset());
    }

    @Test
    public void testStatementFetchSize() {
        ObjectSelect<Artist> q = ObjectSelect.query(Artist.class);
        Assert.assertEquals((long)0L, (long)q.getStatementFetchSize());
        q.statementFetchSize(2);
        Assert.assertEquals((long)2L, (long)q.getStatementFetchSize());
        ((ObjectSelect)q.statementFetchSize(3)).statementFetchSize(5);
        Assert.assertEquals((long)5L, (long)q.getStatementFetchSize());
    }

    @Test
    public void testCacheGroups_Collection() {
        ObjectSelect<DataRow> q = ObjectSelect.dataRowQuery(Artist.class);
        Assert.assertNull((Object)((Object)q.getCacheStrategy()));
        Assert.assertNull((Object)q.getCacheGroup());
        q.cacheGroup("a");
        Assert.assertNull((Object)((Object)q.getCacheStrategy()));
        Assert.assertEquals((Object)"a", (Object)q.getCacheGroup());
    }

    @Test
    public void testCacheStrategy() {
        ObjectSelect<DataRow> q = ObjectSelect.dataRowQuery(Artist.class);
        Assert.assertNull((Object)((Object)q.getCacheStrategy()));
        Assert.assertNull((Object)q.getCacheGroup());
        q.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE, "b");
        Assert.assertSame((Object)((Object)QueryCacheStrategy.LOCAL_CACHE), (Object)((Object)q.getCacheStrategy()));
        Assert.assertEquals((Object)"b", (Object)q.getCacheGroup());
        q.cacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        Assert.assertSame((Object)((Object)QueryCacheStrategy.SHARED_CACHE), (Object)((Object)q.getCacheStrategy()));
        Assert.assertNull((Object)q.getCacheGroup());
    }

    @Test
    public void testLocalCache() {
        ObjectSelect<DataRow> q = ObjectSelect.dataRowQuery(Artist.class);
        Assert.assertNull((Object)((Object)q.getCacheStrategy()));
        Assert.assertNull((Object)q.getCacheGroup());
        q.localCache("a");
        Assert.assertSame((Object)((Object)QueryCacheStrategy.LOCAL_CACHE), (Object)((Object)q.getCacheStrategy()));
        Assert.assertEquals((Object)"a", (Object)q.getCacheGroup());
        q.localCache();
        Assert.assertSame((Object)((Object)QueryCacheStrategy.LOCAL_CACHE), (Object)((Object)q.getCacheStrategy()));
        Assert.assertNull((Object)q.getCacheGroup());
    }

    @Test
    public void testSharedCache() {
        ObjectSelect<DataRow> q = ObjectSelect.dataRowQuery(Artist.class);
        Assert.assertNull((Object)((Object)q.getCacheStrategy()));
        Assert.assertNull((Object)q.getCacheGroup());
        q.sharedCache("b");
        Assert.assertSame((Object)((Object)QueryCacheStrategy.SHARED_CACHE), (Object)((Object)q.getCacheStrategy()));
        Assert.assertEquals((Object)"b", (Object)q.getCacheGroup());
        q.sharedCache();
        Assert.assertSame((Object)((Object)QueryCacheStrategy.SHARED_CACHE), (Object)((Object)q.getCacheStrategy()));
        Assert.assertNull((Object)q.getCacheGroup());
    }
}

