/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.text.DateFormat;
import java.util.Locale;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.query.ColumnSelect;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.PostgresUnitDbAdapter;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ColumnSelectIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private UnitDbAdapter unitDbAdapter;
    private static final DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.US);
    private TableHelper tArtist;

    @Before
    public void createArtistsDataSet() throws Exception {
        int i;
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
        this.tArtist.setColumnTypes(new int[]{4, 12, 91});
        Date[] dates = new Date[5];
        for (i = 1; i <= 5; ++i) {
            dates[i - 1] = new Date(dateFormat.parse("1/" + i + "/17").getTime());
        }
        for (i = 1; i <= 20; ++i) {
            this.tArtist.insert(new Object[]{i, "artist" + i, dates[i % 5]});
        }
        TableHelper tGallery = new TableHelper(this.dbHelper, "GALLERY");
        tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        tGallery.insert(new Object[]{1, "tate modern"});
        TableHelper tPaintings = new TableHelper(this.dbHelper, "PAINTING");
        tPaintings.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "GALLERY_ID", "ESTIMATED_PRICE"});
        for (int i2 = 1; i2 <= 20; ++i2) {
            tPaintings.insert(new Object[]{i2, "painting" + i2, i2 % 5 + 1, 1, 22 - i2});
        }
        tPaintings.insert(new Object[]{21, "painting21", 2, 1, 30});
    }

    @Test
    public void testSelectGroupBy() throws Exception {
        Object[] result = (Object[])((ColumnSelect)ObjectSelect.query(Artist.class).columns(Artist.DATE_OF_BIRTH, Property.COUNT).orderBy(Artist.DATE_OF_BIRTH.asc())).selectFirst(this.context);
        Assert.assertEquals((Object)dateFormat.parse("1/1/17"), (Object)result[0]);
        Assert.assertEquals((Object)4L, (Object)result[1]);
    }

    @Test
    public void testSelectSimpleHaving() throws Exception {
        Object[] result = (Object[])((ColumnSelect)ObjectSelect.query(Artist.class).columns(Artist.DATE_OF_BIRTH, Property.COUNT).orderBy(Artist.DATE_OF_BIRTH.asc())).having(Artist.DATE_OF_BIRTH.eq(dateFormat.parse("1/2/17"))).selectOne(this.context);
        Assert.assertEquals((Object)dateFormat.parse("1/2/17"), (Object)result[0]);
        Assert.assertEquals((Object)4L, (Object)result[1]);
    }

    @Test(expected=Exception.class)
    public void testHavingOnNonGroupByColumn() throws Exception {
        Property<String> nameSubstr = Artist.ARTIST_NAME.substring(1, 6);
        Object[] q = (Object[])ObjectSelect.columnQuery(Artist.class, nameSubstr, Property.COUNT).having(Artist.ARTIST_NAME.like("artist%")).selectOne(this.context);
        Assert.assertEquals((Object)"artist", (Object)q[0]);
        Assert.assertEquals((Object)20L, (Object)q[1]);
    }

    @Test
    public void testSelectRelationshipCount() throws Exception {
        Object[] result = (Object[])((ColumnSelect)ObjectSelect.query(Artist.class).columns(Artist.DATE_OF_BIRTH, Artist.PAINTING_ARRAY.count()).orderBy(Artist.DATE_OF_BIRTH.asc())).selectFirst(this.context);
        Assert.assertEquals((Object)dateFormat.parse("1/1/17"), (Object)result[0]);
        Assert.assertEquals((Object)4L, (Object)result[1]);
    }

    @Test
    public void testSelectHavingWithExpressionAlias() throws Exception {
        Object[] q = null;
        try {
            q = (Object[])ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME.substring(1, 6).alias("name_substr"), Property.COUNT).having(Property.COUNT.gt(10L)).selectOne(this.context);
        }
        catch (CayenneRuntimeException ex) {
            if (this.unitDbAdapter.supportsExpressionInHaving()) {
                Assert.fail();
            }
            return;
        }
        Assert.assertEquals((Object)"artist", (Object)q[0]);
        Assert.assertEquals((Object)20L, (Object)q[1]);
    }

    @Ignore(value="Need to figure out a better way to handle alias / no alias case for expression in having")
    @Test
    public void testSelectHavingWithExpressionNoAlias() throws Exception {
        Object[] q = null;
        try {
            q = (Object[])ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME.substring(1, 6), Property.COUNT).having(Property.COUNT.gt(10L)).selectOne(this.context);
        }
        catch (CayenneRuntimeException ex) {
            if (this.unitDbAdapter.supportsExpressionInHaving()) {
                Assert.fail();
            }
            return;
        }
        Assert.assertEquals((Object)"artist", (Object)q[0]);
        Assert.assertEquals((Object)20L, (Object)q[1]);
    }

    @Test
    public void testSelectWhereAndHaving() throws Exception {
        Object[] q = null;
        try {
            q = (Object[])((ColumnSelect)ObjectSelect.columnQuery(Artist.class, Artist.ARTIST_NAME.substring(1, 6).alias("name_substr"), Property.COUNT).where(Artist.ARTIST_NAME.substring(1, 1).eq("a"))).having(Property.COUNT.gt(10L)).selectOne(this.context);
        }
        catch (CayenneRuntimeException ex) {
            if (this.unitDbAdapter.supportsExpressionInHaving()) {
                Assert.fail();
            }
            return;
        }
        Assert.assertEquals((Object)"artist", (Object)q[0]);
        Assert.assertEquals((Object)20L, (Object)q[1]);
    }

    @Test
    public void testSelectRelationshipCountHaving() throws Exception {
        Property<Long> paintingCount = Artist.PAINTING_ARRAY.count();
        Object[] result = null;
        try {
            result = (Object[])ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, paintingCount).having(paintingCount.gt(4L)).selectOne(this.context);
        }
        catch (CayenneRuntimeException ex) {
            if (this.unitDbAdapter.supportsExpressionInHaving()) {
                Assert.fail();
            }
            return;
        }
        Assert.assertEquals((Object)"artist2", (Object)result[0]);
        Assert.assertEquals((Object)5L, (Object)result[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectWithQuoting() throws Exception {
        Object[] result;
        block7: {
            if (this.unitDbAdapter instanceof PostgresUnitDbAdapter) {
                return;
            }
            Property<Long> paintingCount = Artist.PAINTING_ARRAY.count();
            this.context.getEntityResolver().getDataMap("testmap").setQuotingSQLIdentifiers(true);
            result = null;
            try {
                result = (Object[])ObjectSelect.query(Artist.class).columns(Artist.ARTIST_NAME, Artist.DATE_OF_BIRTH, paintingCount).having(paintingCount.gt(4L)).selectOne(this.context);
            }
            catch (CayenneRuntimeException ex) {
                if (this.unitDbAdapter.supportsExpressionInHaving()) {
                    Assert.fail();
                    break block7;
                }
                return;
            }
            finally {
                this.context.getEntityResolver().getDataMap("testmap").setQuotingSQLIdentifiers(false);
            }
        }
        Assert.assertEquals((Object)"artist2", (Object)result[0]);
        Assert.assertEquals((Object)5L, (Object)result[2]);
    }

    @Test
    public void testSelectGroupByWithQuoting() throws Exception {
        if (this.unitDbAdapter instanceof PostgresUnitDbAdapter) {
            return;
        }
        this.context.getEntityResolver().getDataMap("testmap").setQuotingSQLIdentifiers(true);
        try {
            Object[] result = (Object[])((ColumnSelect)ObjectSelect.query(Artist.class).columns(Artist.DATE_OF_BIRTH, Property.COUNT).orderBy(Artist.DATE_OF_BIRTH.asc())).selectFirst(this.context);
            Assert.assertEquals((Object)dateFormat.parse("1/1/17"), (Object)result[0]);
            Assert.assertEquals((Object)4L, (Object)result[1]);
        }
        finally {
            this.context.getEntityResolver().getDataMap("testmap").setQuotingSQLIdentifiers(false);
        }
    }

    @Test
    public void testAgregateOnRelation() throws Exception {
        BigDecimal min = new BigDecimal(3);
        BigDecimal max = new BigDecimal(30);
        BigDecimal avg = new BigDecimal(BigInteger.valueOf(1290L), 2);
        BigDecimal sum = new BigDecimal(258);
        Property estimatedPrice = Artist.PAINTING_ARRAY.dot(Painting.ESTIMATED_PRICE);
        Object[] minMaxAvgPrice = (Object[])((ObjectSelect)ObjectSelect.query(Artist.class).where(estimatedPrice.gte(min))).min(estimatedPrice).max(estimatedPrice).avg(estimatedPrice).sum(estimatedPrice).count().selectOne(this.context);
        Assert.assertEquals((long)0L, (long)min.compareTo((BigDecimal)minMaxAvgPrice[0]));
        Assert.assertEquals((long)0L, (long)max.compareTo((BigDecimal)minMaxAvgPrice[1]));
        Assert.assertEquals((long)0L, (long)avg.compareTo((BigDecimal)minMaxAvgPrice[2]));
        Assert.assertEquals((long)0L, (long)sum.compareTo((BigDecimal)minMaxAvgPrice[3]));
        Assert.assertEquals((Object)20L, (Object)minMaxAvgPrice[4]);
    }

    @Test
    public void testQueryCount() throws Exception {
        long count = (Long)ObjectSelect.columnQuery(Artist.class, Property.COUNT).selectOne(this.context);
        Assert.assertEquals((long)20L, (long)count);
        long count2 = (Long)ObjectSelect.query(Artist.class).count().selectOne(this.context);
        Assert.assertEquals((long)count, (long)count2);
        long count3 = ObjectSelect.query(Artist.class).selectCount(this.context);
        Assert.assertEquals((long)count, (long)count3);
    }

    @Test
    public void testQueryCountWithProperty() throws Exception {
        this.tArtist.insert(new Object[]{21, "artist_21", null});
        this.tArtist.insert(new Object[]{22, "artist_21", null});
        long count = (Long)ObjectSelect.columnQuery(Artist.class, Property.COUNT).selectOne(this.context);
        Assert.assertEquals((long)22L, (long)count);
        long count2 = (Long)ObjectSelect.columnQuery(Artist.class, Artist.DATE_OF_BIRTH.count()).selectOne(this.context);
        Assert.assertEquals((long)20L, (long)count2);
        long count3 = (Long)ObjectSelect.query(Artist.class).count(Artist.DATE_OF_BIRTH).selectOne(this.context);
        Assert.assertEquals((long)count2, (long)count3);
    }
}

