/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Test;

public class ObjAttributeTest {
    @Test
    public void testDbAttribute() {
        ObjAttribute attribute = new ObjAttribute("a1");
        DbAttribute dbAttr = new DbAttribute("tst_name", 4, null);
        attribute.setDbAttributePath(dbAttr.getName());
        Assert.assertEquals((Object)dbAttr.getName(), (Object)attribute.getDbAttributeName());
    }

    @Test
    public void testDbAttributePath() {
        ObjAttribute attribute = new ObjAttribute("a1");
        attribute.setDbAttributePath("a");
        Assert.assertEquals((Object)"a", (Object)attribute.getDbAttributePath());
        Assert.assertEquals((Object)"a", (Object)attribute.getDbAttributeName());
        attribute.setDbAttributePath("a.b");
        Assert.assertEquals((Object)"a.b", (Object)attribute.getDbAttributePath());
        Assert.assertEquals((Object)"b", (Object)attribute.getDbAttributeName());
    }

    @Test
    public void testType() {
        ObjAttribute attribute = new ObjAttribute("a1");
        String type = "org.aa.zz";
        attribute.setType(type);
        Assert.assertEquals((Object)type, (Object)attribute.getType());
    }

    @Test
    public void testSerializability() throws Exception {
        ObjAttribute a1 = new ObjAttribute("a1");
        ObjAttribute a2 = Util.cloneViaSerialization(a1);
        Assert.assertEquals((Object)a1.getName(), (Object)a2.getName());
    }

    @Test
    public void testGetClientAttribute() {
        ObjAttribute a1 = new ObjAttribute("a1");
        a1.setType("x.y.z");
        ObjAttribute a2 = a1.getClientAttribute();
        Assert.assertNotNull((Object)a2);
        Assert.assertEquals((Object)a1.getName(), (Object)a2.getName());
        Assert.assertEquals((Object)a1.getType(), (Object)a2.getType());
    }

    @Test
    public void testGetJavaClass() throws Exception {
        ObjAttribute a1 = new ObjAttribute("test");
        a1.setType("byte");
        Assert.assertEquals((Object)Byte.TYPE.getName(), (Object)a1.getJavaClass().getName());
        a1.setType("byte[]");
        Assert.assertEquals((Object)byte[].class.getName(), (Object)a1.getJavaClass().getName());
        a1.setType("java.lang.Byte");
        Assert.assertEquals((Object)Byte.class.getName(), (Object)a1.getJavaClass().getName());
        a1.setType("java.lang.Byte[]");
        Assert.assertEquals((Object)Byte[].class.getName(), (Object)a1.getJavaClass().getName());
    }
}

