/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.List;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ExpressionEvaluationIT
extends ServerCase {
    @Inject
    private DataContext context;
    @Inject
    private DBHelper dbHelper;
    private TableHelper tArtist;
    private TableHelper tGallery;
    private TableHelper tPaintings;

    @Before
    public void createArtistsDataSet() throws Exception {
        int i;
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME", "DATE_OF_BIRTH"});
        long dateBase = System.currentTimeMillis();
        for (i = 1; i <= 6; ++i) {
            this.tArtist.insert(new Object[]{i, "artist" + i, new Date(dateBase + (long)(10000 * i))});
        }
        this.tGallery = new TableHelper(this.dbHelper, "GALLERY");
        this.tGallery.setColumns(new String[]{"GALLERY_ID", "GALLERY_NAME"});
        this.tGallery.insert(new Object[]{1, "tate modern"});
        this.tPaintings = new TableHelper(this.dbHelper, "PAINTING");
        this.tPaintings.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "GALLERY_ID", "ESTIMATED_PRICE"});
        for (i = 1; i <= 10; ++i) {
            this.tPaintings.insert(new Object[]{i, "painting" + i, i % 5 + 1, 1, i * 100});
        }
        this.tPaintings.insert(new Object[]{11, "painting11", null, 1, 10000});
        this.tPaintings.insert(new Object[]{12, "painting12", 1, 1, null});
    }

    @Test
    public void testSimpleLike() {
        Expression exp = Artist.ARTIST_NAME.like("artist%");
        this.compareSqlAndEval(exp, 6);
    }

    @Test
    public void testSimpleNotLike() {
        Expression exp = Artist.ARTIST_NAME.nlike("artist%");
        this.compareSqlAndEval(exp, 0);
    }

    @Test
    public void testSimpleEqual() {
        Expression exp = Artist.ARTIST_NAME.eq("artist2");
        this.compareSqlAndEval(exp, 1);
    }

    @Test
    public void testSimpleNotEqual() {
        Expression exp = Artist.ARTIST_NAME.ne("artist2");
        this.compareSqlAndEval(exp, 5);
    }

    @Test
    public void testLikeIgnoreCase() {
        Expression exp = Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE).likeIgnoreCase("painting%");
        this.compareSqlAndEval(exp, 5);
    }

    @Test
    public void testNotLikeIgnoreCase() {
        Expression exp = Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE).likeIgnoreCase("PaInTing%");
        this.compareSqlAndEval(exp, 5);
    }

    @Test
    public void testLike() {
        Expression exp = Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE).like("painting%");
        this.compareSqlAndEval(exp, 5);
    }

    @Test
    public void testNotLike() {
        Expression exp = Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE).like("painting%");
        this.compareSqlAndEval(exp, 5);
    }

    @Test
    public void testEqual() {
        Expression exp = Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE).eq("painting1");
        this.compareSqlAndEval(exp, 1);
    }

    @Test
    public void testNotEqual1() {
        Expression exp = Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE).ne("painting1");
        this.compareSqlAndEval(exp, 5);
    }

    @Test
    public void testNotEqual2() {
        Expression exp = Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE).ne("painting11");
        this.compareSqlAndEval(exp, 5);
    }

    @Test
    public void testNotEqual3() {
        Expression exp = Artist.PAINTING_ARRAY.dot(Painting.PAINTING_TITLE).ne("zyz");
        this.compareSqlAndEval(exp, 5);
    }

    @Test
    public void testBetween() {
        Expression exp = Artist.PAINTING_ARRAY.dot(Painting.ESTIMATED_PRICE).between(new BigDecimal(300), new BigDecimal(600));
        this.compareSqlAndEval(exp, 4);
    }

    @Test
    public void testNotBetween() {
        Expression exp = ExpressionFactory.notBetweenExp("paintingArray.estimatedPrice", (Object)new BigDecimal(300), (Object)new BigDecimal(600));
        this.compareSqlAndEval(exp, 5);
    }

    @Test
    public void testGreater() {
        Expression exp = Artist.PAINTING_ARRAY.dot(Painting.ESTIMATED_PRICE).gt(new BigDecimal(799));
        this.compareSqlAndEval(exp, 3);
    }

    @Test
    public void testGreaterEqual() {
        Expression exp = Artist.PAINTING_ARRAY.dot(Painting.ESTIMATED_PRICE).gte(new BigDecimal(800));
        this.compareSqlAndEval(exp, 3);
    }

    @Test
    public void testIn() {
        Expression exp = Artist.PAINTING_ARRAY.dot(Painting.ESTIMATED_PRICE).in(new BigDecimal(800), new BigDecimal(300), new BigDecimal(700));
        this.compareSqlAndEval(exp, 2);
    }

    @Test
    public void testNotIn() {
        Expression exp = Artist.PAINTING_ARRAY.dot(Painting.ESTIMATED_PRICE).nin(new BigDecimal(800), new BigDecimal(200), new BigDecimal(300), new BigDecimal(400), new BigDecimal(700));
        this.compareSqlAndEval(exp, 3);
    }

    @Test
    public void testLess() {
        Expression exp = Artist.PAINTING_ARRAY.dot(Painting.ESTIMATED_PRICE).lt(new BigDecimal(801));
        this.compareSqlAndEval(exp, 5);
    }

    @Test
    public void testLessOrEqual() {
        Expression exp = Artist.PAINTING_ARRAY.dot(Painting.ESTIMATED_PRICE).lte(new BigDecimal(800));
        this.compareSqlAndEval(exp, 5);
    }

    @Test
    public void testCollectionWithNull() {
        Expression exp = Artist.PAINTING_ARRAY.dot(Painting.ESTIMATED_PRICE).lt(new BigDecimal(200));
        this.compareSqlAndEval(exp, 1);
    }

    @Test
    public void testGreaterWithNull() throws Exception {
        this.tPaintings.deleteAll();
        this.tArtist.deleteAll();
        this.tArtist.insert(new Object[]{7, "artist7", null});
        Expression expression = Artist.DATE_OF_BIRTH.gt(new Date(System.currentTimeMillis()));
        this.compareSqlAndEval(expression, 0);
        Expression expression1 = expression.notExp();
        this.compareSqlAndEval(expression1, 0);
    }

    @Test
    public void testGreaterEqualWithNull() throws Exception {
        this.tPaintings.deleteAll();
        this.tArtist.deleteAll();
        this.tArtist.insert(new Object[]{7, "artist7", null});
        Expression expression = Artist.DATE_OF_BIRTH.gte(new Date(System.currentTimeMillis()));
        this.compareSqlAndEval(expression, 0);
        Expression expression1 = expression.notExp();
        this.compareSqlAndEval(expression1, 0);
    }

    @Test
    public void testLessWithNull() throws Exception {
        this.tPaintings.deleteAll();
        this.tArtist.deleteAll();
        this.tArtist.insert(new Object[]{7, "artist7", null});
        Expression expression = Artist.DATE_OF_BIRTH.lt(new Date(System.currentTimeMillis()));
        this.compareSqlAndEval(expression, 0);
        Expression expression1 = expression.notExp();
        this.compareSqlAndEval(expression1, 0);
    }

    @Test
    public void testLessEqualWithNull() throws Exception {
        this.tPaintings.deleteAll();
        this.tArtist.deleteAll();
        this.tArtist.insert(new Object[]{7, "artist7", null});
        Expression expression = Artist.DATE_OF_BIRTH.lte(new Date(System.currentTimeMillis()));
        this.compareSqlAndEval(expression, 0);
        Expression expression1 = expression.notExp();
        this.compareSqlAndEval(expression1, 0);
    }

    @Test
    public void testAndWithNull() throws Exception {
        this.tPaintings.deleteAll();
        this.tArtist.deleteAll();
        this.tArtist.insert(new Object[]{7, "artist7", null});
        this.tArtist.insert(new Object[]{8, "artist8", null});
        this.tArtist.insert(new Object[]{9, "artist9", null});
        Expression nullExp = Artist.DATE_OF_BIRTH.lt(new Date(System.currentTimeMillis()));
        Expression and = ExpressionFactory.and(nullExp, Artist.ARTIST_NAME.eq("artist7"));
        this.compareSqlAndEval(and, 0);
        this.compareSqlAndEval(and.notExp(), 2);
    }

    @Test
    public void testAndWithNull2() throws Exception {
        this.tPaintings.deleteAll();
        this.tArtist.deleteAll();
        this.tArtist.insert(new Object[]{7, "artist7", null});
        this.tArtist.insert(new Object[]{8, "artist8", null});
        this.tArtist.insert(new Object[]{9, "artist9", null});
        Expression nullExp = Artist.DATE_OF_BIRTH.lt(new Date(System.currentTimeMillis()));
        Expression and = ExpressionFactory.and(nullExp, Artist.ARTIST_NAME.eq("artist10"));
        this.compareSqlAndEval(and, 0);
        this.compareSqlAndEval(and.notExp(), 3);
    }

    @Test
    public void testOrWithNull() throws Exception {
        this.tPaintings.deleteAll();
        this.tArtist.deleteAll();
        this.tArtist.insert(new Object[]{7, "artist7", null});
        this.tArtist.insert(new Object[]{8, "artist8", null});
        this.tArtist.insert(new Object[]{9, "artist9", null});
        Expression nullExp = Artist.DATE_OF_BIRTH.lt(new Date(System.currentTimeMillis()));
        Expression and = ExpressionFactory.or(nullExp, Artist.ARTIST_NAME.eq("artist7"));
        this.compareSqlAndEval(and, 1);
        this.compareSqlAndEval(and.notExp(), 0);
    }

    private void compareSqlAndEval(Expression exp, int expectedCount) {
        Ordering ordering = new Ordering("db:ARTIST_ID");
        List filteredInSQL = ((ObjectSelect)ObjectSelect.query(Artist.class, exp).orderBy(ordering)).select(this.context);
        List filteredInMemory = exp.filterObjects(((ObjectSelect)ObjectSelect.query(Artist.class).prefetch(Artist.PAINTING_ARRAY.disjoint())).select(this.context));
        ordering.orderList(filteredInMemory);
        Assert.assertEquals((long)expectedCount, (long)filteredInMemory.size());
        Assert.assertEquals(filteredInSQL, filteredInMemory);
    }
}

