/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.util.Calendar;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.parser.ASTCurrentDate;
import org.apache.cayenne.exp.parser.ASTCurrentTime;
import org.apache.cayenne.exp.parser.ASTCurrentTimestamp;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.testdo.date_time.DateTestEntity;
import org.apache.cayenne.unit.UnitDbAdapter;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-date-time.xml")
public class ASTFunctionCallDateIT
extends ServerCase {
    @Inject
    private ObjectContext context;
    @Inject
    private DBHelper dbHelper;
    @Inject
    private UnitDbAdapter unitDbAdapter;

    @Before
    public void createDataSet() throws Exception {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        DateTestEntity o1 = this.context.newObject(DateTestEntity.class);
        cal.set(year - 1, month, day, 0, 0, 0);
        o1.setDateColumn(cal.getTime());
        cal.set(year, month, day, 0, 0, 0);
        o1.setTimeColumn(cal.getTime());
        cal.set(5, day - 1);
        o1.setTimestampColumn(cal.getTime());
        DateTestEntity o2 = this.context.newObject(DateTestEntity.class);
        cal.set(year + 1, month, day, 0, 0, 0);
        o2.setDateColumn(cal.getTime());
        cal.set(year, month, day, 23, 59, 59);
        o2.setTimeColumn(cal.getTime());
        cal.set(5, day + 1);
        o2.setTimestampColumn(cal.getTime());
        this.context.commitChanges();
    }

    @Test
    public void testCurrentDate() throws Exception {
        Expression exp = ExpressionFactory.greaterOrEqualExp("dateColumn", (Object)new ASTCurrentDate());
        DateTestEntity res1 = (DateTestEntity)ObjectSelect.query(DateTestEntity.class, exp).selectOne(this.context);
        Assert.assertNotNull((Object)res1);
        Expression exp2 = ExpressionFactory.lessExp("dateColumn", (Object)new ASTCurrentDate());
        DateTestEntity res2 = (DateTestEntity)ObjectSelect.query(DateTestEntity.class, exp2).selectOne(this.context);
        Assert.assertNotNull((Object)res2);
        Assert.assertNotEquals((Object)res1, (Object)res2);
    }

    @Test
    public void testCurrentTime() throws Exception {
        Expression exp = ExpressionFactory.greaterOrEqualExp("timeColumn", (Object)new ASTCurrentTime());
        List res = ObjectSelect.query(DateTestEntity.class, exp).select(this.context);
        if (!this.unitDbAdapter.supportsTimeSqlType()) {
            return;
        }
        Assert.assertEquals((long)1L, (long)res.size());
        DateTestEntity res1 = (DateTestEntity)res.get(0);
        Expression exp2 = ExpressionFactory.lessExp("timeColumn", (Object)new ASTCurrentTime());
        DateTestEntity res2 = (DateTestEntity)ObjectSelect.query(DateTestEntity.class, exp2).selectOne(this.context);
        Assert.assertNotNull((Object)res2);
        Assert.assertNotEquals((Object)res1, (Object)res2);
    }

    @Test
    public void testCurrentTimestamp() throws Exception {
        Expression exp = ExpressionFactory.greaterOrEqualExp("timestampColumn", (Object)new ASTCurrentTimestamp());
        DateTestEntity res1 = (DateTestEntity)ObjectSelect.query(DateTestEntity.class, exp).selectOne(this.context);
        Assert.assertNotNull((Object)res1);
        Expression exp2 = ExpressionFactory.lessExp("timestampColumn", (Object)new ASTCurrentTimestamp());
        DateTestEntity res2 = (DateTestEntity)ObjectSelect.query(DateTestEntity.class, exp2).selectOne(this.context);
        Assert.assertNotNull((Object)res2);
        Assert.assertNotEquals((Object)res1, (Object)res2);
    }
}

