/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.cayenne.exp.ExpEnum1;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionException;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.TstTraversalHandler;
import org.apache.cayenne.exp.parser.ASTLike;
import org.apache.cayenne.exp.parser.ASTLikeIgnoreCase;
import org.apache.cayenne.exp.parser.ASTTrim;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExpressionFactoryTest {
    private TstTraversalHandler handler;

    @Before
    public void before() throws Exception {
        this.handler = new TstTraversalHandler();
    }

    @Test(expected=ExpressionException.class)
    public void testExpressionOfBadType() throws Exception {
        int badType = -50;
        ExpressionFactory.expressionOfType(badType);
    }

    @Test
    public void testBetweenExp() throws Exception {
        Object v1 = new Object();
        Object v2 = new Object();
        Expression exp = ExpressionFactory.betweenExp("abc", v1, v2);
        Assert.assertEquals((long)9L, (long)exp.getType());
        Expression path = (Expression)exp.getOperand(0);
        Assert.assertEquals((long)26L, (long)path.getType());
    }

    @Test
    public void testBetweenDbExp() throws Exception {
        Object v1 = new Object();
        Object v2 = new Object();
        Expression exp = ExpressionFactory.betweenDbExp("abc", v1, v2);
        Assert.assertEquals((long)9L, (long)exp.getType());
        Expression path = (Expression)exp.getOperand(0);
        Assert.assertEquals((long)27L, (long)path.getType());
    }

    @Test
    public void testNotBetweenExp() throws Exception {
        Object v1 = new Object();
        Object v2 = new Object();
        Expression exp = ExpressionFactory.notBetweenExp("abc", v1, v2);
        Assert.assertEquals((long)35L, (long)exp.getType());
        Expression path = (Expression)exp.getOperand(0);
        Assert.assertEquals((long)26L, (long)path.getType());
    }

    @Test
    public void testNotBetweenDbExp() throws Exception {
        Object v1 = new Object();
        Object v2 = new Object();
        Expression exp = ExpressionFactory.notBetweenDbExp("abc", v1, v2);
        Assert.assertEquals((long)35L, (long)exp.getType());
        Expression path = (Expression)exp.getOperand(0);
        Assert.assertEquals((long)27L, (long)path.getType());
    }

    @Test
    public void testGreaterExp() throws Exception {
        Object v = new Object();
        Expression exp = ExpressionFactory.greaterExp("abc", v);
        Assert.assertEquals((long)6L, (long)exp.getType());
    }

    @Test
    public void testGreaterDbExp() throws Exception {
        Object v = new Object();
        Expression exp = ExpressionFactory.greaterDbExp("abc", v);
        Assert.assertEquals((long)6L, (long)exp.getType());
        Expression path = (Expression)exp.getOperand(0);
        Assert.assertEquals((long)27L, (long)path.getType());
    }

    @Test
    public void testGreaterOrEqualExp() throws Exception {
        Object v = new Object();
        Expression exp = ExpressionFactory.greaterOrEqualExp("abc", v);
        Assert.assertEquals((long)8L, (long)exp.getType());
    }

    @Test
    public void testGreaterOrEqualDbExp() throws Exception {
        Object v = new Object();
        Expression exp = ExpressionFactory.greaterOrEqualDbExp("abc", v);
        Assert.assertEquals((long)8L, (long)exp.getType());
        Expression path = (Expression)exp.getOperand(0);
        Assert.assertEquals((long)27L, (long)path.getType());
    }

    @Test
    public void testLessExp() throws Exception {
        Object v = new Object();
        Expression exp = ExpressionFactory.lessExp("abc", v);
        Assert.assertEquals((long)5L, (long)exp.getType());
    }

    @Test
    public void testLessDbExp() throws Exception {
        Object v = new Object();
        Expression exp = ExpressionFactory.lessDbExp("abc", v);
        Assert.assertEquals((long)5L, (long)exp.getType());
        Expression path = (Expression)exp.getOperand(0);
        Assert.assertEquals((long)27L, (long)path.getType());
    }

    @Test
    public void testLessOrEqualExp() throws Exception {
        Object v = new Object();
        Expression exp = ExpressionFactory.lessOrEqualExp("abc", v);
        Assert.assertEquals((long)7L, (long)exp.getType());
        Expression path = (Expression)exp.getOperand(0);
        Assert.assertEquals((long)26L, (long)path.getType());
    }

    @Test
    public void testLessOrEqualDbExp() throws Exception {
        Object v = new Object();
        Expression exp = ExpressionFactory.lessOrEqualDbExp("abc", v);
        Assert.assertEquals((long)7L, (long)exp.getType());
        Expression path = (Expression)exp.getOperand(0);
        Assert.assertEquals((long)27L, (long)path.getType());
    }

    @Test
    public void testInExp1() throws Exception {
        Expression exp = ExpressionFactory.inExp("abc", "a", "b");
        Assert.assertEquals((long)10L, (long)exp.getType());
    }

    @Test
    public void testInExp2() throws Exception {
        ArrayList<String> v = new ArrayList<String>();
        v.add("a");
        v.add("b");
        Expression exp = ExpressionFactory.inExp("abc", v);
        Assert.assertEquals((long)10L, (long)exp.getType());
    }

    @Test
    public void testInExp3() throws Exception {
        ArrayList v = new ArrayList();
        Expression exp = ExpressionFactory.inExp("abc", v);
        Assert.assertEquals((long)22L, (long)exp.getType());
    }

    @Test
    public void testLikeExp() throws Exception {
        String v = "abc";
        Expression exp = ExpressionFactory.likeExp("abc", (Object)v);
        Assert.assertEquals((long)11L, (long)exp.getType());
        Expression path = (Expression)exp.getOperand(0);
        Assert.assertEquals((long)26L, (long)path.getType());
    }

    @Test
    public void testLikeDbExp() throws Exception {
        String v = "abc";
        Expression exp = ExpressionFactory.likeDbExp("abc", v);
        Assert.assertEquals((long)11L, (long)exp.getType());
        Expression path = (Expression)exp.getOperand(0);
        Assert.assertEquals((long)27L, (long)path.getType());
    }

    @Test
    public void testLikeExpEscape() throws Exception {
        String v = "abc";
        Expression exp = ExpressionFactory.likeExp("=abc", (Object)v, '=');
        Assert.assertEquals((long)11L, (long)exp.getType());
        Assert.assertEquals((long)61L, (long)((ASTLike)exp).getEscapeChar());
        Expression path = (Expression)exp.getOperand(0);
        Assert.assertEquals((long)26L, (long)path.getType());
    }

    @Test
    public void testLikeIgnoreCaseExp() throws Exception {
        String v = "abc";
        Expression exp = ExpressionFactory.likeIgnoreCaseExp("abc", (Object)v);
        Assert.assertEquals((long)12L, (long)exp.getType());
        Assert.assertEquals((long)0L, (long)((ASTLikeIgnoreCase)exp).getEscapeChar());
        Expression path = (Expression)exp.getOperand(0);
        Assert.assertEquals((long)26L, (long)path.getType());
    }

    @Test
    public void testLikeIgnoreCaseExpEscape() throws Exception {
        String v = "abc";
        Expression exp = ExpressionFactory.likeIgnoreCaseExp("=abc", (Object)v, '=');
        Assert.assertEquals((long)12L, (long)exp.getType());
        Assert.assertEquals((long)61L, (long)((ASTLikeIgnoreCase)exp).getEscapeChar());
        Expression path = (Expression)exp.getOperand(0);
        Assert.assertEquals((long)26L, (long)path.getType());
    }

    @Test
    public void testLikeIgnoreCaseDbExp() throws Exception {
        String v = "abc";
        Expression exp = ExpressionFactory.likeIgnoreCaseDbExp("abc", v);
        Assert.assertEquals((long)12L, (long)exp.getType());
        Expression path = (Expression)exp.getOperand(0);
        Assert.assertEquals((long)27L, (long)path.getType());
    }

    @Test
    public void testNotLikeIgnoreCaseExp() throws Exception {
        String v = "abc";
        Expression exp = ExpressionFactory.notLikeIgnoreCaseExp("abc", (Object)v);
        Assert.assertEquals((long)38L, (long)exp.getType());
    }

    @Test
    public void testLikeExpNull() throws Exception {
        Expression exp = ExpressionFactory.likeExp("abc", null);
        Assert.assertEquals((long)11L, (long)exp.getType());
        Expression path = (Expression)exp.getOperand(0);
        Assert.assertEquals((long)26L, (long)path.getType());
        Assert.assertNull((Object)exp.getOperand(1));
    }

    @Test
    public void testMatchAllExp() throws Exception {
        for (int n = 1; n <= 3; ++n) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 1; i <= n; ++i) {
                map.put("k" + i, "v" + i);
            }
            Expression exp = ExpressionFactory.matchAllExp(map, 5);
            Assert.assertNotNull((Object)exp);
            this.handler.traverseExpression(exp);
            this.handler.assertConsistency();
            Assert.assertEquals((String)("Failed: " + exp), (long)(2 * n), (long)this.handler.getLeafs());
            Assert.assertEquals((String)("Failed: " + exp), (long)(n < 2 ? (long)(2 * n) : (long)(2 * n + 1)), (long)this.handler.getNodeCount());
        }
    }

    @Test
    public void testJoinExp() throws Exception {
        for (int n = 1; n <= 5; ++n) {
            ArrayList<Expression> list = new ArrayList<Expression>();
            for (int i = 1; i <= n; ++i) {
                list.add(ExpressionFactory.matchExp("k" + i, (Object)("v" + i)));
            }
            Expression exp = ExpressionFactory.joinExp(0, list);
            Assert.assertNotNull((Object)exp);
            this.handler.traverseExpression(exp);
            this.handler.assertConsistency();
            Assert.assertEquals((String)("Failed: " + exp), (long)(2 * n), (long)this.handler.getLeafs());
            Assert.assertEquals((String)("Failed: " + exp), (long)(n > 1 ? (long)(2 * n + 1) : (long)(2 * n)), (long)this.handler.getNodeCount());
        }
    }

    @Test
    public void testAnd_Collection() {
        Expression e1 = ExpressionFactory.matchExp("a", (Object)1);
        Expression e2 = ExpressionFactory.matchExp("b", (Object)2);
        Expression e3 = ExpressionFactory.matchExp("c", (Object)"C");
        List<Expression> c = Arrays.asList(e1, e2, e3);
        Expression e = ExpressionFactory.and(c);
        Assert.assertEquals((Object)"(a = 1) and (b = 2) and (c = \"C\")", (Object)e.toString());
    }

    @Test
    public void testAnd_Collection_OneElement() {
        Expression e1 = ExpressionFactory.matchExp("a", (Object)1);
        List<Expression> c = Collections.singletonList(e1);
        Expression e = ExpressionFactory.and(c);
        Assert.assertEquals((Object)"a = 1", (Object)e.toString());
    }

    @Test
    public void testAnd_Collection_Empty() {
        Expression e = ExpressionFactory.and(Collections.emptyList());
        Assert.assertNull((Object)e);
    }

    @Test
    public void testAnd_Vararg() {
        Expression e1 = ExpressionFactory.matchExp("a", (Object)1);
        Expression e2 = ExpressionFactory.matchExp("b", (Object)2);
        Expression e3 = ExpressionFactory.matchExp("c", (Object)"C");
        Expression e = ExpressionFactory.and(e1, e2, e3);
        Assert.assertEquals((Object)"(a = 1) and (b = 2) and (c = \"C\")", (Object)e.toString());
    }

    @Test
    public void testAnd_Vararg_OneElement() {
        Expression e1 = ExpressionFactory.matchExp("a", (Object)1);
        Expression e = ExpressionFactory.and(e1);
        Assert.assertEquals((Object)"a = 1", (Object)e.toString());
    }

    @Test
    public void testAnd_Vararg_Empty() {
        Expression e = ExpressionFactory.and(new Expression[0]);
        Assert.assertNull((Object)e);
    }

    @Test
    public void testOr_Collection() {
        Expression e1 = ExpressionFactory.matchExp("a", (Object)1);
        Expression e2 = ExpressionFactory.matchExp("b", (Object)2);
        Expression e3 = ExpressionFactory.matchExp("c", (Object)"C");
        List<Expression> c = Arrays.asList(e1, e2, e3);
        Expression e = ExpressionFactory.or(c);
        Assert.assertEquals((Object)"(a = 1) or (b = 2) or (c = \"C\")", (Object)e.toString());
    }

    @Test
    public void testOr_Vararg() {
        Expression e1 = ExpressionFactory.matchExp("a", (Object)1);
        Expression e2 = ExpressionFactory.matchExp("b", (Object)2);
        Expression e3 = ExpressionFactory.matchExp("c", (Object)"C");
        Expression e = ExpressionFactory.or(e1, e2, e3);
        Assert.assertEquals((Object)"(a = 1) or (b = 2) or (c = \"C\")", (Object)e.toString());
    }

    @Test
    public void testExp_Long() {
        Expression e = ExpressionFactory.exp("216201000180L", new Object[0]);
        Assert.assertEquals((Object)216201000180L, (Object)e.evaluate(new Object()));
    }

    @Test
    public void testExp_Path() {
        Expression e1 = ExpressionFactory.exp("object.path", new Object[0]);
        Assert.assertEquals((long)26L, (long)e1.getType());
        Expression e2 = ExpressionFactory.exp("db:object.path", new Object[0]);
        Assert.assertEquals((long)27L, (long)e2.getType());
        Expression e3 = ExpressionFactory.exp("object+.path", new Object[0]);
        Assert.assertEquals((long)26L, (long)e3.getType());
        Expression e4 = ExpressionFactory.exp("db:object.path+", new Object[0]);
        Assert.assertEquals((long)27L, (long)e4.getType());
    }

    @Test
    public void testExp_Scalar() {
        Expression e1 = ExpressionFactory.exp("a = 'abc'", new Object[0]);
        Assert.assertEquals((Object)"abc", (Object)e1.getOperand(1));
    }

    @Test
    public void testExp_Enum() {
        Expression e1 = ExpressionFactory.exp("a = enum:org.apache.cayenne.exp.ExpEnum1.ONE", new Object[0]);
        Assert.assertEquals((Object)((Object)ExpEnum1.ONE), (Object)e1.getOperand(1));
        Expression e2 = ExpressionFactory.exp("a = enum:org.apache.cayenne.exp.ExpEnum1.TWO", new Object[0]);
        Assert.assertEquals((Object)((Object)ExpEnum1.TWO), (Object)e2.getOperand(1));
        Expression e3 = ExpressionFactory.exp("a = enum:org.apache.cayenne.exp.ExpEnum1.THREE", new Object[0]);
        Assert.assertEquals((Object)((Object)ExpEnum1.THREE), (Object)e3.getOperand(1));
    }

    @Test(expected=ExpressionException.class)
    public void testExp_EnumInvalid1() {
        ExpressionFactory.exp("a = enum:org.apache.cayenne.exp.ExpEnum1.BOGUS", new Object[0]);
    }

    @Test(expected=ExpressionException.class)
    public void testExp_EnumInvalid2() {
        ExpressionFactory.exp("a = enum:BOGUS", new Object[0]);
    }

    @Test
    public void testExp_Vararg_InAsValues() {
        Expression e = ExpressionFactory.exp("k1 in ($ap, $bp)", "a", "b");
        Assert.assertEquals((Object)"k1 in (\"a\", \"b\")", (Object)e.toString());
    }

    @Test
    public void testPathExp() {
        Assert.assertEquals((Object)"abc.xyz", (Object)ExpressionFactory.pathExp("abc.xyz").toString());
    }

    @Test
    public void testDbPathExp() {
        Assert.assertEquals((Object)"db:abc.xyz", (Object)ExpressionFactory.dbPathExp("abc.xyz").toString());
    }

    @Test
    public void testFuncExp() {
        Expression e = ExpressionFactory.exp("TRIM(abc.xyz)", new Object[0]);
        Assert.assertEquals(ASTTrim.class, e.getClass());
    }

    @Test(expected=ExpressionException.class)
    public void testExceptionInParse() {
        ExpressionFactory.exp("name like %32_65415'", new Object[0]);
    }
}

