/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ExtendedEnumeration;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.dba.TypesMapping;

public class ExtendedEnumType<T extends Enum<T>>
implements ExtendedType<T> {
    private Class<T> enumerationClass = null;
    private T[] values = null;
    private Map<Object, Enum<T>> enumerationMappings = new HashMap<Object, Enum<T>>();

    public ExtendedEnumType(Class<T> enumerationClass) {
        if (enumerationClass == null) {
            throw new IllegalArgumentException("Null ExtendedEnumType class");
        }
        this.enumerationClass = enumerationClass;
        try {
            Method m = enumerationClass.getMethod("values", new Class[0]);
            this.values = (Enum[])m.invoke(null, new Object[0]);
            for (int i = 0; i < this.values.length; ++i) {
                this.register((Enum<T>)this.values[i], ((ExtendedEnumeration)this.values[i]).getDatabaseValue());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Class " + enumerationClass.getName() + " is not an Enum", e);
        }
    }

    @Override
    public String getClassName() {
        return this.enumerationClass.getName();
    }

    @Override
    public T materializeObject(ResultSet rs, int index, int type) throws Exception {
        if (TypesMapping.isNumeric(type)) {
            int i = rs.getInt(index);
            return rs.wasNull() || index < 0 ? null : (T)this.lookup(i);
        }
        String string = rs.getString(index);
        return string != null ? (T)this.lookup(string) : null;
    }

    @Override
    public T materializeObject(CallableStatement rs, int index, int type) throws Exception {
        if (TypesMapping.isNumeric(type)) {
            int i = rs.getInt(index);
            return rs.wasNull() || index < 0 ? null : (T)this.lookup(i);
        }
        String string = rs.getString(index);
        return string != null ? (T)this.lookup(string) : null;
    }

    @Override
    public void setJdbcObject(PreparedStatement statement, T value, int pos, int type, int precision) throws Exception {
        if (value instanceof ExtendedEnumeration) {
            ExtendedEnumeration e = (ExtendedEnumeration)value;
            if (TypesMapping.isNumeric(type)) {
                statement.setInt(pos, (Integer)e.getDatabaseValue());
            } else {
                statement.setString(pos, (String)e.getDatabaseValue());
            }
        } else {
            statement.setNull(pos, type);
        }
    }

    private void register(Enum<T> enumeration, Object databaseValue) {
        if (this.enumerationMappings.containsKey(databaseValue) || this.enumerationMappings.containsValue(enumeration)) {
            throw new CayenneRuntimeException("Enumerations/values may not be duplicated.", new Object[0]);
        }
        this.enumerationMappings.put(databaseValue, enumeration);
    }

    private T lookup(Object databaseValue) {
        if (!this.enumerationMappings.containsKey(databaseValue)) {
            if (databaseValue instanceof Integer) {
                throw new CayenneRuntimeException("Missing enumeration mapping for " + this.getClassName() + " with value " + databaseValue + ".", new Object[0]);
            }
            return Enum.valueOf(this.enumerationClass, (String)databaseValue);
        }
        return (T)this.enumerationMappings.get(databaseValue);
    }

    @Override
    public String toString(T value) {
        if (value == null) {
            return "NULL";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(((Enum)value).name()).append("=");
        if (value instanceof ExtendedEnumeration) {
            Object dbValue = ((ExtendedEnumeration)value).getDatabaseValue();
            if (dbValue instanceof String) {
                buffer.append("'");
            }
            buffer.append(value);
            if (dbValue instanceof String) {
                buffer.append("'");
            }
        } else {
            buffer.append(((Enum)value).ordinal());
        }
        return buffer.toString();
    }

    public Map<Object, Enum<T>> getEnumerationMappings() {
        return this.enumerationMappings;
    }

    public Object[] getValues() {
        return this.values;
    }
}

