/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.Collections;
import java.util.Date;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.DataObject;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.MockDataObject;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Gallery;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class ObjectStoreIT
extends ServerCase {
    @Inject
    private DataContext context;

    @Test
    public void testRegisteredObjectsCount() throws Exception {
        Assert.assertEquals((long)0L, (long)this.context.getObjectStore().registeredObjectsCount());
        MockDataObject o1 = new MockDataObject();
        o1.setObjectId(new ObjectId("T", "key1", "v1"));
        this.context.getObjectStore().registerNode(o1.getObjectId(), o1);
        Assert.assertEquals((long)1L, (long)this.context.getObjectStore().registeredObjectsCount());
        MockDataObject o2 = new MockDataObject();
        o2.setObjectId(new ObjectId("T", "key1", "v1"));
        this.context.getObjectStore().registerNode(o2.getObjectId(), o2);
        Assert.assertEquals((long)1L, (long)this.context.getObjectStore().registeredObjectsCount());
        MockDataObject o3 = new MockDataObject();
        o3.setObjectId(new ObjectId("T", "key3", "v3"));
        this.context.getObjectStore().registerNode(o3.getObjectId(), o3);
        Assert.assertEquals((long)2L, (long)this.context.getObjectStore().registeredObjectsCount());
    }

    @Test
    public void testObjectsUnregistered() throws Exception {
        DataRow row = new DataRow(10);
        row.put("ARTIST_ID", new Integer(1));
        row.put("ARTIST_NAME", "ArtistXYZ");
        row.put("DATE_OF_BIRTH", new Date());
        DataObject object = this.context.objectFromDataRow(Artist.class, row);
        ObjectId oid = object.getObjectId();
        this.context.getObjectStore().registerNode(oid, object);
        Assert.assertSame((Object)object, (Object)this.context.getObjectStore().getNode(oid));
        Assert.assertNotNull((Object)this.context.getObjectStore().getCachedSnapshot(oid));
        this.context.getObjectStore().objectsUnregistered(Collections.singletonList(object));
        Assert.assertNull((Object)object.getObjectId());
        Assert.assertNull((Object)this.context.getObjectStore().getNode(oid));
        Assert.assertNull((Object)this.context.getObjectStore().getCachedSnapshot(oid));
    }

    @Test
    public void testUnregisterThenRegister() throws Exception {
        Gallery g = this.context.newObject(Gallery.class);
        g.setGalleryName("Test Gallery");
        Artist a = this.context.newObject(Artist.class);
        a.setArtistName("Test Artist");
        Painting p = this.context.newObject(Painting.class);
        p.setPaintingTitle("Test Painting");
        p.setToGallery(g);
        Assert.assertEquals((Object)g, (Object)p.getToGallery());
        this.context.unregisterObjects(Collections.singletonList(p));
        Assert.assertEquals((Object)g, (Object)p.getToGallery());
        p.setToArtist(a);
        this.context.commitChanges();
        Assert.assertEquals((Object)g, (Object)p.getToGallery());
        Painting newP = (Painting)Cayenne.objectForPK(this.context, p.getObjectId());
        Assert.assertNotNull((Object)newP.getToGallery());
    }
}

