/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.List;
import org.apache.cayenne.Cayenne;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ValueHolder;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.RefreshQuery;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;
import org.apache.cayenne.test.jdbc.DBHelper;
import org.apache.cayenne.test.jdbc.TableHelper;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataContextRefreshQueryIT
extends ServerCase {
    @Inject
    protected DataContext context;
    @Inject
    protected DBHelper dbHelper;
    protected TableHelper tArtist;
    protected TableHelper tPainting;

    @Before
    public void setUp() throws Exception {
        this.tArtist = new TableHelper(this.dbHelper, "ARTIST");
        this.tArtist.setColumns(new String[]{"ARTIST_ID", "ARTIST_NAME"});
        this.tPainting = new TableHelper(this.dbHelper, "PAINTING");
        this.tPainting.setColumns(new String[]{"PAINTING_ID", "PAINTING_TITLE", "ARTIST_ID", "ESTIMATED_PRICE"});
    }

    protected void createRefreshCollectionDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "c"});
        this.tArtist.insert(new Object[]{33002, "b"});
        this.tPainting.insert(new Object[]{33001, "P1", 33001, 3000});
        this.tPainting.insert(new Object[]{33002, "P2", 33001, 4000});
    }

    protected void createRefreshCollectionToOneUpdateDataSet() throws Exception {
        this.tPainting.update().set("ARTIST_ID", (Object)33002).execute();
    }

    protected void createRefreshObjectToManyDataSet() throws Exception {
        this.tArtist.insert(new Object[]{33001, "c"});
        this.tPainting.insert(new Object[]{33001, "P1", 33001, 3000});
        this.tPainting.insert(new Object[]{33002, "P2", 33001, 4000});
    }

    protected void createRefreshObjectToManyUpdateDataSet() throws Exception {
        this.tPainting.delete().where("PAINTING_ID", (Object)33001).execute();
    }

    @Test
    public void testRefreshCollection() throws Exception {
        this.createRefreshCollectionDataSet();
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        q.addOrdering("db:ARTIST_ID", SortOrder.ASCENDING);
        List artists = this.context.performQuery(q);
        Artist a1 = (Artist)artists.get(0);
        Artist a2 = (Artist)artists.get(1);
        Assert.assertEquals((long)2L, (long)a1.getPaintingArray().size());
        Assert.assertEquals((long)0L, (long)a2.getPaintingArray().size());
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(a1.getObjectId()));
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(a2.getObjectId()));
        RefreshQuery refresh = new RefreshQuery(artists);
        this.context.performQuery(refresh);
        Assert.assertNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(a1.getObjectId()));
        Assert.assertNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(a2.getObjectId()));
        Assert.assertEquals((long)5L, (long)a1.getPersistenceState());
        Assert.assertEquals((long)5L, (long)a2.getPersistenceState());
        Assert.assertTrue((boolean)((ValueHolder)a1.readProperty(Artist.PAINTING_ARRAY.getName())).isFault());
        Assert.assertTrue((boolean)((ValueHolder)a2.readProperty(Artist.PAINTING_ARRAY.getName())).isFault());
    }

    @Test
    public void testRefreshCollectionToOne() throws Exception {
        this.createRefreshCollectionDataSet();
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class);
        q.addOrdering("db:PAINTING_ID", SortOrder.ASCENDING);
        List paints = this.context.performQuery(q);
        Painting p1 = (Painting)paints.get(0);
        Painting p2 = (Painting)paints.get(1);
        Artist a1 = p1.getToArtist();
        Assert.assertSame((Object)a1, (Object)p2.getToArtist());
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(p1.getObjectId()));
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(p2.getObjectId()));
        this.createRefreshCollectionToOneUpdateDataSet();
        RefreshQuery refresh = new RefreshQuery(paints);
        this.context.performQuery(refresh);
        Assert.assertNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(p1.getObjectId()));
        Assert.assertNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(p2.getObjectId()));
        Assert.assertEquals((long)5L, (long)p1.getPersistenceState());
        Assert.assertEquals((long)5L, (long)p2.getPersistenceState());
        Assert.assertNotSame((Object)a1, (Object)p1.getToArtist());
        Assert.assertNotSame((Object)a1, (Object)p2.getToArtist());
        Assert.assertEquals((Object)"b", (Object)p1.getToArtist().getArtistName());
    }

    @Test
    public void testRefreshSingleObject() throws Exception {
        this.createRefreshCollectionDataSet();
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        q.addOrdering("db:ARTIST_ID", SortOrder.ASCENDING);
        List artists = this.context.performQuery(q);
        Artist a1 = (Artist)artists.get(0);
        Assert.assertEquals((long)2L, (long)a1.getPaintingArray().size());
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(a1.getObjectId()));
        RefreshQuery refresh = new RefreshQuery(a1);
        this.context.performQuery(refresh);
        Assert.assertNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(a1.getObjectId()));
        Assert.assertEquals((long)5L, (long)a1.getPersistenceState());
        Assert.assertTrue((boolean)((ValueHolder)a1.readProperty(Artist.PAINTING_ARRAY.getName())).isFault());
    }

    @Test
    public void testRefreshObjectToMany() throws Exception {
        this.createRefreshObjectToManyDataSet();
        Artist a = Cayenne.objectForPK((ObjectContext)this.context, Artist.class, (Object)33001L);
        Assert.assertEquals((long)2L, (long)a.getPaintingArray().size());
        this.createRefreshObjectToManyUpdateDataSet();
        RefreshQuery refresh = new RefreshQuery(a);
        this.context.performQuery(refresh);
        Assert.assertEquals((long)5L, (long)a.getPersistenceState());
        Assert.assertEquals((long)1L, (long)a.getPaintingArray().size());
    }

    @Test
    public void testRefreshQueryResultsLocalCache() throws Exception {
        this.createRefreshCollectionDataSet();
        Expression qual = Painting.PAINTING_TITLE.eq("P2");
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class, qual);
        q.addOrdering("db:PAINTING_ID", SortOrder.ASCENDING);
        q.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        q.setCacheGroups("X");
        List paints = this.context.performQuery(q);
        Painting p1 = Cayenne.objectForPK((ObjectContext)this.context, Painting.class, 33001);
        Painting p2 = (Painting)paints.get(0);
        Artist a1 = p2.getToArtist();
        Assert.assertSame((Object)a1, (Object)p1.getToArtist());
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(p1.getObjectId()));
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(p2.getObjectId()));
        this.createRefreshCollectionToOneUpdateDataSet();
        RefreshQuery refresh = new RefreshQuery(q);
        this.context.performQuery(refresh);
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(p1.getObjectId()));
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(p2.getObjectId()));
        Assert.assertEquals((long)3L, (long)p1.getPersistenceState());
        Assert.assertEquals((long)3L, (long)p2.getPersistenceState());
        Assert.assertSame((Object)a1, (Object)p1.getToArtist());
        Assert.assertNotSame((Object)a1, (Object)p2.getToArtist());
        Assert.assertEquals((Object)"c", (Object)p1.getToArtist().getArtistName());
        Assert.assertEquals((Object)"b", (Object)p2.getToArtist().getArtistName());
    }

    @Test
    public void testRefreshQueryResultsSharedCache() throws Exception {
        this.createRefreshCollectionDataSet();
        Expression qual = Painting.PAINTING_TITLE.eq("P2");
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class, qual);
        q.addOrdering("db:PAINTING_ID", SortOrder.ASCENDING);
        q.setCacheStrategy(QueryCacheStrategy.SHARED_CACHE);
        q.setCacheGroups("X");
        List paints = this.context.performQuery(q);
        Painting p1 = Cayenne.objectForPK((ObjectContext)this.context, Painting.class, 33001);
        Painting p2 = (Painting)paints.get(0);
        Artist a1 = p2.getToArtist();
        Assert.assertSame((Object)a1, (Object)p1.getToArtist());
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(p1.getObjectId()));
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(p2.getObjectId()));
        this.createRefreshCollectionToOneUpdateDataSet();
        RefreshQuery refresh = new RefreshQuery(q);
        this.context.performQuery(refresh);
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(p1.getObjectId()));
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(p2.getObjectId()));
        Assert.assertEquals((long)3L, (long)p1.getPersistenceState());
        Assert.assertEquals((long)3L, (long)p2.getPersistenceState());
        Assert.assertSame((Object)a1, (Object)p1.getToArtist());
        Assert.assertNotSame((Object)a1, (Object)p2.getToArtist());
        Assert.assertEquals((Object)"c", (Object)p1.getToArtist().getArtistName());
        Assert.assertEquals((Object)"b", (Object)p2.getToArtist().getArtistName());
    }

    @Test
    public void testRefreshQueryResultGroupLocal() throws Exception {
        this.createRefreshCollectionDataSet();
        Expression qual = Painting.PAINTING_TITLE.eq("P2");
        SelectQuery<Painting> q = new SelectQuery<Painting>(Painting.class, qual);
        q.addOrdering("db:PAINTING_ID", SortOrder.ASCENDING);
        q.setCacheStrategy(QueryCacheStrategy.LOCAL_CACHE);
        q.setCacheGroups("X");
        List paints = this.context.performQuery(q);
        Painting p1 = Cayenne.objectForPK((ObjectContext)this.context, Painting.class, 33001);
        Painting p2 = (Painting)paints.get(0);
        Artist a1 = p2.getToArtist();
        Assert.assertSame((Object)a1, (Object)p1.getToArtist());
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(p1.getObjectId()));
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(p2.getObjectId()));
        this.createRefreshCollectionToOneUpdateDataSet();
        this.context.performQuery(q);
        Assert.assertSame((Object)a1, (Object)p1.getToArtist());
        Assert.assertSame((Object)a1, (Object)p2.getToArtist());
        Assert.assertEquals((Object)"c", (Object)p1.getToArtist().getArtistName());
        Assert.assertEquals((Object)"c", (Object)p2.getToArtist().getArtistName());
        RefreshQuery refresh = new RefreshQuery("X");
        this.context.performQuery(refresh);
        this.context.performQuery(q);
        Assert.assertEquals((long)3L, (long)p1.getPersistenceState());
        Assert.assertEquals((long)3L, (long)p2.getPersistenceState());
        Assert.assertSame((Object)a1, (Object)p1.getToArtist());
        Assert.assertNotSame((Object)a1, (Object)p2.getToArtist());
        Assert.assertEquals((Object)"c", (Object)p1.getToArtist().getArtistName());
        Assert.assertEquals((Object)"b", (Object)p2.getToArtist().getArtistName());
    }

    @Test
    public void testRefreshAll() throws Exception {
        this.createRefreshCollectionDataSet();
        SelectQuery<Artist> q = new SelectQuery<Artist>(Artist.class);
        q.addOrdering("db:ARTIST_ID", SortOrder.ASCENDING);
        List artists = this.context.performQuery(q);
        Artist a1 = (Artist)artists.get(0);
        Artist a2 = (Artist)artists.get(1);
        Painting p1 = a1.getPaintingArray().get(0);
        Painting p2 = a1.getPaintingArray().get(0);
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(a1.getObjectId()));
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(a2.getObjectId()));
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(p1.getObjectId()));
        Assert.assertNotNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(p2.getObjectId()));
        RefreshQuery refresh = new RefreshQuery();
        this.context.performQuery(refresh);
        Assert.assertNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(a1.getObjectId()));
        Assert.assertNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(a2.getObjectId()));
        Assert.assertNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(p1.getObjectId()));
        Assert.assertNull((Object)this.context.getParentDataDomain().getSharedSnapshotCache().getCachedSnapshot(p2.getObjectId()));
        Assert.assertEquals((long)5L, (long)a1.getPersistenceState());
        Assert.assertEquals((long)5L, (long)a2.getPersistenceState());
        Assert.assertEquals((long)5L, (long)p1.getPersistenceState());
        Assert.assertEquals((long)5L, (long)p2.getPersistenceState());
    }
}

