/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.HashSet;
import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.query.EJBQLQuery;
import org.apache.cayenne.testdo.inheritance_people.Address;
import org.apache.cayenne.testdo.inheritance_people.Department;
import org.apache.cayenne.testdo.inheritance_people.Manager;
import org.apache.cayenne.unit.di.server.PeopleProjectCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataContextEJBQLConditionsPeopleIT
extends PeopleProjectCase {
    @Inject
    private ObjectContext context;

    @Before
    public void setUp() {
        Department d1 = this.context.newObject(Department.class);
        d1.setName("d1");
        Department d2 = this.context.newObject(Department.class);
        d2.setName("d2");
        Department d3 = this.context.newObject(Department.class);
        d3.setName("d3");
        this.context.commitChanges();
        Manager m1 = this.context.newObject(Manager.class);
        m1.setName("m1");
        m1.setPersonType("EM");
        Manager m2 = this.context.newObject(Manager.class);
        m2.setName("m2");
        m2.setPersonType("EM");
        Manager m3 = this.context.newObject(Manager.class);
        m3.setName("m3");
        m3.setPersonType("EM");
        Address a1 = this.context.newObject(Address.class);
        m1.addToAddresses(a1);
        Address a2 = this.context.newObject(Address.class);
        m2.addToAddresses(a2);
        Address a3 = this.context.newObject(Address.class);
        m3.addToAddresses(a3);
        d1.addToEmployees(m1);
        d1.addToEmployees(m2);
        d3.addToEmployees(m3);
        this.context.commitChanges();
        d1.setToManager(m1);
        d2.setToManager(m2);
        d3.setToManager(m3);
        this.context.commitChanges();
    }

    @Test
    public void testCollectionMemberOfId() throws Exception {
        String ejbql = "SELECT DISTINCT m FROM Manager m JOIN m.managedDepartments d WHERE m MEMBER d.employees";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)2L, (long)objects.size());
        HashSet<String> ids = new HashSet<String>();
        for (Manager m : objects) {
            ids.add(m.getName());
        }
        Assert.assertTrue((boolean)ids.contains("m1"));
        Assert.assertTrue((boolean)ids.contains("m3"));
    }

    @Test
    public void testCollectionNotMemberOfId() throws Exception {
        String ejbql = "SELECT DISTINCT m FROM Manager m JOIN m.managedDepartments d WHERE m NOT MEMBER d.employees";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)1L, (long)objects.size());
        HashSet<String> ids = new HashSet<String>();
        for (Manager m : objects) {
            ids.add(m.getName());
        }
        Assert.assertTrue((boolean)ids.contains("m2"));
    }

    @Test
    public void testCollectionNotMemberOfToOne() throws Exception {
        String ejbql = "SELECT a FROM Address a JOIN a.toEmployee m JOIN m.toDepartment d WHERE m NOT MEMBER d.employees";
        EJBQLQuery query = new EJBQLQuery(ejbql);
        List objects = this.context.performQuery(query);
        Assert.assertEquals((long)0L, (long)objects.size());
    }
}

