/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne;

import java.util.List;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.PersistenceState;
import org.apache.cayenne.access.ToManyList;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.testdo.testmap.Artist;
import org.apache.cayenne.testdo.testmap.Painting;
import org.apache.cayenne.unit.di.server.ServerCase;
import org.apache.cayenne.unit.di.server.UseServerRuntime;
import org.apache.cayenne.util.Util;
import org.junit.Assert;
import org.junit.Test;

@UseServerRuntime(value="cayenne-testmap.xml")
public class DataObjectSerializationIT
extends ServerCase {
    @Inject
    private ObjectContext context;

    @Test
    public void testSerializeTransient() throws Exception {
        Artist artist = new Artist();
        artist.setArtistName("artist1");
        Assert.assertEquals((long)1L, (long)artist.getPersistenceState());
        Assert.assertNull((Object)artist.getObjectId());
        Artist deserialized = Util.cloneViaSerialization(artist);
        Assert.assertEquals((long)1L, (long)deserialized.getPersistenceState());
        Assert.assertNull((Object)deserialized.getObjectId());
        Assert.assertEquals((Object)"artist1", (Object)deserialized.getArtistName());
    }

    @Test
    public void testSerializeNew() throws Exception {
        Artist artist = this.context.newObject(Artist.class);
        artist.setArtistName("artist1");
        artist.getPaintingArray();
        Artist deserialized = Util.cloneViaSerialization(artist);
        Assert.assertEquals((long)2L, (long)deserialized.getPersistenceState());
        Assert.assertTrue((boolean)deserialized.getObjectId().isTemporary());
        Assert.assertEquals((Object)"artist1", (Object)deserialized.getArtistName());
        Assert.assertNull((String)("CDO serialized by itself shouldn't have a DataContext: " + deserialized.getObjectContext()), (Object)deserialized.getObjectContext());
        List<Painting> paintings = deserialized.getPaintingArray();
        Assert.assertNotNull(paintings);
        Assert.assertEquals((long)0L, (long)paintings.size());
    }

    @Test
    public void testSerializeNewWithFaults() throws Exception {
        Artist artist = this.context.newObject(Artist.class);
        artist.setArtistName("artist1");
        Artist deserialized = Util.cloneViaSerialization(artist);
        Assert.assertEquals((long)2L, (long)deserialized.getPersistenceState());
        Assert.assertTrue((boolean)deserialized.getObjectId().isTemporary());
        Assert.assertEquals((Object)"artist1", (Object)deserialized.getArtistName());
        Assert.assertNull((String)("CDO serialized by itself shouldn't have a DataContext: " + deserialized.getObjectContext()), (Object)deserialized.getObjectContext());
        Assert.assertTrue((boolean)(deserialized.readPropertyDirectly("paintingArray") instanceof ToManyList));
        ToManyList list = (ToManyList)artist.readPropertyDirectly("paintingArray");
        Assert.assertFalse((boolean)list.isFault());
    }

    @Test
    public void testSerializeCommitted() throws Exception {
        Artist artist = this.context.newObject(Artist.class);
        artist.setArtistName("artist1");
        this.context.commitChanges();
        Assert.assertEquals((long)3L, (long)artist.getPersistenceState());
        ObjectId id = artist.getObjectId();
        Assert.assertNotNull((Object)id);
        Artist deserialized = Util.cloneViaSerialization(artist);
        Assert.assertEquals((String)("Unexpected persistence state: " + PersistenceState.persistenceStateName(deserialized.getPersistenceState())), (long)5L, (long)deserialized.getPersistenceState());
        Assert.assertEquals((Object)id, (Object)deserialized.getObjectId());
        Assert.assertNull((Object)deserialized.getObjectContext());
        Assert.assertEquals(null, (Object)deserialized.getArtistName());
    }
}

