/* Generated By:JJTree&JavaCC: Do not edit this line. ExpressionParserTokenManager.java */
/*****************************************************************
 *   Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 ****************************************************************/


package org.apache.cayenne.exp.parser;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.cayenne.exp.Expression;

/** Token Manager. */
public class ExpressionParserTokenManager implements ExpressionParserConstants
{
      /** Holds the last value computed by a constant token. */
    Object literalValue;

      /** Holds the last string literal parsed. */
    private StringBuffer stringBuffer;

      /** Converts an escape sequence into a character value. */
    private char escapeChar()
    {
        int ofs = image.length() - 1;
        switch ( image.charAt(ofs) ) {
            case 'n':   return '\u005cn';
            case 'r':   return '\u005cr';
            case 't':   return '\u005ct';
            case 'b':   return '\u005cb';
            case 'f':   return '\u005cf';
            case '\u005c\u005c':  return '\u005c\u005c';
            case '\u005c'':  return '\u005c'';
            case '\u005c"':  return '\u005c"';
        }

          // Otherwise, it's an octal number.  Find the backslash and convert.
        while ( image.charAt(--ofs) != '\u005c\u005c' )
          {}
        int value = 0;
        while ( ++ofs < image.length() )
            value = (value << 3) | (image.charAt(ofs) - '0');
        return (char) value;
    }

    private Object makeInt()
    {
        Object  result;
        String  s = image.toString();
        int     base = 10;

        if ( s.charAt(0) == '0' )
            base = (s.length() > 1 && (s.charAt(1) == 'x' || s.charAt(1) == 'X'))? 16 : 8;
        if ( base == 16 )
            s = s.substring(2); // Trim the 0x off the front
        switch ( s.charAt(s.length()-1) ) {
            case 'l': case 'L':
                result = Long.valueOf( s.substring(0,s.length()-1), base );
                break;

            case 'h': case 'H':
                result = new BigInteger( s.substring(0,s.length()-1), base );
                break;

            default:
                result = Integer.valueOf( s, base );
                break;
        }
        return result;
    }

    private Object makeFloat()
    {
        String s = image.toString();
        switch ( s.charAt(s.length()-1) ) {
            case 'f': case 'F':
                return Float.valueOf( s );

            case 'b': case 'B':
                return new BigDecimal( s.substring(0,s.length()-1) );

            case 'd': case 'D':
            default:
                return Double.valueOf( s );
        }
    }

  /** Debug output. */
  public  java.io.PrintStream debugStream = System.out;
  /** Set debug output. */
  public  void setDebugStream(java.io.PrintStream ds) { debugStream = ds; }
private int jjStopAtPos(int pos, int kind)
{
   jjmatchedKind = kind;
   jjmatchedPos = pos;
   return pos + 1;
}
private int jjMoveStringLiteralDfa0_0()
{
   switch(curChar)
   {
      case 9:
         jjmatchedKind = 30;
         return jjMoveNfa_0(3, 0);
      case 10:
         jjmatchedKind = 31;
         return jjMoveNfa_0(3, 0);
      case 13:
         jjmatchedKind = 32;
         return jjMoveNfa_0(3, 0);
      case 32:
         jjmatchedKind = 29;
         return jjMoveNfa_0(3, 0);
      case 33:
         jjmatchedKind = 4;
         return jjMoveStringLiteralDfa1_0(0x80L);
      case 34:
         jjmatchedKind = 64;
         return jjMoveNfa_0(3, 0);
      case 36:
         jjmatchedKind = 54;
         return jjMoveNfa_0(3, 0);
      case 38:
         jjmatchedKind = 22;
         return jjMoveNfa_0(3, 0);
      case 39:
         jjmatchedKind = 63;
         return jjMoveNfa_0(3, 0);
      case 40:
         jjmatchedKind = 16;
         return jjMoveNfa_0(3, 0);
      case 41:
         jjmatchedKind = 17;
         return jjMoveNfa_0(3, 0);
      case 42:
         jjmatchedKind = 58;
         return jjMoveNfa_0(3, 0);
      case 43:
         jjmatchedKind = 25;
         return jjMoveNfa_0(3, 0);
      case 44:
         jjmatchedKind = 19;
         return jjMoveNfa_0(3, 0);
      case 45:
         jjmatchedKind = 26;
         return jjMoveNfa_0(3, 0);
      case 47:
         jjmatchedKind = 27;
         return jjMoveNfa_0(3, 0);
      case 60:
         jjmatchedKind = 10;
         return jjMoveStringLiteralDfa1_0(0x800300L);
      case 61:
         jjmatchedKind = 5;
         return jjMoveStringLiteralDfa1_0(0x40L);
      case 62:
         jjmatchedKind = 11;
         return jjMoveStringLiteralDfa1_0(0x1001000L);
      case 65:
         return jjMoveStringLiteralDfa1_0(0x1001000000000L);
      case 67:
         return jjMoveStringLiteralDfa1_0(0x38030000000000L);
      case 76:
         return jjMoveStringLiteralDfa1_0(0xd00000000000L);
      case 77:
         return jjMoveStringLiteralDfa1_0(0x4006000000000L);
      case 83:
         return jjMoveStringLiteralDfa1_0(0x2048000000000L);
      case 84:
         return jjMoveStringLiteralDfa1_0(0x80000000000L);
      case 85:
         return jjMoveStringLiteralDfa1_0(0x200000000000L);
      case 94:
         jjmatchedKind = 21;
         return jjMoveNfa_0(3, 0);
      case 97:
         return jjMoveStringLiteralDfa1_0(0x1001000000004L);
      case 98:
         return jjMoveStringLiteralDfa1_0(0x40000L);
      case 99:
         return jjMoveStringLiteralDfa1_0(0x38030000000000L);
      case 100:
         return jjMoveStringLiteralDfa1_0(0x100000000000000L);
      case 101:
         return jjMoveStringLiteralDfa1_0(0x200000000000000L);
      case 105:
         return jjMoveStringLiteralDfa1_0(0x8000L);
      case 108:
         return jjMoveStringLiteralDfa1_0(0xd00000006000L);
      case 109:
         return jjMoveStringLiteralDfa1_0(0x4006000000000L);
      case 110:
         return jjMoveStringLiteralDfa1_0(0x8L);
      case 111:
         return jjMoveStringLiteralDfa1_0(0x80000000000002L);
      case 115:
         return jjMoveStringLiteralDfa1_0(0x2048000000000L);
      case 116:
         return jjMoveStringLiteralDfa1_0(0x80000000000L);
      case 117:
         return jjMoveStringLiteralDfa1_0(0x200000000000L);
      case 124:
         jjmatchedKind = 20;
         return jjMoveNfa_0(3, 0);
      case 126:
         jjmatchedKind = 28;
         return jjMoveNfa_0(3, 0);
      default :
         return jjMoveNfa_0(3, 0);
   }
}
private int jjMoveStringLiteralDfa1_0(long active0)
{
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
   return jjMoveNfa_0(3, 0);
   }
   switch(curChar)
   {
      case 60:
         if ((active0 & 0x800000L) != 0L)
         {
            jjmatchedKind = 23;
            jjmatchedPos = 1;
         }
         break;
      case 61:
         if ((active0 & 0x40L) != 0L)
         {
            jjmatchedKind = 6;
            jjmatchedPos = 1;
         }
         else if ((active0 & 0x80L) != 0L)
         {
            jjmatchedKind = 7;
            jjmatchedPos = 1;
         }
         else if ((active0 & 0x200L) != 0L)
         {
            jjmatchedKind = 9;
            jjmatchedPos = 1;
         }
         else if ((active0 & 0x1000L) != 0L)
         {
            jjmatchedKind = 12;
            jjmatchedPos = 1;
         }
         break;
      case 62:
         if ((active0 & 0x100L) != 0L)
         {
            jjmatchedKind = 8;
            jjmatchedPos = 1;
         }
         else if ((active0 & 0x1000000L) != 0L)
         {
            jjmatchedKind = 24;
            jjmatchedPos = 1;
         }
         break;
      case 65:
         return jjMoveStringLiteralDfa2_0(active0, 0x4000000000L);
      case 66:
         return jjMoveStringLiteralDfa2_0(active0, 0x1000000000000L);
      case 69:
         return jjMoveStringLiteralDfa2_0(active0, 0x400000000000L);
      case 73:
         return jjMoveStringLiteralDfa2_0(active0, 0x2000000000L);
      case 79:
         return jjMoveStringLiteralDfa2_0(active0, 0x4930000000000L);
      case 80:
         return jjMoveStringLiteralDfa2_0(active0, 0x200000000000L);
      case 81:
         return jjMoveStringLiteralDfa2_0(active0, 0x2000000000000L);
      case 82:
         return jjMoveStringLiteralDfa2_0(active0, 0x80000000000L);
      case 85:
         return jjMoveStringLiteralDfa2_0(active0, 0x38048000000000L);
      case 86:
         return jjMoveStringLiteralDfa2_0(active0, 0x1000000000L);
      case 97:
         return jjMoveStringLiteralDfa2_0(active0, 0x4000000000L);
      case 98:
         return jjMoveStringLiteralDfa2_0(active0, 0x181000000000000L);
      case 101:
         return jjMoveStringLiteralDfa2_0(active0, 0x400000040000L);
      case 105:
         return jjMoveStringLiteralDfa2_0(active0, 0x2000006000L);
      case 110:
         if ((active0 & 0x8000L) != 0L)
         {
            jjmatchedKind = 15;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_0(active0, 0x200000000000004L);
      case 111:
         return jjMoveStringLiteralDfa2_0(active0, 0x4930000000008L);
      case 112:
         return jjMoveStringLiteralDfa2_0(active0, 0x200000000000L);
      case 113:
         return jjMoveStringLiteralDfa2_0(active0, 0x2000000000000L);
      case 114:
         if ((active0 & 0x2L) != 0L)
         {
            jjmatchedKind = 1;
            jjmatchedPos = 1;
         }
         return jjMoveStringLiteralDfa2_0(active0, 0x80000000000L);
      case 117:
         return jjMoveStringLiteralDfa2_0(active0, 0x38048000000000L);
      case 118:
         return jjMoveStringLiteralDfa2_0(active0, 0x1000000000L);
      default :
         break;
   }
   return jjMoveNfa_0(3, 1);
}
private int jjMoveStringLiteralDfa2_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjMoveNfa_0(3, 1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
   return jjMoveNfa_0(3, 1);
   }
   switch(curChar)
   {
      case 58:
         if ((active0 & 0x100000000000000L) != 0L)
         {
            jjmatchedKind = 56;
            jjmatchedPos = 2;
         }
         break;
      case 66:
         return jjMoveStringLiteralDfa3_0(active0, 0x40000000000L);
      case 67:
         return jjMoveStringLiteralDfa3_0(active0, 0x800000000000L);
      case 68:
         if ((active0 & 0x4000000000000L) != 0L)
         {
            jjmatchedKind = 50;
            jjmatchedPos = 2;
         }
         break;
      case 71:
         if ((active0 & 0x1000000000L) != 0L)
         {
            jjmatchedKind = 36;
            jjmatchedPos = 2;
         }
         break;
      case 73:
         return jjMoveStringLiteralDfa3_0(active0, 0x80000000000L);
      case 77:
         if ((active0 & 0x8000000000L) != 0L)
         {
            jjmatchedKind = 39;
            jjmatchedPos = 2;
         }
         break;
      case 78:
         if ((active0 & 0x2000000000L) != 0L)
         {
            jjmatchedKind = 37;
            jjmatchedPos = 2;
         }
         return jjMoveStringLiteralDfa3_0(active0, 0x420000000000L);
      case 80:
         return jjMoveStringLiteralDfa3_0(active0, 0x200000000000L);
      case 82:
         return jjMoveStringLiteralDfa3_0(active0, 0x3a000000000000L);
      case 83:
         if ((active0 & 0x1000000000000L) != 0L)
         {
            jjmatchedKind = 48;
            jjmatchedPos = 2;
         }
         break;
      case 85:
         return jjMoveStringLiteralDfa3_0(active0, 0x10000000000L);
      case 87:
         return jjMoveStringLiteralDfa3_0(active0, 0x100000000000L);
      case 88:
         if ((active0 & 0x4000000000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 2;
         }
         break;
      case 98:
         return jjMoveStringLiteralDfa3_0(active0, 0x40000000000L);
      case 99:
         return jjMoveStringLiteralDfa3_0(active0, 0x800000000000L);
      case 100:
         if ((active0 & 0x4L) != 0L)
         {
            jjmatchedKind = 2;
            jjmatchedPos = 2;
         }
         else if ((active0 & 0x4000000000000L) != 0L)
         {
            jjmatchedKind = 50;
            jjmatchedPos = 2;
         }
         break;
      case 103:
         if ((active0 & 0x1000000000L) != 0L)
         {
            jjmatchedKind = 36;
            jjmatchedPos = 2;
         }
         break;
      case 105:
         return jjMoveStringLiteralDfa3_0(active0, 0x80000000000L);
      case 106:
         return jjMoveStringLiteralDfa3_0(active0, 0x80000000000000L);
      case 107:
         return jjMoveStringLiteralDfa3_0(active0, 0x6000L);
      case 109:
         if ((active0 & 0x8000000000L) != 0L)
         {
            jjmatchedKind = 39;
            jjmatchedPos = 2;
         }
         break;
      case 110:
         if ((active0 & 0x2000000000L) != 0L)
         {
            jjmatchedKind = 37;
            jjmatchedPos = 2;
         }
         return jjMoveStringLiteralDfa3_0(active0, 0x420000000000L);
      case 112:
         return jjMoveStringLiteralDfa3_0(active0, 0x200000000000L);
      case 114:
         return jjMoveStringLiteralDfa3_0(active0, 0x3a000000000000L);
      case 115:
         if ((active0 & 0x1000000000000L) != 0L)
         {
            jjmatchedKind = 48;
            jjmatchedPos = 2;
         }
         break;
      case 116:
         if ((active0 & 0x8L) != 0L)
         {
            jjmatchedKind = 3;
            jjmatchedPos = 2;
         }
         return jjMoveStringLiteralDfa3_0(active0, 0x40000L);
      case 117:
         return jjMoveStringLiteralDfa3_0(active0, 0x200010000000000L);
      case 119:
         return jjMoveStringLiteralDfa3_0(active0, 0x100000000000L);
      case 120:
         if ((active0 & 0x4000000000L) != 0L)
         {
            jjmatchedKind = 38;
            jjmatchedPos = 2;
         }
         break;
      default :
         break;
   }
   return jjMoveNfa_0(3, 2);
}
private int jjMoveStringLiteralDfa3_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjMoveNfa_0(3, 2);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
   return jjMoveNfa_0(3, 2);
   }
   switch(curChar)
   {
      case 58:
         if ((active0 & 0x80000000000000L) != 0L)
         {
            jjmatchedKind = 55;
            jjmatchedPos = 3;
         }
         break;
      case 65:
         return jjMoveStringLiteralDfa4_0(active0, 0x800000000000L);
      case 67:
         return jjMoveStringLiteralDfa4_0(active0, 0x20000000000L);
      case 69:
         return jjMoveStringLiteralDfa4_0(active0, 0x300000000000L);
      case 71:
         return jjMoveStringLiteralDfa4_0(active0, 0x400000000000L);
      case 77:
         if ((active0 & 0x80000000000L) != 0L)
         {
            jjmatchedKind = 43;
            jjmatchedPos = 3;
         }
         break;
      case 78:
         return jjMoveStringLiteralDfa4_0(active0, 0x10000000000L);
      case 82:
         return jjMoveStringLiteralDfa4_0(active0, 0x38000000000000L);
      case 83:
         return jjMoveStringLiteralDfa4_0(active0, 0x40000000000L);
      case 84:
         if ((active0 & 0x2000000000000L) != 0L)
         {
            jjmatchedKind = 49;
            jjmatchedPos = 3;
         }
         break;
      case 97:
         return jjMoveStringLiteralDfa4_0(active0, 0x800000000000L);
      case 99:
         return jjMoveStringLiteralDfa4_0(active0, 0x20000000000L);
      case 101:
         if ((active0 & 0x2000L) != 0L)
         {
            jjmatchedKind = 13;
            jjmatchedPos = 3;
         }
         return jjMoveStringLiteralDfa4_0(active0, 0x300000004000L);
      case 103:
         return jjMoveStringLiteralDfa4_0(active0, 0x400000000000L);
      case 109:
         if ((active0 & 0x80000000000L) != 0L)
         {
            jjmatchedKind = 43;
            jjmatchedPos = 3;
         }
         return jjMoveStringLiteralDfa4_0(active0, 0x200000000000000L);
      case 110:
         return jjMoveStringLiteralDfa4_0(active0, 0x10000000000L);
      case 114:
         return jjMoveStringLiteralDfa4_0(active0, 0x38000000000000L);
      case 115:
         return jjMoveStringLiteralDfa4_0(active0, 0x40000000000L);
      case 116:
         if ((active0 & 0x2000000000000L) != 0L)
         {
            jjmatchedKind = 49;
            jjmatchedPos = 3;
         }
         break;
      case 119:
         return jjMoveStringLiteralDfa4_0(active0, 0x40000L);
      default :
         break;
   }
   return jjMoveNfa_0(3, 3);
}
private int jjMoveStringLiteralDfa4_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjMoveNfa_0(3, 3);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
   return jjMoveNfa_0(3, 3);
   }
   switch(curChar)
   {
      case 58:
         if ((active0 & 0x200000000000000L) != 0L)
         {
            jjmatchedKind = 57;
            jjmatchedPos = 4;
         }
         break;
      case 65:
         return jjMoveStringLiteralDfa5_0(active0, 0x20000000000L);
      case 69:
         return jjMoveStringLiteralDfa5_0(active0, 0x38000000000000L);
      case 73:
         return jjMoveStringLiteralDfa5_0(active0, 0x4000L);
      case 82:
         if ((active0 & 0x100000000000L) != 0L)
         {
            jjmatchedKind = 44;
            jjmatchedPos = 4;
         }
         else if ((active0 & 0x200000000000L) != 0L)
         {
            jjmatchedKind = 45;
            jjmatchedPos = 4;
         }
         break;
      case 84:
         if ((active0 & 0x10000000000L) != 0L)
         {
            jjmatchedKind = 40;
            jjmatchedPos = 4;
         }
         return jjMoveStringLiteralDfa5_0(active0, 0xc40000000000L);
      case 97:
         return jjMoveStringLiteralDfa5_0(active0, 0x20000000000L);
      case 101:
         return jjMoveStringLiteralDfa5_0(active0, 0x38000000040000L);
      case 114:
         if ((active0 & 0x100000000000L) != 0L)
         {
            jjmatchedKind = 44;
            jjmatchedPos = 4;
         }
         else if ((active0 & 0x200000000000L) != 0L)
         {
            jjmatchedKind = 45;
            jjmatchedPos = 4;
         }
         break;
      case 116:
         if ((active0 & 0x10000000000L) != 0L)
         {
            jjmatchedKind = 40;
            jjmatchedPos = 4;
         }
         return jjMoveStringLiteralDfa5_0(active0, 0xc40000000000L);
      default :
         break;
   }
   return jjMoveNfa_0(3, 4);
}
private int jjMoveStringLiteralDfa5_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjMoveNfa_0(3, 4);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
   return jjMoveNfa_0(3, 4);
   }
   switch(curChar)
   {
      case 69:
         if ((active0 & 0x800000000000L) != 0L)
         {
            jjmatchedKind = 47;
            jjmatchedPos = 5;
         }
         break;
      case 72:
         if ((active0 & 0x400000000000L) != 0L)
         {
            jjmatchedKind = 46;
            jjmatchedPos = 5;
         }
         break;
      case 78:
         return jjMoveStringLiteralDfa6_0(active0, 0x38000000000000L);
      case 82:
         return jjMoveStringLiteralDfa6_0(active0, 0x40000000000L);
      case 84:
         if ((active0 & 0x20000000000L) != 0L)
         {
            jjmatchedKind = 41;
            jjmatchedPos = 5;
         }
         break;
      case 101:
         if ((active0 & 0x800000000000L) != 0L)
         {
            jjmatchedKind = 47;
            jjmatchedPos = 5;
         }
         return jjMoveStringLiteralDfa6_0(active0, 0x40000L);
      case 103:
         return jjMoveStringLiteralDfa6_0(active0, 0x4000L);
      case 104:
         if ((active0 & 0x400000000000L) != 0L)
         {
            jjmatchedKind = 46;
            jjmatchedPos = 5;
         }
         break;
      case 110:
         return jjMoveStringLiteralDfa6_0(active0, 0x38000000000000L);
      case 114:
         return jjMoveStringLiteralDfa6_0(active0, 0x40000000000L);
      case 116:
         if ((active0 & 0x20000000000L) != 0L)
         {
            jjmatchedKind = 41;
            jjmatchedPos = 5;
         }
         break;
      default :
         break;
   }
   return jjMoveNfa_0(3, 5);
}
private int jjMoveStringLiteralDfa6_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjMoveNfa_0(3, 5);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
   return jjMoveNfa_0(3, 5);
   }
   switch(curChar)
   {
      case 73:
         return jjMoveStringLiteralDfa7_0(active0, 0x40000000000L);
      case 84:
         return jjMoveStringLiteralDfa7_0(active0, 0x38000000000000L);
      case 105:
         return jjMoveStringLiteralDfa7_0(active0, 0x40000000000L);
      case 110:
         if ((active0 & 0x40000L) != 0L)
         {
            jjmatchedKind = 18;
            jjmatchedPos = 6;
         }
         return jjMoveStringLiteralDfa7_0(active0, 0x4000L);
      case 116:
         return jjMoveStringLiteralDfa7_0(active0, 0x38000000000000L);
      default :
         break;
   }
   return jjMoveNfa_0(3, 6);
}
private int jjMoveStringLiteralDfa7_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjMoveNfa_0(3, 6);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
   return jjMoveNfa_0(3, 6);
   }
   switch(curChar)
   {
      case 78:
         return jjMoveStringLiteralDfa8_0(active0, 0x40000000000L);
      case 95:
         return jjMoveStringLiteralDfa8_0(active0, 0x38000000000000L);
      case 110:
         return jjMoveStringLiteralDfa8_0(active0, 0x40000000000L);
      case 111:
         return jjMoveStringLiteralDfa8_0(active0, 0x4000L);
      default :
         break;
   }
   return jjMoveNfa_0(3, 7);
}
private int jjMoveStringLiteralDfa8_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjMoveNfa_0(3, 7);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
   return jjMoveNfa_0(3, 7);
   }
   switch(curChar)
   {
      case 68:
         return jjMoveStringLiteralDfa9_0(active0, 0x8000000000000L);
      case 71:
         if ((active0 & 0x40000000000L) != 0L)
         {
            jjmatchedKind = 42;
            jjmatchedPos = 8;
         }
         break;
      case 84:
         return jjMoveStringLiteralDfa9_0(active0, 0x30000000000000L);
      case 100:
         return jjMoveStringLiteralDfa9_0(active0, 0x8000000000000L);
      case 103:
         if ((active0 & 0x40000000000L) != 0L)
         {
            jjmatchedKind = 42;
            jjmatchedPos = 8;
         }
         break;
      case 114:
         return jjMoveStringLiteralDfa9_0(active0, 0x4000L);
      case 116:
         return jjMoveStringLiteralDfa9_0(active0, 0x30000000000000L);
      default :
         break;
   }
   return jjMoveNfa_0(3, 8);
}
private int jjMoveStringLiteralDfa9_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjMoveNfa_0(3, 8);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
   return jjMoveNfa_0(3, 8);
   }
   switch(curChar)
   {
      case 65:
         return jjMoveStringLiteralDfa10_0(active0, 0x8000000000000L);
      case 73:
         return jjMoveStringLiteralDfa10_0(active0, 0x30000000000000L);
      case 97:
         return jjMoveStringLiteralDfa10_0(active0, 0x8000000000000L);
      case 101:
         return jjMoveStringLiteralDfa10_0(active0, 0x4000L);
      case 105:
         return jjMoveStringLiteralDfa10_0(active0, 0x30000000000000L);
      default :
         break;
   }
   return jjMoveNfa_0(3, 9);
}
private int jjMoveStringLiteralDfa10_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjMoveNfa_0(3, 9);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
   return jjMoveNfa_0(3, 9);
   }
   switch(curChar)
   {
      case 67:
         return jjMoveStringLiteralDfa11_0(active0, 0x4000L);
      case 77:
         return jjMoveStringLiteralDfa11_0(active0, 0x30000000000000L);
      case 84:
         return jjMoveStringLiteralDfa11_0(active0, 0x8000000000000L);
      case 109:
         return jjMoveStringLiteralDfa11_0(active0, 0x30000000000000L);
      case 116:
         return jjMoveStringLiteralDfa11_0(active0, 0x8000000000000L);
      default :
         break;
   }
   return jjMoveNfa_0(3, 10);
}
private int jjMoveStringLiteralDfa11_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjMoveNfa_0(3, 10);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
   return jjMoveNfa_0(3, 10);
   }
   switch(curChar)
   {
      case 69:
         if ((active0 & 0x8000000000000L) != 0L)
         {
            jjmatchedKind = 51;
            jjmatchedPos = 11;
         }
         else if ((active0 & 0x10000000000000L) != 0L)
         {
            jjmatchedKind = 52;
            jjmatchedPos = 11;
         }
         return jjMoveStringLiteralDfa12_0(active0, 0x20000000000000L);
      case 97:
         return jjMoveStringLiteralDfa12_0(active0, 0x4000L);
      case 101:
         if ((active0 & 0x8000000000000L) != 0L)
         {
            jjmatchedKind = 51;
            jjmatchedPos = 11;
         }
         else if ((active0 & 0x10000000000000L) != 0L)
         {
            jjmatchedKind = 52;
            jjmatchedPos = 11;
         }
         return jjMoveStringLiteralDfa12_0(active0, 0x20000000000000L);
      default :
         break;
   }
   return jjMoveNfa_0(3, 11);
}
private int jjMoveStringLiteralDfa12_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjMoveNfa_0(3, 11);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
   return jjMoveNfa_0(3, 11);
   }
   switch(curChar)
   {
      case 83:
         return jjMoveStringLiteralDfa13_0(active0, 0x20000000000000L);
      case 115:
         return jjMoveStringLiteralDfa13_0(active0, 0x20000000004000L);
      default :
         break;
   }
   return jjMoveNfa_0(3, 12);
}
private int jjMoveStringLiteralDfa13_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjMoveNfa_0(3, 12);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
   return jjMoveNfa_0(3, 12);
   }
   switch(curChar)
   {
      case 84:
         return jjMoveStringLiteralDfa14_0(active0, 0x20000000000000L);
      case 101:
         if ((active0 & 0x4000L) != 0L)
         {
            jjmatchedKind = 14;
            jjmatchedPos = 13;
         }
         break;
      case 116:
         return jjMoveStringLiteralDfa14_0(active0, 0x20000000000000L);
      default :
         break;
   }
   return jjMoveNfa_0(3, 13);
}
private int jjMoveStringLiteralDfa14_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjMoveNfa_0(3, 13);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
   return jjMoveNfa_0(3, 13);
   }
   switch(curChar)
   {
      case 65:
         return jjMoveStringLiteralDfa15_0(active0, 0x20000000000000L);
      case 97:
         return jjMoveStringLiteralDfa15_0(active0, 0x20000000000000L);
      default :
         break;
   }
   return jjMoveNfa_0(3, 14);
}
private int jjMoveStringLiteralDfa15_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjMoveNfa_0(3, 14);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
   return jjMoveNfa_0(3, 14);
   }
   switch(curChar)
   {
      case 77:
         return jjMoveStringLiteralDfa16_0(active0, 0x20000000000000L);
      case 109:
         return jjMoveStringLiteralDfa16_0(active0, 0x20000000000000L);
      default :
         break;
   }
   return jjMoveNfa_0(3, 15);
}
private int jjMoveStringLiteralDfa16_0(long old0, long active0)
{
   if (((active0 &= old0)) == 0L)
      return jjMoveNfa_0(3, 15);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) {
   return jjMoveNfa_0(3, 15);
   }
   switch(curChar)
   {
      case 80:
         if ((active0 & 0x20000000000000L) != 0L)
         {
            jjmatchedKind = 53;
            jjmatchedPos = 16;
         }
         break;
      case 112:
         if ((active0 & 0x20000000000000L) != 0L)
         {
            jjmatchedKind = 53;
            jjmatchedPos = 16;
         }
         break;
      default :
         break;
   }
   return jjMoveNfa_0(3, 16);
}
private int jjMoveNfa_0(int startState, int curPos)
{
   int strKind = jjmatchedKind;
   int strPos = jjmatchedPos;
   int seenUpto;
   input_stream.backup(seenUpto = curPos + 1);
   try { curChar = input_stream.readChar(); }
   catch(java.io.IOException e) { throw new Error("Internal Error"); }
   curPos = 0;
   int startsAt = 0;
   jjnewStateCnt = 56;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 3:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddStates(0, 5);
                  else if (curChar == 46)
                     jjCheckNAdd(30);
                  if ((0x3fe000000000000L & l) != 0L)
                  {
                     if (kind > 71)
                        kind = 71;
                     jjCheckNAddTwoStates(27, 28);
                  }
                  else if (curChar == 48)
                  {
                     if (kind > 71)
                        kind = 71;
                     jjCheckNAddStates(6, 8);
                  }
                  break;
               case 26:
                  if ((0x3fe000000000000L & l) == 0L)
                     break;
                  if (kind > 71)
                     kind = 71;
                  jjCheckNAddTwoStates(27, 28);
                  break;
               case 27:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 71)
                     kind = 71;
                  jjCheckNAddTwoStates(27, 28);
                  break;
               case 29:
                  if (curChar == 46)
                     jjCheckNAdd(30);
                  break;
               case 30:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 72)
                     kind = 72;
                  jjCheckNAddStates(9, 11);
                  break;
               case 32:
                  if ((0x280000000000L & l) != 0L)
                     jjCheckNAdd(33);
                  break;
               case 33:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 72)
                     kind = 72;
                  jjCheckNAddTwoStates(33, 34);
                  break;
               case 35:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddStates(0, 5);
                  break;
               case 36:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(36, 37);
                  break;
               case 37:
                  if (curChar != 46)
                     break;
                  if (kind > 72)
                     kind = 72;
                  jjCheckNAddStates(12, 14);
                  break;
               case 38:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 72)
                     kind = 72;
                  jjCheckNAddStates(12, 14);
                  break;
               case 39:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(39, 40);
                  break;
               case 41:
                  if ((0x280000000000L & l) != 0L)
                     jjCheckNAdd(42);
                  break;
               case 42:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 72)
                     kind = 72;
                  jjCheckNAddTwoStates(42, 34);
                  break;
               case 43:
                  if ((0x3ff000000000000L & l) != 0L)
                     jjCheckNAddTwoStates(43, 34);
                  break;
               case 44:
                  if (curChar != 48)
                     break;
                  if (kind > 71)
                     kind = 71;
                  jjCheckNAddStates(6, 8);
                  break;
               case 45:
                  if ((0xff000000000000L & l) == 0L)
                     break;
                  if (kind > 71)
                     kind = 71;
                  jjCheckNAddTwoStates(45, 28);
                  break;
               case 47:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 71)
                     kind = 71;
                  jjCheckNAddTwoStates(47, 28);
                  break;
               case 49:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 59)
                     kind = 59;
                  jjCheckNAddStates(15, 17);
                  break;
               case 50:
                  if (curChar != 43)
                     break;
                  if (kind > 59)
                     kind = 59;
                  jjCheckNAdd(51);
                  break;
               case 51:
                  if (curChar == 46)
                     jjstateSet[jjnewStateCnt++] = 52;
                  break;
               case 53:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 59)
                     kind = 59;
                  jjCheckNAddStates(18, 20);
                  break;
               case 54:
                  if ((0x3ff000000000000L & l) == 0L)
                     break;
                  if (kind > 60)
                     kind = 60;
                  jjAddStates(21, 22);
                  break;
               case 55:
                  if (curChar == 43 && kind > 60)
                     kind = 60;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 3:
                  if ((0x7fffffe87fffffeL & l) != 0L)
                  {
                     if (kind > 59)
                        kind = 59;
                     jjCheckNAddStates(23, 27);
                  }
                  if (curChar == 70)
                     jjstateSet[jjnewStateCnt++] = 24;
                  else if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 19;
                  else if (curChar == 84)
                     jjstateSet[jjnewStateCnt++] = 14;
                  else if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 10;
                  else if (curChar == 78)
                     jjstateSet[jjnewStateCnt++] = 6;
                  else if (curChar == 110)
                     jjstateSet[jjnewStateCnt++] = 2;
                  break;
               case 0:
                  if (curChar == 108 && kind > 33)
                     kind = 33;
                  break;
               case 1:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 0;
                  break;
               case 2:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 1;
                  break;
               case 4:
                  if (curChar == 76 && kind > 33)
                     kind = 33;
                  break;
               case 5:
                  if (curChar == 76)
                     jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 6:
                  if (curChar == 85)
                     jjstateSet[jjnewStateCnt++] = 5;
                  break;
               case 7:
                  if (curChar == 78)
                     jjstateSet[jjnewStateCnt++] = 6;
                  break;
               case 8:
                  if (curChar == 101 && kind > 34)
                     kind = 34;
                  break;
               case 9:
                  if (curChar == 117)
                     jjstateSet[jjnewStateCnt++] = 8;
                  break;
               case 10:
                  if (curChar == 114)
                     jjstateSet[jjnewStateCnt++] = 9;
                  break;
               case 11:
                  if (curChar == 116)
                     jjstateSet[jjnewStateCnt++] = 10;
                  break;
               case 12:
                  if (curChar == 69 && kind > 34)
                     kind = 34;
                  break;
               case 13:
                  if (curChar == 85)
                     jjstateSet[jjnewStateCnt++] = 12;
                  break;
               case 14:
                  if (curChar == 82)
                     jjstateSet[jjnewStateCnt++] = 13;
                  break;
               case 15:
                  if (curChar == 84)
                     jjstateSet[jjnewStateCnt++] = 14;
                  break;
               case 16:
                  if (curChar == 101 && kind > 35)
                     kind = 35;
                  break;
               case 17:
                  if (curChar == 115)
                     jjstateSet[jjnewStateCnt++] = 16;
                  break;
               case 18:
                  if (curChar == 108)
                     jjstateSet[jjnewStateCnt++] = 17;
                  break;
               case 19:
                  if (curChar == 97)
                     jjstateSet[jjnewStateCnt++] = 18;
                  break;
               case 20:
                  if (curChar == 102)
                     jjstateSet[jjnewStateCnt++] = 19;
                  break;
               case 21:
                  if (curChar == 69 && kind > 35)
                     kind = 35;
                  break;
               case 22:
                  if (curChar == 83)
                     jjstateSet[jjnewStateCnt++] = 21;
                  break;
               case 23:
                  if (curChar == 76)
                     jjstateSet[jjnewStateCnt++] = 22;
                  break;
               case 24:
                  if (curChar == 65)
                     jjstateSet[jjnewStateCnt++] = 23;
                  break;
               case 25:
                  if (curChar == 70)
                     jjstateSet[jjnewStateCnt++] = 24;
                  break;
               case 28:
                  if ((0x110000001100L & l) != 0L && kind > 71)
                     kind = 71;
                  break;
               case 31:
                  if ((0x2000000020L & l) != 0L)
                     jjAddStates(28, 29);
                  break;
               case 34:
                  if ((0x5400000054L & l) != 0L && kind > 72)
                     kind = 72;
                  break;
               case 40:
                  if ((0x2000000020L & l) != 0L)
                     jjAddStates(30, 31);
                  break;
               case 46:
                  if ((0x100000001000000L & l) != 0L)
                     jjCheckNAdd(47);
                  break;
               case 47:
                  if ((0x7e0000007eL & l) == 0L)
                     break;
                  if (kind > 71)
                     kind = 71;
                  jjCheckNAddTwoStates(47, 28);
                  break;
               case 48:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 59)
                     kind = 59;
                  jjCheckNAddStates(23, 27);
                  break;
               case 49:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 59)
                     kind = 59;
                  jjCheckNAddStates(15, 17);
                  break;
               case 52:
               case 53:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 59)
                     kind = 59;
                  jjCheckNAddStates(18, 20);
                  break;
               case 54:
                  if ((0x7fffffe87fffffeL & l) == 0L)
                     break;
                  if (kind > 60)
                     kind = 60;
                  jjCheckNAddTwoStates(54, 55);
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 56 - (jjnewStateCnt = startsAt)))
         break;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { break; }
   }
   if (jjmatchedPos > strPos)
      return curPos;

   int toRet = Math.max(curPos, seenUpto);

   if (curPos < toRet)
      for (i = toRet - Math.min(curPos, seenUpto); i-- > 0; )
         try { curChar = input_stream.readChar(); }
         catch(java.io.IOException e) { throw new Error("Internal Error : Please send a bug report."); }

   if (jjmatchedPos < strPos)
   {
      jjmatchedKind = strKind;
      jjmatchedPos = strPos;
   }
   else if (jjmatchedPos == strPos && jjmatchedKind > strKind)
      jjmatchedKind = strKind;

   return toRet;
}
private final int jjStopStringLiteralDfa_1(int pos, long active0, long active1)
{
   switch (pos)
   {
      default :
         return -1;
   }
}
private final int jjStartNfa_1(int pos, long active0, long active1)
{
   return jjMoveNfa_1(jjStopStringLiteralDfa_1(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_1()
{
   switch(curChar)
   {
      case 39:
         return jjStopAtPos(0, 67);
      default :
         return jjMoveNfa_1(0, 0);
   }
}
static final long[] jjbitVec0 = {
   0xfffffffffffffffeL, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL
};
static final long[] jjbitVec2 = {
   0x0L, 0x0L, 0xffffffffffffffffL, 0xffffffffffffffffL
};
private int jjMoveNfa_1(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 6;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xffffff7fffffffffL & l) != 0L && kind > 66)
                     kind = 66;
                  break;
               case 1:
                  if ((0x8400000000L & l) != 0L && kind > 65)
                     kind = 65;
                  break;
               case 2:
                  if ((0xf000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 3;
                  break;
               case 3:
                  if ((0xff000000000000L & l) == 0L)
                     break;
                  if (kind > 65)
                     kind = 65;
                  jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 4:
                  if ((0xff000000000000L & l) != 0L && kind > 65)
                     kind = 65;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xffffffffefffffffL & l) != 0L)
                  {
                     if (kind > 66)
                        kind = 66;
                  }
                  else if (curChar == 92)
                     jjAddStates(32, 34);
                  break;
               case 1:
                  if ((0x14404510000000L & l) != 0L && kind > 65)
                     kind = 65;
                  break;
               case 5:
                  if ((0xffffffffefffffffL & l) != 0L && kind > 66)
                     kind = 66;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 66)
                     kind = 66;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 6 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
private final int jjStopStringLiteralDfa_2(int pos, long active0, long active1)
{
   switch (pos)
   {
      default :
         return -1;
   }
}
private final int jjStartNfa_2(int pos, long active0, long active1)
{
   return jjMoveNfa_2(jjStopStringLiteralDfa_2(pos, active0, active1), pos + 1);
}
private int jjMoveStringLiteralDfa0_2()
{
   switch(curChar)
   {
      case 34:
         return jjStopAtPos(0, 70);
      default :
         return jjMoveNfa_2(0, 0);
   }
}
private int jjMoveNfa_2(int startState, int curPos)
{
   int startsAt = 0;
   jjnewStateCnt = 6;
   int i = 1;
   jjstateSet[0] = startState;
   int kind = 0x7fffffff;
   for (;;)
   {
      if (++jjround == 0x7fffffff)
         ReInitRounds();
      if (curChar < 64)
      {
         long l = 1L << curChar;
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xfffffffbffffffffL & l) != 0L && kind > 69)
                     kind = 69;
                  break;
               case 1:
                  if ((0x8400000000L & l) != 0L && kind > 68)
                     kind = 68;
                  break;
               case 2:
                  if ((0xf000000000000L & l) != 0L)
                     jjstateSet[jjnewStateCnt++] = 3;
                  break;
               case 3:
                  if ((0xff000000000000L & l) == 0L)
                     break;
                  if (kind > 68)
                     kind = 68;
                  jjstateSet[jjnewStateCnt++] = 4;
                  break;
               case 4:
                  if ((0xff000000000000L & l) != 0L && kind > 68)
                     kind = 68;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else if (curChar < 128)
      {
         long l = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if ((0xffffffffefffffffL & l) != 0L)
                  {
                     if (kind > 69)
                        kind = 69;
                  }
                  else if (curChar == 92)
                     jjAddStates(32, 34);
                  break;
               case 1:
                  if ((0x14404510000000L & l) != 0L && kind > 68)
                     kind = 68;
                  break;
               case 5:
                  if ((0xffffffffefffffffL & l) != 0L && kind > 69)
                     kind = 69;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      else
      {
         int hiByte = (int)(curChar >> 8);
         int i1 = hiByte >> 6;
         long l1 = 1L << (hiByte & 077);
         int i2 = (curChar & 0xff) >> 6;
         long l2 = 1L << (curChar & 077);
         do
         {
            switch(jjstateSet[--i])
            {
               case 0:
                  if (jjCanMove_0(hiByte, i1, i2, l1, l2) && kind > 69)
                     kind = 69;
                  break;
               default : break;
            }
         } while(i != startsAt);
      }
      if (kind != 0x7fffffff)
      {
         jjmatchedKind = kind;
         jjmatchedPos = curPos;
         kind = 0x7fffffff;
      }
      ++curPos;
      if ((i = jjnewStateCnt) == (startsAt = 6 - (jjnewStateCnt = startsAt)))
         return curPos;
      try { curChar = input_stream.readChar(); }
      catch(java.io.IOException e) { return curPos; }
   }
}
static final int[] jjnextStates = {
   36, 37, 39, 40, 43, 34, 45, 46, 28, 30, 31, 34, 38, 31, 34, 49, 
   50, 51, 51, 53, 50, 54, 55, 49, 50, 51, 54, 55, 32, 33, 41, 42, 
   1, 2, 3, 
};
private static final boolean jjCanMove_0(int hiByte, int i1, int i2, long l1, long l2)
{
   switch(hiByte)
   {
      case 0:
         return ((jjbitVec2[i2] & l2) != 0L);
      default :
         if ((jjbitVec0[i1] & l1) != 0L)
            return true;
         return false;
   }
}

/** Token literal values. */
public static final String[] jjstrLiteralImages = {
"", "\157\162", "\141\156\144", "\156\157\164", "\41", "\75", "\75\75", 
"\41\75", "\74\76", "\74\75", "\74", "\76", "\76\75", "\154\151\153\145", 
"\154\151\153\145\111\147\156\157\162\145\103\141\163\145", "\151\156", "\50", "\51", "\142\145\164\167\145\145\156", "\54", "\174", 
"\136", "\46", "\74\74", "\76\76", "\53", "\55", "\57", "\176", null, null, null, null, 
null, null, null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, null, "\44", "\157\142\152\72", "\144\142\72", 
"\145\156\165\155\72", "\52", null, null, null, null, null, null, null, null, null, null, null, null, 
null, null, null, null, null, null, };

/** Lexer state names. */
public static final String[] lexStateNames = {
   "DEFAULT",
   "WithinSingleQuoteLiteral",
   "WithinDoubleQuoteLiteral",
};

/** Lex State array. */
public static final int[] jjnewLexState = {
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 
   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1, 2, -1, -1, 0, -1, -1, 0, -1, -1, -1, -1, 
   -1, -1, 
};
static final long[] jjtoToken = {
   0x1ffffffe1fffffffL, 0x1c8L, 
};
static final long[] jjtoSkip = {
   0x1e0000000L, 0x0L, 
};
static final long[] jjtoMore = {
   0x8000000000000000L, 0x37L, 
};
protected JavaCharStream input_stream;
private final int[] jjrounds = new int[56];
private final int[] jjstateSet = new int[112];
private final StringBuilder jjimage = new StringBuilder();
private StringBuilder image = jjimage;
private int jjimageLen;
private int lengthOfMatch;
protected char curChar;
/** Constructor. */
public ExpressionParserTokenManager(JavaCharStream stream){
   if (JavaCharStream.staticFlag)
      throw new Error("ERROR: Cannot use a static CharStream class with a non-static lexical analyzer.");
   input_stream = stream;
}

/** Constructor. */
public ExpressionParserTokenManager(JavaCharStream stream, int lexState){
   this(stream);
   SwitchTo(lexState);
}

/** Reinitialise parser. */
public void ReInit(JavaCharStream stream)
{
   jjmatchedPos = jjnewStateCnt = 0;
   curLexState = defaultLexState;
   input_stream = stream;
   ReInitRounds();
}
private void ReInitRounds()
{
   int i;
   jjround = 0x80000001;
   for (i = 56; i-- > 0;)
      jjrounds[i] = 0x80000000;
}

/** Reinitialise parser. */
public void ReInit(JavaCharStream stream, int lexState)
{
   ReInit(stream);
   SwitchTo(lexState);
}

/** Switch to specified lex state. */
public void SwitchTo(int lexState)
{
   if (lexState >= 3 || lexState < 0)
      throw new TokenMgrError("Error: Ignoring invalid lexical state : " + lexState + ". State unchanged.", TokenMgrError.INVALID_LEXICAL_STATE);
   else
      curLexState = lexState;
}

protected Token jjFillToken()
{
   final Token t;
   final String curTokenImage;
   final int beginLine;
   final int endLine;
   final int beginColumn;
   final int endColumn;
   String im = jjstrLiteralImages[jjmatchedKind];
   curTokenImage = (im == null) ? input_stream.GetImage() : im;
   beginLine = input_stream.getBeginLine();
   beginColumn = input_stream.getBeginColumn();
   endLine = input_stream.getEndLine();
   endColumn = input_stream.getEndColumn();
   t = Token.newToken(jjmatchedKind, curTokenImage);

   t.beginLine = beginLine;
   t.endLine = endLine;
   t.beginColumn = beginColumn;
   t.endColumn = endColumn;

   return t;
}

int curLexState = 0;
int defaultLexState = 0;
int jjnewStateCnt;
int jjround;
int jjmatchedPos;
int jjmatchedKind;

/** Get the next Token. */
public Token getNextToken() 
{
  Token matchedToken;
  int curPos = 0;

  EOFLoop :
  for (;;)
  {
   try
   {
      curChar = input_stream.BeginToken();
   }
   catch(java.io.IOException e)
   {
      jjmatchedKind = 0;
      matchedToken = jjFillToken();
      return matchedToken;
   }
   image = jjimage;
   image.setLength(0);
   jjimageLen = 0;

   for (;;)
   {
     switch(curLexState)
     {
       case 0:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_0();
         break;
       case 1:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_1();
         break;
       case 2:
         jjmatchedKind = 0x7fffffff;
         jjmatchedPos = 0;
         curPos = jjMoveStringLiteralDfa0_2();
         break;
     }
     if (jjmatchedKind != 0x7fffffff)
     {
        if (jjmatchedPos + 1 < curPos)
           input_stream.backup(curPos - jjmatchedPos - 1);
        if ((jjtoToken[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
        {
           matchedToken = jjFillToken();
           TokenLexicalActions(matchedToken);
       if (jjnewLexState[jjmatchedKind] != -1)
         curLexState = jjnewLexState[jjmatchedKind];
           return matchedToken;
        }
        else if ((jjtoSkip[jjmatchedKind >> 6] & (1L << (jjmatchedKind & 077))) != 0L)
        {
         if (jjnewLexState[jjmatchedKind] != -1)
           curLexState = jjnewLexState[jjmatchedKind];
           continue EOFLoop;
        }
        MoreLexicalActions();
      if (jjnewLexState[jjmatchedKind] != -1)
        curLexState = jjnewLexState[jjmatchedKind];
        curPos = 0;
        jjmatchedKind = 0x7fffffff;
        try {
           curChar = input_stream.readChar();
           continue;
        }
        catch (java.io.IOException e1) { }
     }
     int error_line = input_stream.getEndLine();
     int error_column = input_stream.getEndColumn();
     String error_after = null;
     boolean EOFSeen = false;
     try { input_stream.readChar(); input_stream.backup(1); }
     catch (java.io.IOException e1) {
        EOFSeen = true;
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
        if (curChar == '\n' || curChar == '\r') {
           error_line++;
           error_column = 0;
        }
        else
           error_column++;
     }
     if (!EOFSeen) {
        input_stream.backup(1);
        error_after = curPos <= 1 ? "" : input_stream.GetImage();
     }
     throw new TokenMgrError(EOFSeen, curLexState, error_line, error_column, error_after, curChar, TokenMgrError.LEXICAL_ERROR);
   }
  }
}

void MoreLexicalActions()
{
   jjimageLen += (lengthOfMatch = jjmatchedPos + 1);
   switch(jjmatchedKind)
   {
      case 63 :
         image.append(input_stream.GetSuffix(jjimageLen));
         jjimageLen = 0;
           stringBuffer = new StringBuffer();
         break;
      case 64 :
         image.append(input_stream.GetSuffix(jjimageLen));
         jjimageLen = 0;
            stringBuffer = new StringBuffer();
         break;
      case 65 :
         image.append(input_stream.GetSuffix(jjimageLen));
         jjimageLen = 0;
          stringBuffer.append( escapeChar() );
         break;
      case 66 :
         image.append(input_stream.GetSuffix(jjimageLen));
         jjimageLen = 0;
          stringBuffer.append( image.charAt(image.length()-1) );
         break;
      case 68 :
         image.append(input_stream.GetSuffix(jjimageLen));
         jjimageLen = 0;
          stringBuffer.append( escapeChar() );
         break;
      case 69 :
         image.append(input_stream.GetSuffix(jjimageLen));
         jjimageLen = 0;
          stringBuffer.append( image.charAt(image.length()-1) );
         break;
      default :
         break;
   }
}
void TokenLexicalActions(Token matchedToken)
{
   switch(jjmatchedKind)
   {
      case 67 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
          literalValue = stringBuffer.toString();
         break;
      case 70 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
          literalValue = stringBuffer.toString();
         break;
      case 71 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
          literalValue = makeInt();
         break;
      case 72 :
        image.append(input_stream.GetSuffix(jjimageLen + (lengthOfMatch = jjmatchedPos + 1)));
          literalValue = makeFloat();
         break;
      default :
         break;
   }
}
private void jjCheckNAdd(int state)
{
   if (jjrounds[state] != jjround)
   {
      jjstateSet[jjnewStateCnt++] = state;
      jjrounds[state] = jjround;
   }
}
private void jjAddStates(int start, int end)
{
   do {
      jjstateSet[jjnewStateCnt++] = jjnextStates[start];
   } while (start++ != end);
}
private void jjCheckNAddTwoStates(int state1, int state2)
{
   jjCheckNAdd(state1);
   jjCheckNAdd(state2);
}

private void jjCheckNAddStates(int start, int end)
{
   do {
      jjCheckNAdd(jjnextStates[start]);
   } while (start++ != end);
}

}
