/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.velocity;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.jdbc.SQLParameterBinding;
import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.velocity.BindDirective;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.parser.node.Node;

public class BindObjectEqualDirective
extends BindDirective {
    @Override
    public String getName() {
        return "bindObjectEqual";
    }

    @Override
    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        Object object = this.getChild(context, node, 0);
        Map idMap = this.toIdMap(object);
        Object[] sqlColumns = this.getChild(context, node, 1);
        Object[] idColumns = this.getChild(context, node, 2);
        if (idMap == null) {
            if (sqlColumns == null || idColumns == null) {
                throw new ParseErrorException("Invalid parameters. Either object has to be set or sqlColumns and idColumns or both.");
            }
            idMap = Collections.EMPTY_MAP;
        } else if (sqlColumns == null || idColumns == null) {
            idColumns = sqlColumns = idMap.keySet().toArray();
        }
        Object[] sqlColumnsArray = this.toArray(sqlColumns);
        Object[] idColumnsArray = this.toArray(idColumns);
        if (sqlColumnsArray.length != idColumnsArray.length) {
            throw new ParseErrorException("SQL columns and ID columns arrays have different sizes.");
        }
        for (int i = 0; i < sqlColumnsArray.length; ++i) {
            Object value = idMap.get(idColumnsArray[i]);
            int jdbcType = value != null ? TypesMapping.getSqlTypeByJava(value.getClass()) : 4;
            this.renderColumn(context, writer, sqlColumnsArray[i], i);
            writer.write(32);
            this.render(context, writer, new SQLParameterBinding(value, jdbcType, -1));
        }
        return true;
    }

    protected Object[] toArray(Object columns) {
        if (columns instanceof Collection) {
            return ((Collection)columns).toArray();
        }
        if (columns.getClass().isArray()) {
            return (Object[])columns;
        }
        return new Object[]{columns};
    }

    protected Map toIdMap(Object object) throws ParseErrorException {
        if (object instanceof Persistent) {
            return ((Persistent)object).getObjectId().getIdSnapshot();
        }
        if (object instanceof ObjectId) {
            return ((ObjectId)object).getIdSnapshot();
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        if (object != null) {
            throw new ParseErrorException("Invalid object parameter, expected Persistent or ObjectId or null: " + object);
        }
        return null;
    }

    protected void renderColumn(InternalContextAdapter context, Writer writer, Object columnName, int columnIndex) throws IOException {
        if (columnIndex > 0) {
            writer.write(" AND ");
        }
        writer.write(columnName.toString());
    }

    @Override
    protected void render(InternalContextAdapter context, Writer writer, SQLParameterBinding binding) throws IOException {
        if (binding.getValue() != null) {
            this.bind(context, binding);
            writer.write("= ?");
        } else {
            writer.write("IS NULL");
        }
    }
}

