/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.QueryResult;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.IndirectQuery;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.util.QueryResultBuilder;

public class SQLExec
extends IndirectQuery {
    private static final long serialVersionUID = -6533566707148045615L;
    protected String dataMapName;
    protected StringBuilder sqlBuffer;
    protected Map<String, Object> params;
    protected List<Object> positionalParams;

    public static SQLExec query(String sql) {
        return new SQLExec(sql);
    }

    public static SQLExec query(String dataMapName, String sql) {
        SQLExec query = new SQLExec(sql);
        query.dataMapName = dataMapName;
        return query;
    }

    public SQLExec(String sql) {
        this.sqlBuffer = sql != null ? new StringBuilder(sql) : new StringBuilder();
    }

    public String getSql() {
        String sql = this.sqlBuffer.toString();
        return sql.length() > 0 ? sql : null;
    }

    public SQLExec append(String sqlChunk) {
        this.sqlBuffer.append(sqlChunk);
        this.replacementQuery = null;
        return this;
    }

    public SQLExec params(String name, Object value) {
        this.params(Collections.singletonMap(name, value));
        return this;
    }

    public SQLExec params(Map<String, ?> parameters) {
        if (this.params == null) {
            this.params = new HashMap(parameters);
        } else {
            Map<String, ?> bareMap = parameters;
            this.params.putAll(bareMap);
        }
        this.replacementQuery = null;
        this.positionalParams = null;
        return this;
    }

    public SQLExec paramsArray(Object ... params) {
        return this.paramsList(params != null ? Arrays.asList(params) : null);
    }

    public SQLExec paramsList(List<Object> params) {
        this.params = null;
        this.positionalParams = params;
        return this;
    }

    public Map<String, Object> getParams() {
        return this.params != null ? this.params : Collections.emptyMap();
    }

    public List<Object> getPositionalParams() {
        return this.positionalParams != null ? this.positionalParams : Collections.emptyList();
    }

    public QueryResult execute(ObjectContext context) {
        QueryResponse response = context.performGenericQuery(this);
        QueryResultBuilder builder = QueryResultBuilder.builder(response.size());
        response.reset();
        while (response.next()) {
            if (response.isList()) {
                builder.addSelectResult(response.currentList());
                continue;
            }
            builder.addBatchUpdateResult(response.currentUpdateCount());
        }
        return builder.build();
    }

    public int update(ObjectContext context) {
        QueryResult results = this.execute(context);
        if (results.size() != 1) {
            throw new CayenneRuntimeException("Expected a single update result. Got a total of " + results.size(), new Object[0]);
        }
        return results.firstUpdateCount();
    }

    public int[] updateBatch(ObjectContext context) {
        QueryResult results = this.execute(context);
        if (results.size() != 1) {
            throw new CayenneRuntimeException("Expected a single update result. Got a total of " + results.size(), new Object[0]);
        }
        return results.firstBatchUpdateCount();
    }

    @Override
    protected Query createReplacementQuery(EntityResolver resolver) {
        DataMap root;
        if (this.dataMapName != null) {
            DataMap map = resolver.getDataMap(this.dataMapName);
            if (map == null) {
                throw new CayenneRuntimeException("Invalid dataMapName '%s'", this.dataMapName);
            }
            root = map;
        } else {
            root = null;
        }
        SQLTemplate template = new SQLTemplate();
        template.setRoot(root);
        template.setDefaultTemplate(this.getSql());
        if (this.positionalParams != null) {
            template.setParamsList(this.positionalParams);
        } else {
            template.setParams(this.params);
        }
        return template;
    }
}

