/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ResultBatchIterator;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.ResultIteratorCallback;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.IndirectQuery;
import org.apache.cayenne.query.Ordering;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.Select;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.query.SortOrder;

public class ObjectSelect<T>
extends IndirectQuery
implements Select<T> {
    private static final long serialVersionUID = -156124021150949227L;
    private boolean fetchingDataRows;
    private Class<?> entityType;
    private String entityName;
    private String dbEntityName;
    private Expression where;
    private Collection<Ordering> orderings;
    private PrefetchTreeNode prefetches;
    private int limit;
    private int offset;
    private int pageSize;
    private int statementFetchSize;
    private QueryCacheStrategy cacheStrategy;
    private String[] cacheGroups;

    public static <T> ObjectSelect<T> query(Class<T> entityType) {
        return new ObjectSelect<T>().entityType(entityType);
    }

    public static <T> ObjectSelect<T> query(Class<T> entityType, Expression expression) {
        return new ObjectSelect<T>().entityType(entityType).where(expression);
    }

    public static <T> ObjectSelect<T> query(Class<T> entityType, Expression expression, List<Ordering> orderings) {
        return new ObjectSelect<T>().entityType(entityType).where(expression).orderBy(orderings);
    }

    public static ObjectSelect<DataRow> dataRowQuery(Class<?> entityType) {
        return ObjectSelect.query(entityType).fetchDataRows();
    }

    public static ObjectSelect<DataRow> dataRowQuery(Class<?> entityType, Expression expression) {
        return ObjectSelect.query(entityType).fetchDataRows().where(expression);
    }

    public static <T> ObjectSelect<T> query(Class<T> resultType, String entityName) {
        return new ObjectSelect<T>().entityName(entityName);
    }

    public static ObjectSelect<DataRow> dbQuery(String dbEntityName) {
        return new ObjectSelect().fetchDataRows().dbEntityName(dbEntityName);
    }

    public static ObjectSelect<DataRow> dbQuery(String dbEntityName, Expression expression) {
        return new ObjectSelect().fetchDataRows().dbEntityName(dbEntityName).where(expression);
    }

    protected ObjectSelect() {
    }

    @Override
    protected Query createReplacementQuery(EntityResolver resolver) {
        SelectQuery replacement = new SelectQuery();
        if (this.entityType != null) {
            replacement.setRoot(this.entityType);
        } else if (this.entityName != null) {
            ObjEntity entity = resolver.getObjEntity(this.entityName);
            if (entity == null) {
                throw new CayenneRuntimeException("Unrecognized ObjEntity name: " + this.entityName, new Object[0]);
            }
            replacement.setRoot(entity);
        } else if (this.dbEntityName != null) {
            DbEntity entity = resolver.getDbEntity(this.dbEntityName);
            if (entity == null) {
                throw new CayenneRuntimeException("Unrecognized DbEntity name: " + this.dbEntityName, new Object[0]);
            }
            replacement.setRoot(entity);
        } else {
            throw new CayenneRuntimeException("Undefined root entity of the query", new Object[0]);
        }
        replacement.setFetchingDataRows(this.fetchingDataRows);
        replacement.setQualifier(this.where);
        replacement.addOrderings(this.orderings);
        replacement.setPrefetchTree(this.prefetches);
        replacement.setCacheStrategy(this.cacheStrategy);
        replacement.setCacheGroups(this.cacheGroups);
        replacement.setFetchLimit(this.limit);
        replacement.setFetchOffset(this.offset);
        replacement.setPageSize(this.pageSize);
        replacement.setStatementFetchSize(this.statementFetchSize);
        return replacement;
    }

    public ObjectSelect<T> entityType(Class<?> entityType) {
        return this.resetEntity(entityType, null, null);
    }

    public ObjectSelect<T> entityName(String entityName) {
        return this.resetEntity(null, entityName, null);
    }

    public ObjectSelect<T> dbEntityName(String dbEntityName) {
        return this.resetEntity(null, null, dbEntityName);
    }

    private ObjectSelect<T> resetEntity(Class<?> entityType, String entityName, String dbEntityName) {
        this.entityType = entityType;
        this.entityName = entityName;
        this.dbEntityName = dbEntityName;
        return this;
    }

    public ObjectSelect<DataRow> fetchDataRows() {
        this.fetchingDataRows = true;
        return this;
    }

    public ObjectSelect<T> where(Expression expression) {
        this.and(expression);
        return this;
    }

    public ObjectSelect<T> where(String expressionString, Object ... parameters) {
        this.and(ExpressionFactory.exp(expressionString, parameters));
        return this;
    }

    public ObjectSelect<T> and(Expression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        return this.and(Arrays.asList(expressions));
    }

    public ObjectSelect<T> and(Collection<Expression> expressions) {
        Collection<Expression> all;
        if (expressions == null || expressions.isEmpty()) {
            return this;
        }
        if (this.where != null) {
            all = new ArrayList<Expression>(expressions.size() + 1);
            all.add(this.where);
            all.addAll(expressions);
        } else {
            all = expressions;
        }
        this.where = ExpressionFactory.and(all);
        return this;
    }

    public ObjectSelect<T> or(Expression ... expressions) {
        if (expressions == null || expressions.length == 0) {
            return this;
        }
        return this.or(Arrays.asList(expressions));
    }

    public ObjectSelect<T> or(Collection<Expression> expressions) {
        Collection<Expression> all;
        if (expressions == null || expressions.isEmpty()) {
            return this;
        }
        if (this.where != null) {
            all = new ArrayList<Expression>(expressions.size() + 1);
            all.add(this.where);
            all.addAll(expressions);
        } else {
            all = expressions;
        }
        this.where = ExpressionFactory.or(all);
        return this;
    }

    public ObjectSelect<T> orderBy(String property) {
        return this.orderBy(new Ordering(property));
    }

    public ObjectSelect<T> orderBy(String property, SortOrder sortOrder) {
        return this.orderBy(new Ordering(property, sortOrder));
    }

    public ObjectSelect<T> orderBy(Ordering ... orderings) {
        if (orderings == null || orderings == null) {
            return this;
        }
        if (this.orderings == null) {
            this.orderings = new ArrayList<Ordering>(orderings.length);
        }
        for (Ordering o : orderings) {
            this.orderings.add(o);
        }
        return this;
    }

    public ObjectSelect<T> orderBy(Collection<Ordering> orderings) {
        if (orderings == null || orderings == null) {
            return this;
        }
        if (this.orderings == null) {
            this.orderings = new ArrayList<Ordering>(orderings.size());
        }
        this.orderings.addAll(orderings);
        return this;
    }

    public ObjectSelect<T> prefetch(PrefetchTreeNode prefetch) {
        if (prefetch == null) {
            return this;
        }
        if (this.prefetches == null) {
            this.prefetches = new PrefetchTreeNode();
        }
        this.prefetches.merge(prefetch);
        return this;
    }

    public ObjectSelect<T> prefetch(String path, int semantics) {
        if (path == null) {
            return this;
        }
        if (this.prefetches == null) {
            this.prefetches = new PrefetchTreeNode();
        }
        this.prefetches.addPath(path).setSemantics(semantics);
        return this;
    }

    public ObjectSelect<T> limit(int fetchLimit) {
        if (this.limit != fetchLimit) {
            this.limit = fetchLimit;
            this.replacementQuery = null;
        }
        return this;
    }

    public ObjectSelect<T> offset(int fetchOffset) {
        if (this.offset != fetchOffset) {
            this.offset = fetchOffset;
            this.replacementQuery = null;
        }
        return this;
    }

    public ObjectSelect<T> pageSize(int pageSize) {
        if (this.pageSize != pageSize) {
            this.pageSize = pageSize;
            this.replacementQuery = null;
        }
        return this;
    }

    public ObjectSelect<T> statementFetchSize(int size) {
        if (this.statementFetchSize != size) {
            this.statementFetchSize = size;
            this.replacementQuery = null;
        }
        return this;
    }

    public ObjectSelect<T> cacheStrategy(QueryCacheStrategy strategy, String ... cacheGroups) {
        if (this.cacheStrategy != strategy) {
            this.cacheStrategy = strategy;
            this.replacementQuery = null;
        }
        return this.cacheGroups(cacheGroups);
    }

    public ObjectSelect<T> cacheGroups(String ... cacheGroups) {
        this.cacheGroups = cacheGroups != null && cacheGroups.length > 0 ? cacheGroups : null;
        this.replacementQuery = null;
        return this;
    }

    public ObjectSelect<T> cacheGroups(Collection<String> cacheGroups) {
        if (cacheGroups == null) {
            return this.cacheGroups(new String[]{null});
        }
        String[] array = new String[cacheGroups.size()];
        return this.cacheGroups(cacheGroups.toArray(array));
    }

    public ObjectSelect<T> localCache(String ... cacheGroups) {
        return this.cacheStrategy(QueryCacheStrategy.LOCAL_CACHE, cacheGroups);
    }

    public ObjectSelect<T> sharedCache(String ... cacheGroups) {
        return this.cacheStrategy(QueryCacheStrategy.SHARED_CACHE, cacheGroups);
    }

    public String[] getCacheGroups() {
        return this.cacheGroups;
    }

    public QueryCacheStrategy getCacheStrategy() {
        return this.cacheStrategy;
    }

    public int getStatementFetchSize() {
        return this.statementFetchSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isFetchingDataRows() {
        return this.fetchingDataRows;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getDbEntityName() {
        return this.dbEntityName;
    }

    public Expression getWhere() {
        return this.where;
    }

    public Collection<Ordering> getOrderings() {
        return this.orderings;
    }

    public PrefetchTreeNode getPrefetches() {
        return this.prefetches;
    }

    @Override
    public List<T> select(ObjectContext context) {
        return context.select(this);
    }

    @Override
    public T selectOne(ObjectContext context) {
        return context.selectOne(this);
    }

    @Override
    public T selectFirst(ObjectContext context) {
        return context.selectFirst(this.limit(1));
    }

    @Override
    public void iterate(ObjectContext context, ResultIteratorCallback<T> callback) {
        context.iterate(this, callback);
    }

    @Override
    public ResultIterator<T> iterator(ObjectContext context) {
        return context.iterator(this);
    }

    @Override
    public ResultBatchIterator<T> batchIterator(ObjectContext context, int size) {
        return context.batchIterator(this, size);
    }
}

