/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.log;

import java.lang.reflect.Array;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ExtendedEnumeration;
import org.apache.cayenne.access.jdbc.SQLParameterBinding;
import org.apache.cayenne.access.translator.DbAttributeBinding;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.conn.DataSourceInfo;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.log.JdbcEventLogger;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.util.IDUtil;
import org.apache.cayenne.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommonsJdbcEventLogger
implements JdbcEventLogger {
    private static final Log logger = LogFactory.getLog(CommonsJdbcEventLogger.class);
    private static final int TRIM_VALUES_THRESHOLD = 30;
    protected long queryExecutionTimeLoggingThreshold;

    public CommonsJdbcEventLogger(@Inject RuntimeProperties runtimeProperties) {
        this.queryExecutionTimeLoggingThreshold = runtimeProperties.getLong("cayenne.server.query_execution_time_logging_threshold", 0L);
    }

    void sqlLiteralForObject(StringBuilder buffer, Object object) {
        if (object == null) {
            buffer.append("NULL");
        } else if (object instanceof String) {
            buffer.append('\'');
            String literal = (String)object;
            if (literal.length() > 30) {
                literal = literal.substring(0, 30) + "...";
            }
            int curPos = 0;
            int endPos = 0;
            while ((endPos = literal.indexOf(39, curPos)) >= 0) {
                buffer.append(literal.substring(curPos, endPos + 1)).append('\'');
                curPos = endPos + 1;
            }
            if (curPos < literal.length()) {
                buffer.append(literal.substring(curPos));
            }
            buffer.append('\'');
        } else if (object instanceof Byte) {
            IDUtil.appendFormattedByte(buffer, (Byte)object);
        } else if (object instanceof Number) {
            buffer.append(object);
        } else if (object instanceof Date) {
            buffer.append('\'').append(object).append('\'');
        } else if (object instanceof Time) {
            buffer.append('\'').append(object).append('\'');
        } else if (object instanceof java.util.Date) {
            long time = ((java.util.Date)object).getTime();
            buffer.append('\'').append(new Timestamp(time)).append('\'');
        } else if (object instanceof Calendar) {
            long time = ((Calendar)object).getTimeInMillis();
            buffer.append(object.getClass().getName()).append('(').append(new Timestamp(time)).append(')');
        } else if (object instanceof Character) {
            buffer.append(((Character)object).charValue());
        } else if (object instanceof Boolean) {
            buffer.append('\'').append(object).append('\'');
        } else if (object instanceof Enum) {
            buffer.append(((Enum)object).name()).append("=");
            if (object instanceof ExtendedEnumeration) {
                Object value = ((ExtendedEnumeration)object).getDatabaseValue();
                if (value instanceof String) {
                    buffer.append("'");
                }
                buffer.append(value);
                if (value instanceof String) {
                    buffer.append("'");
                }
            } else {
                buffer.append(((Enum)object).ordinal());
            }
        } else if (object instanceof SQLParameterBinding) {
            this.sqlLiteralForObject(buffer, ((SQLParameterBinding)object).getValue());
        } else if (object.getClass().isArray()) {
            buffer.append("< ");
            int len = Array.getLength(object);
            boolean trimming = false;
            if (len > 30) {
                len = 30;
                trimming = true;
            }
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                this.sqlLiteralForObject(buffer, Array.get(object, i));
            }
            if (trimming) {
                buffer.append("...");
            }
            buffer.append('>');
        } else {
            buffer.append(object.getClass().getName()).append("@").append(System.identityHashCode(object));
        }
    }

    @Override
    public void log(String message) {
        if (message != null) {
            logger.info((Object)message);
        }
    }

    @Override
    @Deprecated
    public void logConnect(String dataSource) {
        if (this.isLoggable()) {
            logger.info((Object)("Connecting. JNDI path: " + dataSource));
        }
    }

    @Override
    @Deprecated
    public void logConnect(String url, String userName, String password) {
        if (this.isLoggable()) {
            StringBuilder buf = new StringBuilder("Opening connection: ");
            buf.append(url);
            buf.append("\n\tLogin: ").append(userName);
            buf.append("\n\tPassword: *******");
            logger.info((Object)buf.toString());
        }
    }

    @Override
    @Deprecated
    public void logPoolCreated(DataSourceInfo dsi) {
        if (this.isLoggable()) {
            StringBuilder buf = new StringBuilder("Created connection pool: ");
            if (dsi != null) {
                buf.append(dsi.getDataSourceUrl());
                if (dsi.getAdapterClassName() != null) {
                    buf.append("\n\tCayenne DbAdapter: ").append(dsi.getAdapterClassName());
                }
                buf.append("\n\tDriver class: ").append(dsi.getJdbcDriver());
                if (dsi.getMinConnections() >= 0) {
                    buf.append("\n\tMin. connections in the pool: ").append(dsi.getMinConnections());
                }
                if (dsi.getMaxConnections() >= 0) {
                    buf.append("\n\tMax. connections in the pool: ").append(dsi.getMaxConnections());
                }
            } else {
                buf.append(" pool information unavailable");
            }
            logger.info((Object)buf.toString());
        }
    }

    @Override
    @Deprecated
    public void logConnectSuccess() {
        logger.info((Object)"+++ Connecting: SUCCESS.");
    }

    @Override
    @Deprecated
    public void logConnectFailure(Throwable th) {
        logger.info((Object)"*** Connecting: FAILURE.", th);
    }

    @Override
    public void logGeneratedKey(DbAttribute attribute, Object value) {
        if (this.isLoggable()) {
            String entity = attribute.getEntity().getName();
            String key = attribute.getName();
            logger.info((Object)("Generated PK: " + entity + "." + key + " = " + value));
        }
    }

    @Override
    @Deprecated
    public void logQuery(String queryStr, List<?> params) {
        this.logQuery(queryStr, null, params, -1L);
    }

    @Deprecated
    private void buildLog(StringBuilder buffer, String prefix, String postfix, List<DbAttribute> attributes, List<?> parameters, boolean isInserting) {
        if (parameters != null && parameters.size() > 0) {
            Iterator<DbAttribute> attributeIterator = null;
            int position = 0;
            if (attributes != null) {
                attributeIterator = attributes.iterator();
            }
            for (Object parameter : parameters) {
                if (position++ == 0) {
                    buffer.append(prefix);
                } else {
                    buffer.append(", ");
                }
                DbAttribute attribute = null;
                while (attributeIterator != null && attributeIterator.hasNext()) {
                    attribute = attributeIterator.next();
                    if (isInserting && attribute.isGenerated()) continue;
                }
                buffer.append(position);
                if (attribute != null) {
                    buffer.append("->");
                    buffer.append(attribute.getName());
                }
                buffer.append(":");
                this.sqlLiteralForObject(buffer, parameter);
            }
            buffer.append(postfix);
        }
    }

    private boolean isInserting(String query) {
        if (query == null || query.length() == 0) {
            return false;
        }
        char firstCharacter = query.charAt(0);
        return firstCharacter == 'I' || firstCharacter == 'i';
    }

    @Override
    public void logQuery(String sql, DbAttributeBinding[] bindings, long translatedIn) {
        if (this.isLoggable()) {
            StringBuilder buffer = new StringBuilder(sql).append(" ");
            this.appendParameters(buffer, "bind", bindings);
            if (buffer.length() > 0) {
                logger.info((Object)buffer.toString());
            }
        }
    }

    @Override
    @Deprecated
    public void logQuery(String queryStr, List<DbAttribute> attrs, List<?> params, long time) {
        if (this.isLoggable()) {
            StringBuilder buffer = new StringBuilder(queryStr);
            this.buildLog(buffer, " [bind: ", "]", attrs, params, this.isInserting(queryStr));
            if (time > 5L) {
                buffer.append(" - prepared in ").append(time).append(" ms.");
            }
            logger.info((Object)buffer.toString());
        }
    }

    @Override
    @Deprecated
    public void logQueryParameters(String label, List<DbAttribute> attrs, List<Object> parameters, boolean isInserting) {
        String prefix = "[" + label + ": ";
        if (this.isLoggable() && parameters.size() > 0) {
            StringBuilder buffer = new StringBuilder();
            this.buildLog(buffer, prefix, "]", attrs, parameters, isInserting);
            logger.info((Object)buffer.toString());
        }
    }

    @Override
    public void logQueryParameters(String label, DbAttributeBinding[] bindings) {
        if (this.isLoggable() && bindings.length > 0) {
            StringBuilder buffer = new StringBuilder();
            this.appendParameters(buffer, label, bindings);
            if (buffer.length() > 0) {
                logger.info((Object)buffer.toString());
            }
        }
    }

    private void appendParameters(StringBuilder buffer, String label, DbAttributeBinding[] bindings) {
        int len = bindings.length;
        if (len > 0) {
            boolean hasIncluded = false;
            int j = 1;
            for (int i = 0; i < len; ++i) {
                DbAttributeBinding b = bindings[i];
                if (b.isExcluded()) continue;
                if (hasIncluded) {
                    buffer.append(", ");
                } else {
                    hasIncluded = true;
                    buffer.append("[").append(label).append(": ");
                }
                DbAttribute attribute = b.getAttribute();
                buffer.append(j++);
                if (attribute != null) {
                    buffer.append("->");
                    buffer.append(attribute.getName());
                }
                buffer.append(":");
                this.sqlLiteralForObject(buffer, b.getValue());
            }
            if (hasIncluded) {
                buffer.append("]");
            }
        }
    }

    @Override
    public void logSelectCount(int count, long time) {
        this.logSelectCount(count, time, null);
    }

    @Override
    public void logSelectCount(int count, long time, String sql) {
        StringBuilder buf;
        if (this.isLoggable()) {
            buf = new StringBuilder();
            if (count == 1) {
                buf.append("=== returned 1 row.");
            } else {
                buf.append("=== returned ").append(count).append(" rows.");
            }
            if (time >= 0L) {
                buf.append(" - took ").append(time).append(" ms.");
            }
            logger.info((Object)buf.toString());
        }
        if (this.queryExecutionTimeLoggingThreshold > 0L && time > this.queryExecutionTimeLoggingThreshold) {
            buf = new StringBuilder();
            buf.append("Query time exceeded threshold (").append(time).append(" ms): ");
            buf.append(sql);
            String message = buf.toString();
            logger.warn((Object)message, (Throwable)new CayenneRuntimeException(message, new Object[0]));
        }
    }

    @Override
    public void logUpdateCount(int count) {
        if (this.isLoggable()) {
            if (count < 0) {
                logger.info((Object)"=== updated ? rows");
            } else {
                String countStr = count == 1 ? "=== updated 1 row." : "=== updated " + count + " rows.";
                logger.info((Object)countStr);
            }
        }
    }

    @Override
    public void logBeginTransaction(String transactionLabel) {
        logger.info((Object)("--- " + transactionLabel));
    }

    @Override
    public void logCommitTransaction(String transactionLabel) {
        logger.info((Object)("+++ " + transactionLabel));
    }

    @Override
    public void logRollbackTransaction(String transactionLabel) {
        logger.info((Object)("*** " + transactionLabel));
    }

    @Override
    public void logQueryError(Throwable th) {
        if (this.isLoggable()) {
            if (th != null) {
                th = Util.unwindException(th);
            }
            logger.info((Object)"*** error.", th);
            if (th instanceof SQLException) {
                for (SQLException sqlException = ((SQLException)th).getNextException(); sqlException != null; sqlException = sqlException.getNextException()) {
                    logger.info((Object)"*** nested SQL error.", (Throwable)sqlException);
                }
            }
        }
    }

    @Override
    public boolean isLoggable() {
        return logger.isInfoEnabled();
    }
}

