/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.util.Collection;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ASTFalse;
import org.apache.cayenne.exp.parser.ASTList;
import org.apache.cayenne.exp.parser.ASTPath;
import org.apache.cayenne.exp.parser.ConditionNode;
import org.apache.cayenne.exp.parser.Evaluator;
import org.apache.commons.collections.Transformer;

public class ASTIn
extends ConditionNode {
    private static final long serialVersionUID = -211084571117172965L;

    ASTIn(int id) {
        super(id);
    }

    public ASTIn() {
        super(14);
    }

    public ASTIn(ASTPath path, ASTList list) {
        super(14);
        this.jjtAddChild(path, 0);
        this.jjtAddChild(list, 1);
        this.connectChildren();
    }

    @Override
    protected Object evaluateNode(Object o) throws Exception {
        int len = this.jjtGetNumChildren();
        if (len != 2) {
            return Boolean.FALSE;
        }
        Object o1 = this.evaluateChild(0, o);
        if (o1 == null) {
            return Boolean.FALSE;
        }
        Object[] objects = (Object[])this.evaluateChild(1, o);
        if (objects == null) {
            return Boolean.FALSE;
        }
        int size = objects.length;
        for (int i = 0; i < size; ++i) {
            if (objects[i] == null) continue;
            if (o1 instanceof Collection) {
                for (Object obj : (Collection)o1) {
                    if (!Evaluator.evaluator(obj).eq(obj, objects[i])) continue;
                    return Boolean.TRUE;
                }
                continue;
            }
            if (!Evaluator.evaluator(o1).eq(o1, objects[i])) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Expression shallowCopy() {
        return new ASTIn(this.id);
    }

    @Override
    protected String getExpressionOperator(int index) {
        return "in";
    }

    @Override
    public int getType() {
        return 10;
    }

    @Override
    protected Object transformExpression(Transformer transformer) {
        ASTList list;
        Object[] objects;
        ASTIn exp;
        Object transformed = super.transformExpression(transformer);
        if (transformed instanceof ASTIn && (exp = (ASTIn)transformed).jjtGetNumChildren() == 2 && (objects = (Object[])(list = (ASTList)exp.jjtGetChild(1)).evaluate(null)).length == 0) {
            transformed = new ASTFalse();
        }
        return transformed;
    }
}

