/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbimport;

import java.io.IOException;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.dbimport.ReverseEngineering;
import org.apache.cayenne.dbimport.ReverseEngineeringWriter;
import org.apache.cayenne.resource.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultReverseEngineeringWriter
implements ReverseEngineeringWriter {
    private static final Log LOGGER = LogFactory.getLog(DefaultReverseEngineeringWriter.class);

    @Override
    public Resource write(ReverseEngineering reverseEngineering, Writer writer) throws CayenneRuntimeException {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{reverseEngineering.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.schemaLocation", (Object)"http://cayenne.apache.org/schema/8/reverseEngineering http://cayenne.apache.org/schema/8/reverseEngineering.xsd");
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.marshal((Object)reverseEngineering, writer);
            writer.close();
            return reverseEngineering.getConfigurationSource();
        }
        catch (IOException | JAXBException e) {
            LOGGER.error((Object)e.getMessage(), e);
            throw new CayenneRuntimeException(e);
        }
    }
}

