/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.postgres;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.translator.ParameterBinding;
import org.apache.cayenne.access.translator.select.QualifierTranslator;
import org.apache.cayenne.access.translator.select.QueryAssembler;
import org.apache.cayenne.access.translator.select.SelectTranslator;
import org.apache.cayenne.access.types.CharType;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dba.postgres.PostgresActionBuilder;
import org.apache.cayenne.dba.postgres.PostgresByteArrayType;
import org.apache.cayenne.dba.postgres.PostgresPkGenerator;
import org.apache.cayenne.dba.postgres.PostgresQualifierTranslator;
import org.apache.cayenne.dba.postgres.PostgresSelectTranslator;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SelectQuery;
import org.apache.cayenne.resource.ResourceLocator;

public class PostgresAdapter
extends JdbcAdapter {
    public static final String BYTEA = "bytea";

    public PostgresAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject(value="cayenne.server.resource_locator") ResourceLocator resourceLocator) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator);
        this.setSupportsBatchUpdates(true);
        this.setSupportsGeneratedKeys(true);
    }

    @Override
    public SelectTranslator getSelectTranslator(SelectQuery<?> query, EntityResolver entityResolver) {
        return new PostgresSelectTranslator(query, this, entityResolver);
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new PostgresActionBuilder(node));
    }

    @Override
    protected void configureExtendedTypes(ExtendedTypeMap map) {
        super.configureExtendedTypes(map);
        map.registerType(new CharType(true, false));
        map.registerType(new PostgresByteArrayType(true, true));
    }

    @Override
    public DbAttribute buildAttribute(String name, String typeName, int type, int size, int scale, boolean allowNulls) {
        if (BYTEA.equalsIgnoreCase(typeName)) {
            type = -4;
        } else if ("oid".equals(typeName)) {
            type = 2004;
        } else if ("text".equalsIgnoreCase(typeName)) {
            type = 2005;
        }
        return super.buildAttribute(name, typeName, type, size, scale, allowNulls);
    }

    @Override
    public void bindParameter(PreparedStatement statement, ParameterBinding binding) throws SQLException, Exception {
        binding.setType(this.mapNTypes(binding.getType()));
        super.bindParameter(statement, binding);
    }

    private int mapNTypes(int sqlType) {
        switch (sqlType) {
            case -15: {
                return 1;
            }
            case 2011: {
                return 2005;
            }
            case -9: {
                return 12;
            }
            case -16: {
                return -1;
            }
        }
        return sqlType;
    }

    @Override
    public String createTable(DbEntity ent) {
        QuotingStrategy context = this.getQuotingStrategy();
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE TABLE ").append(context.quotedFullyQualifiedName(ent)).append(" (");
        Iterator<DbAttribute> it = ent.getAttributes().iterator();
        boolean first = true;
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            this.createAttribute(ent, context, buf, it.next());
        }
        Iterator<DbAttribute> pkit = ent.getPrimaryKeys().iterator();
        if (pkit.hasNext()) {
            if (first) {
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append("PRIMARY KEY (");
            boolean firstPk = true;
            while (pkit.hasNext()) {
                if (firstPk) {
                    firstPk = false;
                } else {
                    buf.append(", ");
                }
                DbAttribute at = pkit.next();
                buf.append(context.quotedName(at));
            }
            buf.append(')');
        }
        buf.append(')');
        return buf.toString();
    }

    private void createAttribute(DbEntity ent, QuotingStrategy context, StringBuilder buf, DbAttribute at) {
        if (at.getType() == Integer.MAX_VALUE) {
            throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "'.", new Object[0]);
        }
        String[] types = this.externalTypesForJdbcType(at.getType());
        if (types == null || types.length == 0) {
            throw new CayenneRuntimeException("Undefined type for attribute '" + ent.getFullyQualifiedName() + "." + at.getName() + "': " + at.getType(), new Object[0]);
        }
        String type = at.isGenerated() && types.length > 1 ? types[1] : types[0];
        buf.append(context.quotedName(at)).append(' ').append(type).append(PostgresAdapter.sizeAndPrecision(this, at)).append(at.isMandatory() ? " NOT" : "").append(" NULL");
    }

    @Override
    public boolean typeSupportsLength(int type) {
        String[] externalTypes = this.externalTypesForJdbcType(type);
        if (externalTypes != null && externalTypes.length > 0) {
            for (String externalType : externalTypes) {
                if (!BYTEA.equalsIgnoreCase(externalType)) continue;
                return false;
            }
        }
        return super.typeSupportsLength(type);
    }

    @Override
    public Collection<String> dropTableStatements(DbEntity table) {
        QuotingStrategy context = this.getQuotingStrategy();
        return Collections.singleton("DROP TABLE " + context.quotedFullyQualifiedName(table) + " CASCADE");
    }

    @Override
    public QualifierTranslator getQualifierTranslator(QueryAssembler queryAssembler) {
        PostgresQualifierTranslator translator = new PostgresQualifierTranslator(queryAssembler);
        translator.setCaseInsensitive(this.caseInsensitiveCollations);
        return translator;
    }

    @Override
    protected PkGenerator createPkGenerator() {
        return new PostgresPkGenerator(this);
    }

    @Override
    public boolean supportsCatalogsOnReverseEngineering() {
        return false;
    }
}

