/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.types;

import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeDecorator;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ExtendedTypeMap;

class ByteOrCharArrayFactory
implements ExtendedTypeFactory {
    private ExtendedTypeMap map;

    ByteOrCharArrayFactory(ExtendedTypeMap map) {
        this.map = map;
    }

    @Override
    public ExtendedType getType(Class<?> objectClass) {
        if (objectClass.isArray()) {
            Class<?> elementType = objectClass.getComponentType();
            if (Character.class.isAssignableFrom(elementType)) {
                ExtendedType stringType = this.map.getExplictlyRegisteredType("java.lang.String");
                return new CharacterArrayType(stringType);
            }
            if (Character.TYPE.isAssignableFrom(elementType)) {
                ExtendedType stringType = this.map.getExplictlyRegisteredType("java.lang.String");
                return new CharArrayType(stringType);
            }
            if (Byte.class.isAssignableFrom(elementType)) {
                ExtendedType bytesType = this.map.getExplictlyRegisteredType("byte[]");
                return new ByteWrapperArrayType(bytesType);
            }
        } else if (Character.class.isAssignableFrom(objectClass)) {
            ExtendedType stringType = this.map.getExplictlyRegisteredType("java.lang.String");
            return new CharacterType(stringType);
        }
        return null;
    }

    final class ByteWrapperArrayType
    extends ExtendedTypeDecorator {
        ByteWrapperArrayType(ExtendedType byteArrayType) {
            super(byteArrayType);
        }

        @Override
        public String getClassName() {
            return "java.lang.Byte[]";
        }

        @Override
        Object fromJavaObject(Object object) {
            if (object == null) {
                return null;
            }
            Byte[] bytes = (Byte[])object;
            byte[] buffer = new byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                buffer[i] = bytes[i] != null ? bytes[i] : (byte)0;
            }
            return buffer;
        }

        @Override
        Object toJavaObject(Object object) {
            if (object == null) {
                return null;
            }
            byte[] bytes = (byte[])object;
            Byte[] byteWrappers = new Byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                byteWrappers[i] = bytes[i];
            }
            return byteWrappers;
        }
    }

    final class CharacterArrayType
    extends ExtendedTypeDecorator {
        CharacterArrayType(ExtendedType stringType) {
            super(stringType);
        }

        @Override
        public String getClassName() {
            return "java.lang.Character[]";
        }

        @Override
        Object fromJavaObject(Object object) {
            if (object == null) {
                return null;
            }
            Character[] chars = (Character[])object;
            StringBuilder buffer = new StringBuilder(chars.length);
            for (Character aChar : chars) {
                buffer.append(aChar != null ? aChar.charValue() : (char)'\u0000');
            }
            return buffer.toString();
        }

        @Override
        Object toJavaObject(Object object) {
            if (object == null) {
                return null;
            }
            String string = object.toString();
            Character[] chars = new Character[string.length()];
            for (int i = 0; i < string.length(); ++i) {
                chars[i] = Character.valueOf(string.charAt(i));
            }
            return chars;
        }
    }

    final class CharArrayType
    extends ExtendedTypeDecorator {
        CharArrayType(ExtendedType stringType) {
            super(stringType);
        }

        @Override
        public String getClassName() {
            return "char[]";
        }

        @Override
        Object fromJavaObject(Object object) {
            return object != null ? new String((char[])object) : null;
        }

        @Override
        Object toJavaObject(Object object) {
            return object != null ? ((String)object).toCharArray() : null;
        }
    }

    final class CharacterType
    extends ExtendedTypeDecorator {
        CharacterType(ExtendedType stringType) {
            super(stringType);
        }

        @Override
        public String getClassName() {
            return "java.lang.Character";
        }

        @Override
        Object fromJavaObject(Object object) {
            return object != null ? String.valueOf(((Character)object).charValue()) : null;
        }

        @Override
        Object toJavaObject(Object object) {
            if (object == null) {
                return null;
            }
            String string = object.toString();
            return string.length() > 0 ? Character.valueOf(string.charAt(0)) : null;
        }
    }
}

